let _ = Mltop.add_known_module "rocq-runtime.plugins.ltac"

# 13 "plugins/ltac/g_tactic.mlg"
 

open Pp
open CErrors
open Util
open Names
open Namegen
open Tacexpr
open Genredexpr
open Constrexpr
open Libnames
open Tok
open Tactypes
open Tactics
open Inv
open Locus
open G_redexpr

open Procq


let all_with ~head delta =
  let all = [FBeta;FMatch;FFix;FCofix;FZeta;delta] in
  Redops.make_red_flag (if head then FHead :: all else all)

let err () = raise Gramlib.Stream.Failure

(* Hack to parse "(x:=t)" as an explicit argument without conflicts with the *)
(* admissible notation "(x t)" *)
let test_lpar_id_coloneq =
  let open Procq.Lookahead in
  to_entry "lpar_id_coloneq" begin
    lk_kw "(" >> lk_ident >> lk_kw ":="
  end

(* Hack to recognize "(x)" *)
let test_lpar_id_rpar =
  let open Procq.Lookahead in
  to_entry "lpar_id_coloneq" begin
    lk_kw "(" >> lk_ident >> lk_kw ")"
  end

(* idem for (x:=t) and (1:=t) *)
let test_lpar_idnum_coloneq =
  let open Procq.Lookahead in
  to_entry "test_lpar_idnum_coloneq" begin
    lk_kw "(" >> (lk_ident <+> lk_nat) >> lk_kw ":="
  end

let test_leftsquarebracket_equal =
  let open Procq.Lookahead in
  to_entry "test_leftsquarebracket_equal" begin
    lk_kw "[" >> lk_kw "=" >> check_no_space
  end

(* idem for (x:t) *)
open Extraargs

(* idem for (x1..xn:t) [n^2 complexity but exceptional use] *)
let check_for_coloneq =
  Procq.Entry.(of_parser "lpar_id_colon"
    { parser_fun = fun kwstate strm ->
      let rec skip_to_rpar p n =
        match List.last (Gramlib.LStream.npeek kwstate n strm) with
        | KEYWORD "(" -> skip_to_rpar (p+1) (n+1)
        | KEYWORD ")" -> if Int.equal p 0 then n+1 else skip_to_rpar (p-1) (n+1)
        | KEYWORD "." -> err ()
        | _ -> skip_to_rpar p (n+1) in
      let rec skip_names n =
        match List.last (Gramlib.LStream.npeek kwstate n strm) with
        | IDENT _ | KEYWORD "_" -> skip_names (n+1)
        | KEYWORD ":" -> skip_to_rpar 0 (n+1) (* skip a constr *)
        | _ -> err () in
      let rec skip_binders n =
        match List.last (Gramlib.LStream.npeek kwstate n strm) with
        | KEYWORD "(" -> skip_binders (skip_names (n+1))
        | IDENT _ | KEYWORD "_" -> skip_binders (n+1)
        | KEYWORD ":=" -> ()
        | _ -> err () in
      match Gramlib.LStream.peek_nth kwstate 0 strm with
      | KEYWORD "(" -> skip_binders 2
      | _ -> err () })

let lookup_at_as_comma =
  let open Procq.Lookahead in
  to_entry "lookup_at_as_comma" begin
    lk_kws [",";"at";"as"]
  end

open Constr
open Prim
open Pltac

let mk_fix_tac (loc,id,bl,ann,ty) =
  let n =
    match bl,ann with
        [([_],_,_)], None -> 1
      | _, Some x ->
          let ids = List.map (fun x -> x.CAst.v) (List.flatten (List.map (fun (nal,_,_) -> nal) bl)) in
          (try List.index Names.Name.equal x.CAst.v ids
          with Not_found -> user_err ~loc Pp.(str "No such fix variable."))
      | _ -> user_err ~loc Pp.(str "Cannot guess decreasing argument of fix.") in
  let bl = List.map (fun (nal,bk,t) -> CLocalAssum (nal,None,bk,t)) bl in
  (id,n, CAst.make ~loc @@ CProdN(bl,ty))

let mk_cofix_tac (loc,id,bl,ann,ty) =
  let () = Option.iter (fun { CAst.loc = aloc } ->
      user_err ?loc:aloc
        (Pp.str"Annotation forbidden in cofix expression."))
      ann
  in
  let bl = List.map (fun (nal,bk,t) -> CLocalAssum (nal,None,bk,t)) bl in
  (id,if bl = [] then ty else CAst.make ~loc @@ CProdN(bl,ty))

(* Functions overloaded by quotifier *)
let destruction_arg_of_constr (c,lbind as clbind) = match lbind with
  | NoBindings ->
    begin
      try ElimOnIdent (CAst.make ?loc:(Constrexpr_ops.constr_loc c) (Constrexpr_ops.coerce_to_id c).CAst.v)
      with e when CErrors.noncritical e -> ElimOnConstr clbind
    end
  | _ -> ElimOnConstr clbind

let mkNumber n =
  Number (NumTok.Signed.of_int_string (string_of_int n))

let mkTacCase with_evar = function
  | [(clear,ElimOnConstr cl),(None,None),None],None ->
      TacCase (with_evar,(clear,cl))
  (* Reinterpret numbers as a notation for terms *)
  | [(clear,ElimOnAnonHyp n),(None,None),None],None ->
      TacCase (with_evar,
        (clear,(CAst.make @@ CPrim (mkNumber n),
         NoBindings)))
  (* Reinterpret ident as notations for variables in the context *)
  (* because we don't know if they are quantified or not *)
  | [(clear,ElimOnIdent id),(None,None),None],None ->
      TacCase (with_evar,(clear,(CAst.make @@ CRef (qualid_of_ident ?loc:id.CAst.loc id.CAst.v,None),NoBindings)))
  | ic ->
      if List.exists (function ((_, ElimOnAnonHyp _),_,_) -> true | _ -> false) (fst ic)
      then
        user_err Pp.(str "Use of numbers as direct arguments of 'case' is not supported.");
      TacInductionDestruct (false,with_evar,ic)

let rec mkCLambdaN_simple_loc ?loc bll c =
  match bll with
  | ({CAst.loc = loc1}::_ as idl,bk,t) :: bll ->
      CAst.make ?loc @@ CLambdaN ([CLocalAssum (idl,None,bk,t)],mkCLambdaN_simple_loc ?loc:(Loc.merge_opt loc1 loc) bll c)
  | ([],_,_) :: bll -> mkCLambdaN_simple_loc ?loc bll c
  | [] -> c

let mkCLambdaN_simple bl c = match bl with
  | [] -> c
  | h :: _ ->
    let loc = Loc.merge_opt (List.hd (pi1 h)).CAst.loc (Constrexpr_ops.constr_loc c) in
    mkCLambdaN_simple_loc ?loc bl c

let loc_of_ne_list l = Loc.merge_opt (List.hd l).CAst.loc (List.last l).CAst.loc

let all_concl_occs_clause = { onhyps=Some[]; concl_occs=AllOccurrences }

let merge_occurrences loc cl = function
  | None ->
      if Locusops.clause_with_generic_occurrences cl then (None, cl)
      else
        user_err ~loc (str "Found an \"at\" clause without \"with\" clause.")
  | Some (occs, p) ->
    let ans = match occs with
    | AllOccurrences -> cl
    | _ ->
      begin match cl with
      | { onhyps = Some []; concl_occs = AllOccurrences } ->
        { onhyps = Some []; concl_occs = occs }
      | { onhyps = Some [(AllOccurrences, id), l]; concl_occs = NoOccurrences } ->
        { cl with onhyps = Some [(occs, id), l] }
      | _ ->
        if Locusops.clause_with_generic_occurrences cl then
          user_err ~loc  (str "Unable to interpret the \"at\" clause; move it in the \"in\" clause.")
        else
          user_err ~loc  (str "Cannot use clause \"at\" twice.")
      end
    in
    (Some p, ans)

let deprecated_conversion_at_with =
  CWarnings.create
    ~name:"conversion_at_with" ~category:Deprecation.Version.v8_14
    (fun () -> Pp.str "The syntax [at ... with ...] is deprecated. Use [with ... at ...] instead.")

(* Auxiliary grammar rules *)


# 197 "plugins/ltac/g_tactic.ml"

let _ =
  let id_or_meta = Procq.Entry.make "id_or_meta"
  and constr_with_bindings_arg = Procq.Entry.make "constr_with_bindings_arg"
  and conversion = Procq.Entry.make "conversion"
  and intropatterns = Procq.Entry.make "intropatterns"
  and ne_intropatterns = Procq.Entry.make "ne_intropatterns"
  and or_and_intropattern = Procq.Entry.make "or_and_intropattern"
  and equality_intropattern = Procq.Entry.make "equality_intropattern"
  and naming_intropattern = Procq.Entry.make "naming_intropattern"
  and intropattern = Procq.Entry.make "intropattern"
  and simple_intropattern_closed =
    Procq.Entry.make "simple_intropattern_closed"
  and simple_binding = Procq.Entry.make "simple_binding"
  and with_bindings = Procq.Entry.make "with_bindings"
  and hypident_occ = Procq.Entry.make "hypident_occ"
  and clause_dft_all = Procq.Entry.make "clause_dft_all"
  and opt_clause = Procq.Entry.make "opt_clause"
  and concl_occ = Procq.Entry.make "concl_occ"
  and in_hyp_list = Procq.Entry.make "in_hyp_list"
  and in_hyp_as = Procq.Entry.make "in_hyp_as"
  and orient_rw = Procq.Entry.make "orient_rw"
  and simple_binder = Procq.Entry.make "simple_binder"
  and fixdecl = Procq.Entry.make "fixdecl"
  and struct_annot = Procq.Entry.make "struct_annot"
  and cofixdecl = Procq.Entry.make "cofixdecl"
  and bindings_with_parameters = Procq.Entry.make "bindings_with_parameters"
  and eliminator = Procq.Entry.make "eliminator"
  and as_ipat = Procq.Entry.make "as_ipat"
  and or_and_intropattern_loc = Procq.Entry.make "or_and_intropattern_loc"
  and as_or_and_ipat = Procq.Entry.make "as_or_and_ipat"
  and eqn_ipat = Procq.Entry.make "eqn_ipat"
  and as_name = Procq.Entry.make "as_name"
  and by_tactic = Procq.Entry.make "by_tactic"
  and rewriter = Procq.Entry.make "rewriter"
  and oriented_rewriter = Procq.Entry.make "oriented_rewriter"
  and induction_clause = Procq.Entry.make "induction_clause"
  and induction_clause_list = Procq.Entry.make "induction_clause_list"
  in
  let () = assert (Procq.Entry.is_empty id_or_meta) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_tactic.mlg:0")
  id_or_meta
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm identref)))
                            (fun id loc -> 
# 213 "plugins/ltac/g_tactic.mlg"
                           id 
# 249 "plugins/ltac/g_tactic.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty open_constr) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_tactic.mlg:1")
  open_constr
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm constr)))
                            (fun c loc -> 
# 216 "plugins/ltac/g_tactic.mlg"
                        c 
# 263 "plugins/ltac/g_tactic.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty uconstr) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_tactic.mlg:2")
  uconstr
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm constr)))
                            (fun c loc -> 
# 219 "plugins/ltac/g_tactic.mlg"
                        c 
# 277 "plugins/ltac/g_tactic.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty destruction_arg) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_tactic.mlg:3")
  destruction_arg
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm constr_with_bindings_arg)))
                            (fun c loc -> 
# 225 "plugins/ltac/g_tactic.mlg"
                                          on_snd destruction_arg_of_constr c 
# 291 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm test_lpar_id_rpar)))
                            ((Procq.Symbol.nterm constr_with_bindings)))
                           (fun c _ loc -> 
# 224 "plugins/ltac/g_tactic.mlg"
          (Some false,destruction_arg_of_constr c) 
# 301 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm natural)))
                           (fun n loc -> 
# 222 "plugins/ltac/g_tactic.mlg"
                         (None,ElimOnAnonHyp n) 
# 309 "plugins/ltac/g_tactic.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty constr_with_bindings_arg)
  in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_tactic.mlg:4")
  constr_with_bindings_arg
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm constr_with_bindings)))
                            (fun c loc -> 
# 229 "plugins/ltac/g_tactic.mlg"
                                      (None,c) 
# 324 "plugins/ltac/g_tactic.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty quantified_hypothesis) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_tactic.mlg:5")
  quantified_hypothesis
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm natural)))
                            (fun n loc -> 
# 233 "plugins/ltac/g_tactic.mlg"
                         AnonHyp n 
# 338 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm ident)))
                           (fun id loc -> 
# 232 "plugins/ltac/g_tactic.mlg"
                        NamedHyp (CAst.make ~loc id) 
# 346 "plugins/ltac/g_tactic.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty conversion) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_tactic.mlg:6")
  conversion
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next (Procq.Rule.stop)
                                 ((Procq.Symbol.nterm constr)))
                                ((Procq.Symbol.token (Tok.PKEYWORD ("at")))))
                               ((Procq.Symbol.nterm occs_nums)))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("with")))))
                             ((Procq.Symbol.nterm constr)))
                            (fun c2 _ occs _ c1 loc -> 
# 239 "plugins/ltac/g_tactic.mlg"
            deprecated_conversion_at_with ();  (* 8.14 *)
          (Some (occs,c1), c2) 
# 369 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm constr)))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("with")))))
                            ((Procq.Symbol.nterm constr)))
                           (fun c2 _ c1 loc -> 
# 237 "plugins/ltac/g_tactic.mlg"
                                              (Some (AllOccurrences,c1),c2) 
# 381 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm constr)))
                           (fun c loc -> 
# 236 "plugins/ltac/g_tactic.mlg"
                        (None, c) 
# 389 "plugins/ltac/g_tactic.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty intropatterns) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_tactic.mlg:7")
  intropatterns
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.list0 (Procq.Symbol.nterm intropattern))))
                            (fun l loc -> 
# 243 "plugins/ltac/g_tactic.mlg"
                                    l 
# 403 "plugins/ltac/g_tactic.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty ne_intropatterns) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_tactic.mlg:8")
  ne_intropatterns
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.list1 ((Procq.Symbol.nterm intropattern)))))
                            (fun l loc -> 
# 246 "plugins/ltac/g_tactic.mlg"
                                    l 
# 417 "plugins/ltac/g_tactic.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty or_and_intropattern) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_tactic.mlg:9")
  or_and_intropattern
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next (Procq.Rule.stop)
                                 ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                                ((Procq.Symbol.nterm simple_intropattern)))
                               ((Procq.Symbol.token (Tok.PKEYWORD ("&")))))
                              ((Procq.Symbol.list1sep ((Procq.Symbol.nterm simple_intropattern)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD ("&"))])) false)))
                             ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                            (fun _ tc _ si _ loc -> 
# 258 "plugins/ltac/g_tactic.mlg"
            let rec pairify = function
            | ([]|[_]|[_;_]) as l -> l
            | t::q -> [t; CAst.make ?loc:(loc_of_ne_list q) (IntroAction (IntroOrAndPattern (IntroAndPattern (pairify q))))]
          in IntroAndPattern (pairify (si::tc)) 
# 442 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                               ((Procq.Symbol.nterm simple_intropattern)))
                              ((Procq.Symbol.token (Tok.PKEYWORD (",")))))
                             ((Procq.Symbol.list1sep ((Procq.Symbol.nterm simple_intropattern)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (","))])) false)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                           (fun _ tc _ si _ loc -> 
# 254 "plugins/ltac/g_tactic.mlg"
               IntroAndPattern (si::tc) 
# 458 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                             ((Procq.Symbol.nterm simple_intropattern)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                           (fun _ si _ loc -> 
# 251 "plugins/ltac/g_tactic.mlg"
                                                IntroAndPattern [si] 
# 470 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("()")))))
                           (fun _ loc -> 
# 250 "plugins/ltac/g_tactic.mlg"
                  IntroAndPattern [] 
# 478 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("[")))))
                             ((Procq.Symbol.list1sep ((Procq.Symbol.nterm intropatterns)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("]")))))
                           (fun _ tc _ loc -> 
# 249 "plugins/ltac/g_tactic.mlg"
                                                        IntroOrPattern tc 
# 490 "plugins/ltac/g_tactic.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty equality_intropattern) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_tactic.mlg:10")
  equality_intropattern
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next (Procq.Rule.stop)
                                 ((Procq.Symbol.nterm test_leftsquarebracket_equal)))
                                ((Procq.Symbol.token (Tok.PKEYWORD ("[")))))
                               ((Procq.Symbol.token (Tok.PKEYWORD ("=")))))
                              ((Procq.Symbol.nterm intropatterns)))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("]")))))
                            (fun _ tc _ _ _ loc -> 
# 266 "plugins/ltac/g_tactic.mlg"
                                                                             IntroInjection tc 
# 512 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("<-")))))
                           (fun _ loc -> 
# 265 "plugins/ltac/g_tactic.mlg"
                  IntroRewrite false 
# 520 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("->")))))
                           (fun _ loc -> 
# 264 "plugins/ltac/g_tactic.mlg"
                  IntroRewrite true 
# 528 "plugins/ltac/g_tactic.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty naming_intropattern) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_tactic.mlg:11")
  naming_intropattern
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm ident)))
                            (fun id loc -> 
# 271 "plugins/ltac/g_tactic.mlg"
                        IntroIdentifier id 
# 542 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("?")))))
                           (fun _ loc -> 
# 270 "plugins/ltac/g_tactic.mlg"
                 IntroAnonymous 
# 550 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm pattern_ident)))
                           (fun prefix loc -> 
# 269 "plugins/ltac/g_tactic.mlg"
                                    IntroFresh prefix.CAst.v 
# 558 "plugins/ltac/g_tactic.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty intropattern) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_tactic.mlg:12")
  intropattern
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("**")))))
                            (fun _ loc -> 
# 276 "plugins/ltac/g_tactic.mlg"
                  CAst.make ~loc @@ IntroForthcoming false 
# 572 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("*")))))
                           (fun _ loc -> 
# 275 "plugins/ltac/g_tactic.mlg"
                  CAst.make ~loc @@ IntroForthcoming true 
# 580 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm simple_intropattern)))
                           (fun l loc -> 
# 274 "plugins/ltac/g_tactic.mlg"
                                     l 
# 588 "plugins/ltac/g_tactic.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty simple_intropattern) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_tactic.mlg:13")
  simple_intropattern
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm simple_intropattern_closed)))
                             ((Procq.Symbol.list0 (Procq.Symbol.rules 
                             [Procq.Rules.make (Procq.Rule.next_norec
                                                (Procq.Rule.next_norec
                                                 (Procq.Rule.stop)
                                                 ((Procq.Symbol.token (Tok.PKEYWORD ("%")))))
                                                ((Procq.Symbol.nterml term ("0"))))
                                               (fun c _ loc -> 
# 280 "plugins/ltac/g_tactic.mlg"
                                                c 
# 609 "plugins/ltac/g_tactic.ml"
)]))))
                            (fun l pat loc -> 
# 281 "plugins/ltac/g_tactic.mlg"
            let {CAst.loc=loc0;v=pat} = pat in
          let f c pat =
            let loc1 = Constrexpr_ops.constr_loc c in
            let loc = Loc.merge_opt loc0 loc1 in
            IntroAction (IntroApplyOn (CAst.(make ?loc:loc1 c),CAst.(make ?loc pat))) in
          CAst.make ~loc @@ List.fold_right f l pat 
# 619 "plugins/ltac/g_tactic.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty simple_intropattern_closed)
  in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_tactic.mlg:14")
  simple_intropattern_closed
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm naming_intropattern)))
                            (fun pat loc -> 
# 292 "plugins/ltac/g_tactic.mlg"
                                       CAst.make ~loc @@ IntroNaming pat 
# 634 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("_")))))
                           (fun _ loc -> 
# 291 "plugins/ltac/g_tactic.mlg"
                 CAst.make ~loc @@ IntroAction IntroWildcard 
# 642 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm or_and_intropattern)))
                           (fun pat loc -> 
# 290 "plugins/ltac/g_tactic.mlg"
                                         CAst.make ~loc @@ IntroAction (IntroOrAndPattern pat) 
# 650 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm equality_intropattern)))
                           (fun pat loc -> 
# 289 "plugins/ltac/g_tactic.mlg"
                                         CAst.make ~loc @@ IntroAction pat 
# 658 "plugins/ltac/g_tactic.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty simple_binding) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_tactic.mlg:15")
  simple_binding
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next (Procq.Rule.stop)
                                 ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                                ((Procq.Symbol.nterm natural)))
                               ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                              ((Procq.Symbol.nterm lconstr)))
                             ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                            (fun _ c _ n _ loc -> 
# 296 "plugins/ltac/g_tactic.mlg"
                                                      CAst.make ~loc (AnonHyp n, c) 
# 680 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                               ((Procq.Symbol.nterm identref)))
                              ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                             ((Procq.Symbol.nterm lconstr)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                           (fun _ c _ id _ loc -> 
# 295 "plugins/ltac/g_tactic.mlg"
                                                        CAst.make ~loc (NamedHyp id, c) 
# 696 "plugins/ltac/g_tactic.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty bindings) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_tactic.mlg:16")
  bindings
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.list1 ((Procq.Symbol.nterm constr)))))
                            (fun bl loc -> 
# 301 "plugins/ltac/g_tactic.mlg"
                               ImplicitBindings bl 
# 710 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm test_lpar_idnum_coloneq)))
                            ((Procq.Symbol.list1 ((Procq.Symbol.nterm simple_binding)))))
                           (fun bl _ loc -> 
# 300 "plugins/ltac/g_tactic.mlg"
            ExplicitBindings bl 
# 720 "plugins/ltac/g_tactic.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty constr_with_bindings) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_tactic.mlg:17")
  constr_with_bindings
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm constr)))
                             ((Procq.Symbol.nterm with_bindings)))
                            (fun l c loc -> 
# 304 "plugins/ltac/g_tactic.mlg"
                                           (c, l) 
# 736 "plugins/ltac/g_tactic.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty with_bindings) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_tactic.mlg:18")
  with_bindings
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 307 "plugins/ltac/g_tactic.mlg"
                                               NoBindings 
# 748 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("with")))))
                            ((Procq.Symbol.nterm bindings)))
                           (fun bl _ loc -> 
# 307 "plugins/ltac/g_tactic.mlg"
                                   bl 
# 758 "plugins/ltac/g_tactic.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty hypident) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_tactic.mlg:19")
  hypident
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next (Procq.Rule.stop)
                                 ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                                ((Procq.Symbol.token (Tok.PIDENT (Some
                                ("value"))))))
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("of"))))))
                              ((Procq.Symbol.nterm id_or_meta)))
                             ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                            (fun _ id _ _ _ loc -> 
# 317 "plugins/ltac/g_tactic.mlg"
          let id : lident = id in
        id,InHypValueOnly 
# 783 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("type"))))))
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("of"))))))
                             ((Procq.Symbol.nterm id_or_meta)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                           (fun _ id _ _ _ loc -> 
# 314 "plugins/ltac/g_tactic.mlg"
          let id : lident = id in
        id,InHypTypeOnly 
# 802 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm id_or_meta)))
                           (fun id loc -> 
# 311 "plugins/ltac/g_tactic.mlg"
          let id : lident = id in
        id,InHyp 
# 811 "plugins/ltac/g_tactic.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty hypident_occ) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_tactic.mlg:20")
  hypident_occ
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm hypident)))
                             ((Procq.Symbol.nterm occs)))
                            (fun occs h loc -> 
# 323 "plugins/ltac/g_tactic.mlg"
          let (id,l) = h in
        let id : lident = id in
        ((occs,id),l) 
# 829 "plugins/ltac/g_tactic.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty in_clause) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_tactic.mlg:21")
  in_clause
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.list1sep ((Procq.Symbol.nterm hypident_occ)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (","))])) false)))
                            (fun hl loc -> 
# 337 "plugins/ltac/g_tactic.mlg"
            {onhyps=Some hl; concl_occs=NoOccurrences} 
# 843 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.list1sep ((Procq.Symbol.nterm hypident_occ)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (","))])) false)))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("|-")))))
                            ((Procq.Symbol.nterm concl_occ)))
                           (fun occs _ hl loc -> 
# 335 "plugins/ltac/g_tactic.mlg"
            {onhyps=Some hl; concl_occs=occs} 
# 855 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("|-")))))
                            ((Procq.Symbol.nterm concl_occ)))
                           (fun occs _ loc -> 
# 333 "plugins/ltac/g_tactic.mlg"
            {onhyps=Some []; concl_occs=occs} 
# 865 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("*")))))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("|-")))))
                            ((Procq.Symbol.nterm concl_occ)))
                           (fun occs _ _ loc -> 
# 331 "plugins/ltac/g_tactic.mlg"
            {onhyps=None; concl_occs=occs} 
# 877 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("*")))))
                            ((Procq.Symbol.nterm occs)))
                           (fun occs _ loc -> 
# 329 "plugins/ltac/g_tactic.mlg"
            {onhyps=None; concl_occs=occs} 
# 887 "plugins/ltac/g_tactic.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty clause_dft_concl) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_tactic.mlg:22")
  clause_dft_concl
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 342 "plugins/ltac/g_tactic.mlg"
             all_concl_occs_clause 
# 899 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm occs)))
                           (fun occs loc -> 
# 341 "plugins/ltac/g_tactic.mlg"
                       {onhyps=Some[]; concl_occs=occs} 
# 907 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("in")))))
                            ((Procq.Symbol.nterm in_clause)))
                           (fun cl _ loc -> 
# 340 "plugins/ltac/g_tactic.mlg"
                                  cl 
# 917 "plugins/ltac/g_tactic.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty clause_dft_all) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_tactic.mlg:23")
  clause_dft_all
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 346 "plugins/ltac/g_tactic.mlg"
             {onhyps=None; concl_occs=AllOccurrences} 
# 929 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("in")))))
                            ((Procq.Symbol.nterm in_clause)))
                           (fun cl _ loc -> 
# 345 "plugins/ltac/g_tactic.mlg"
                                  cl 
# 939 "plugins/ltac/g_tactic.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty opt_clause) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_tactic.mlg:24")
  opt_clause
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 351 "plugins/ltac/g_tactic.mlg"
             None 
# 951 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("at")))))
                            ((Procq.Symbol.nterm occs_nums)))
                           (fun occs _ loc -> 
# 350 "plugins/ltac/g_tactic.mlg"
                                    Some {onhyps=Some[]; concl_occs=occs} 
# 961 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("in")))))
                            ((Procq.Symbol.nterm in_clause)))
                           (fun cl _ loc -> 
# 349 "plugins/ltac/g_tactic.mlg"
                                  Some cl 
# 971 "plugins/ltac/g_tactic.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty concl_occ) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_tactic.mlg:25")
  concl_occ
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 355 "plugins/ltac/g_tactic.mlg"
             NoOccurrences 
# 983 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("*")))))
                            ((Procq.Symbol.nterm occs)))
                           (fun occs _ loc -> 
# 354 "plugins/ltac/g_tactic.mlg"
                              occs 
# 993 "plugins/ltac/g_tactic.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty in_hyp_list) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_tactic.mlg:26")
  in_hyp_list
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 359 "plugins/ltac/g_tactic.mlg"
             [] 
# 1005 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("in")))))
                            ((Procq.Symbol.list1 ((Procq.Symbol.nterm id_or_meta)))))
                           (fun idl _ loc -> 
# 358 "plugins/ltac/g_tactic.mlg"
                                          idl 
# 1015 "plugins/ltac/g_tactic.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty in_hyp_as) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_tactic.mlg:27")
  in_hyp_as
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 363 "plugins/ltac/g_tactic.mlg"
             [] 
# 1027 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("in")))))
                            ((Procq.Symbol.list1sep ((Procq.Symbol.rules 
                            [Procq.Rules.make (Procq.Rule.next_norec
                                               (Procq.Rule.next_norec
                                                (Procq.Rule.stop)
                                                ((Procq.Symbol.nterm id_or_meta)))
                                               ((Procq.Symbol.nterm as_ipat)))
                                              (fun ipat id loc -> 
# 362 "plugins/ltac/g_tactic.mlg"
                                                              (id,ipat) 
# 1042 "plugins/ltac/g_tactic.ml"
)])) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (","))])) false)))
                           (fun l _ loc -> 
# 362 "plugins/ltac/g_tactic.mlg"
                                                                                         l 
# 1047 "plugins/ltac/g_tactic.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty orient_rw) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_tactic.mlg:28")
  orient_rw
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 368 "plugins/ltac/g_tactic.mlg"
             true 
# 1059 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("<-")))))
                           (fun _ loc -> 
# 367 "plugins/ltac/g_tactic.mlg"
                  false 
# 1067 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("->")))))
                           (fun _ loc -> 
# 366 "plugins/ltac/g_tactic.mlg"
                  true 
# 1075 "plugins/ltac/g_tactic.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty simple_binder) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_tactic.mlg:29")
  simple_binder
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next (Procq.Rule.stop)
                                 ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                                ((Procq.Symbol.list1 ((Procq.Symbol.nterm name)))))
                               ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                              ((Procq.Symbol.nterm lconstr)))
                             ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                            (fun _ c _ nal _ loc -> 
# 373 "plugins/ltac/g_tactic.mlg"
                                                      (nal,Default Glob_term.Explicit,c) 
# 1097 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm name)))
                           (fun na loc -> 
# 371 "plugins/ltac/g_tactic.mlg"
                     ([na],Default Glob_term.Explicit, CAst.make ~loc @@
                    CHole (Some (GBinderType na.CAst.v))) 
# 1106 "plugins/ltac/g_tactic.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty fixdecl) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_tactic.mlg:30")
  fixdecl
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next
                                 (Procq.Rule.next
                                  (Procq.Rule.next (Procq.Rule.stop)
                                   ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                                  ((Procq.Symbol.nterm ident)))
                                 ((Procq.Symbol.list0 (Procq.Symbol.nterm simple_binder))))
                                ((Procq.Symbol.nterm struct_annot)))
                               ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                              ((Procq.Symbol.nterm lconstr)))
                             ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                            (fun _ ty _ ann bl id _ loc -> 
# 378 "plugins/ltac/g_tactic.mlg"
                                  (loc, id, bl, ann, ty) 
# 1132 "plugins/ltac/g_tactic.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty struct_annot) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_tactic.mlg:31")
  struct_annot
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 382 "plugins/ltac/g_tactic.mlg"
             None 
# 1144 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PKEYWORD ("{")))))
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("struct"))))))
                             ((Procq.Symbol.nterm name)))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("}")))))
                           (fun _ id _ _ loc -> 
# 381 "plugins/ltac/g_tactic.mlg"
                                               Some id 
# 1159 "plugins/ltac/g_tactic.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty cofixdecl) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_tactic.mlg:32")
  cofixdecl
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next
                                 (Procq.Rule.next (Procq.Rule.stop)
                                  ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                                 ((Procq.Symbol.nterm ident)))
                                ((Procq.Symbol.list0 (Procq.Symbol.nterm simple_binder))))
                               ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                              ((Procq.Symbol.nterm lconstr)))
                             ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                            (fun _ ty _ bl id _ loc -> 
# 386 "plugins/ltac/g_tactic.mlg"
          (loc, id, bl, None, ty) 
# 1183 "plugins/ltac/g_tactic.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty bindings_with_parameters)
  in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_tactic.mlg:33")
  bindings_with_parameters
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next
                                 (Procq.Rule.next
                                  (Procq.Rule.next (Procq.Rule.stop)
                                   ((Procq.Symbol.nterm check_for_coloneq)))
                                  ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                                 ((Procq.Symbol.nterm ident)))
                                ((Procq.Symbol.list0 (Procq.Symbol.nterm simple_binder))))
                               ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                              ((Procq.Symbol.nterm lconstr)))
                             ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                            (fun _ c _ bl id _ _ loc -> 
# 390 "plugins/ltac/g_tactic.mlg"
                                    (id, mkCLambdaN_simple bl c) 
# 1210 "plugins/ltac/g_tactic.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty eliminator) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_tactic.mlg:34")
  eliminator
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("using")))))
                             ((Procq.Symbol.nterm constr_with_bindings)))
                            (fun el _ loc -> 
# 393 "plugins/ltac/g_tactic.mlg"
                                                el 
# 1226 "plugins/ltac/g_tactic.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty as_ipat) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_tactic.mlg:35")
  as_ipat
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 397 "plugins/ltac/g_tactic.mlg"
             None 
# 1238 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("as")))))
                            ((Procq.Symbol.nterm simple_intropattern)))
                           (fun ipat _ loc -> 
# 396 "plugins/ltac/g_tactic.mlg"
                                              Some ipat 
# 1248 "plugins/ltac/g_tactic.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty or_and_intropattern_loc)
  in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_tactic.mlg:36")
  or_and_intropattern_loc
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm identref)))
                            (fun locid loc -> 
# 401 "plugins/ltac/g_tactic.mlg"
                              ArgVar locid 
# 1263 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm or_and_intropattern)))
                           (fun ipat loc -> 
# 400 "plugins/ltac/g_tactic.mlg"
                                        ArgArg (CAst.make ~loc ipat) 
# 1271 "plugins/ltac/g_tactic.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty as_or_and_ipat) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_tactic.mlg:37")
  as_or_and_ipat
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 410 "plugins/ltac/g_tactic.mlg"
             None 
# 1283 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("as")))))
                            ((Procq.Symbol.nterm or_and_intropattern_loc)))
                           (fun ipat _ loc -> 
# 409 "plugins/ltac/g_tactic.mlg"
                                                  Some ipat 
# 1293 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("as")))))
                            ((Procq.Symbol.nterm equality_intropattern)))
                           (fun ipat _ loc -> 
# 405 "plugins/ltac/g_tactic.mlg"
          match ipat with
          | IntroRewrite _ -> user_err ~loc Pp.(str "Disjunctive/conjunctive pattern expected.")
          | IntroInjection _ -> user_err ~loc Pp.(strbrk "Found an injection pattern while a disjunctive/conjunctive pattern was expected; use " ++ str "\"injection as pattern\"" ++ strbrk " instead.")
          | _ -> assert false 
# 1306 "plugins/ltac/g_tactic.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty eqn_ipat) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_tactic.mlg:38")
  eqn_ipat
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 414 "plugins/ltac/g_tactic.mlg"
             None 
# 1318 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("eqn"))))))
                             ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                            ((Procq.Symbol.nterm naming_intropattern)))
                           (fun pat _ _ loc -> 
# 413 "plugins/ltac/g_tactic.mlg"
                                                         Some (CAst.make ~loc pat) 
# 1331 "plugins/ltac/g_tactic.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty as_name) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_tactic.mlg:39")
  as_name
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 417 "plugins/ltac/g_tactic.mlg"
                                                          Names.Name.Anonymous 
# 1343 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("as")))))
                            ((Procq.Symbol.nterm ident)))
                           (fun id _ loc -> 
# 417 "plugins/ltac/g_tactic.mlg"
                              Names.Name.Name id 
# 1353 "plugins/ltac/g_tactic.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty by_tactic) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_tactic.mlg:40")
  by_tactic
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 421 "plugins/ltac/g_tactic.mlg"
           None 
# 1365 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("by")))))
                            ((Procq.Symbol.nterml ltac_expr ("3"))))
                           (fun tac _ loc -> 
# 420 "plugins/ltac/g_tactic.mlg"
                                             Some tac 
# 1375 "plugins/ltac/g_tactic.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty rewriter) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_tactic.mlg:41")
  rewriter
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm constr_with_bindings_arg)))
                            (fun c loc -> 
# 429 "plugins/ltac/g_tactic.mlg"
                                          (Equality.Precisely 1, c) 
# 1389 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm natural)))
                            ((Procq.Symbol.nterm constr_with_bindings_arg)))
                           (fun c n loc -> 
# 428 "plugins/ltac/g_tactic.mlg"
                                                       (Equality.Precisely n,c) 
# 1399 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm natural)))
                             ((Procq.Symbol.rules [Procq.Rules.make (
                                                                    Procq.Rule.next_norec
                                                                    (Procq.Rule.stop)
                                                                    ((Procq.Symbol.token (Tok.PLEFTQMARK))))
                                                                    (fun _
                                                                    loc -> 
                                                                    
# 427 "plugins/ltac/g_tactic.mlg"
                                                     () 
# 1415 "plugins/ltac/g_tactic.ml"
);
                                                  Procq.Rules.make (Procq.Rule.next_norec
                                                                    (Procq.Rule.stop)
                                                                    ((Procq.Symbol.token (Tok.PKEYWORD ("?")))))
                                                                   (fun _
                                                                   loc -> 
                                                                   
# 427 "plugins/ltac/g_tactic.mlg"
                               () 
# 1425 "plugins/ltac/g_tactic.ml"
)])))
                            ((Procq.Symbol.nterm constr_with_bindings_arg)))
                           (fun c _ n loc -> 
# 427 "plugins/ltac/g_tactic.mlg"
                                                                                               (Equality.UpTo n,c) 
# 1431 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm natural)))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("!")))))
                            ((Procq.Symbol.nterm constr_with_bindings_arg)))
                           (fun c _ n loc -> 
# 426 "plugins/ltac/g_tactic.mlg"
                                                            (Equality.Precisely n,c) 
# 1443 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.rules [Procq.Rules.make (
                                                                    Procq.Rule.next_norec
                                                                    (Procq.Rule.stop)
                                                                    ((Procq.Symbol.token (Tok.PLEFTQMARK))))
                                                                    (fun _
                                                                    loc -> 
                                                                    
# 425 "plugins/ltac/g_tactic.mlg"
                                        () 
# 1457 "plugins/ltac/g_tactic.ml"
);
                                                  Procq.Rules.make (Procq.Rule.next_norec
                                                                    (Procq.Rule.stop)
                                                                    ((Procq.Symbol.token (Tok.PKEYWORD ("?")))))
                                                                   (fun _
                                                                   loc -> 
                                                                   
# 425 "plugins/ltac/g_tactic.mlg"
                  () 
# 1467 "plugins/ltac/g_tactic.ml"
)])))
                            ((Procq.Symbol.nterm constr_with_bindings_arg)))
                           (fun c _ loc -> 
# 425 "plugins/ltac/g_tactic.mlg"
                                                                                  (Equality.RepeatStar,c) 
# 1473 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("!")))))
                            ((Procq.Symbol.nterm constr_with_bindings_arg)))
                           (fun c _ loc -> 
# 424 "plugins/ltac/g_tactic.mlg"
                                               (Equality.RepeatPlus,c) 
# 1483 "plugins/ltac/g_tactic.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty oriented_rewriter) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_tactic.mlg:42")
  oriented_rewriter
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm orient_rw)))
                             ((Procq.Symbol.nterm rewriter)))
                            (fun p b loc -> 
# 433 "plugins/ltac/g_tactic.mlg"
                                         let (m,c) = p in (b,m,c) 
# 1499 "plugins/ltac/g_tactic.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty induction_clause) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_tactic.mlg:43")
  induction_clause
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.nterm destruction_arg)))
                               ((Procq.Symbol.nterm as_or_and_ipat)))
                              ((Procq.Symbol.nterm eqn_ipat)))
                             ((Procq.Symbol.nterm opt_clause)))
                            (fun cl eq pat c loc -> 
# 437 "plugins/ltac/g_tactic.mlg"
                             (c,(eq,pat),cl) 
# 1519 "plugins/ltac/g_tactic.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty induction_clause_list) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_tactic.mlg:44")
  induction_clause_list
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.list1sep ((Procq.Symbol.nterm induction_clause)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (","))])) false)))
                              ((Procq.Symbol.opt (Procq.Symbol.nterm eliminator))))
                             ((Procq.Symbol.nterm opt_clause)))
                            (fun cl_tolerance el ic loc -> 
# 443 "plugins/ltac/g_tactic.mlg"
          match ic,el,cl_tolerance with
        | [c,pat,None],Some _,Some _ -> ([c,pat,cl_tolerance],el)
        | _,_,Some _ -> err ()
        | _,_,None -> (ic,el) 
# 1540 "plugins/ltac/g_tactic.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty simple_tactic) in
  let () =
  Egramml.grammar_extend ~plugin_uid:("rocq-runtime.plugins.ltac", "g_tactic.mlg:45")
  simple_tactic
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("change_no_check"))))))
                              ((Procq.Symbol.nterm conversion)))
                             ((Procq.Symbol.nterm clause_dft_concl)))
                            (fun cl c _ loc -> 
# 638 "plugins/ltac/g_tactic.mlg"
            let (oc, c) = c in
          let p,cl = merge_occurrences loc cl oc in
          CAst.make ~loc @@ TacAtom (TacChange (false,p,c,cl)) 
# 1561 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("change"))))))
                             ((Procq.Symbol.nterm conversion)))
                            ((Procq.Symbol.nterm clause_dft_concl)))
                           (fun cl c _ loc -> 
# 634 "plugins/ltac/g_tactic.mlg"
            let (oc, c) = c in
          let p,cl = merge_occurrences loc cl oc in
          CAst.make ~loc @@ TacAtom (TacChange (true,p,c,cl)) 
# 1576 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("pattern"))))))
                             ((Procq.Symbol.list1sep ((Procq.Symbol.nterm pattern_occ)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (","))])) false)))
                            ((Procq.Symbol.nterm clause_dft_concl)))
                           (fun cl pl _ loc -> 
# 630 "plugins/ltac/g_tactic.mlg"
            CAst.make ~loc @@ TacAtom (TacReduce (Pattern pl, cl)) 
# 1589 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("fold"))))))
                             ((Procq.Symbol.list1 ((Procq.Symbol.nterm constr)))))
                            ((Procq.Symbol.nterm clause_dft_concl)))
                           (fun cl l _ loc -> 
# 628 "plugins/ltac/g_tactic.mlg"
            CAst.make ~loc @@ TacAtom (TacReduce (Fold l, cl)) 
# 1602 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("unfold"))))))
                             ((Procq.Symbol.list1sep ((Procq.Symbol.nterm unfold_occ)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (","))])) false)))
                            ((Procq.Symbol.nterm clause_dft_concl)))
                           (fun cl ul _ loc -> 
# 626 "plugins/ltac/g_tactic.mlg"
            CAst.make ~loc @@ TacAtom (TacReduce (Unfold ul, cl)) 
# 1615 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("native_compute"))))))
                             ((Procq.Symbol.opt (Procq.Symbol.nterm ref_or_pattern_occ))))
                            ((Procq.Symbol.nterm clause_dft_concl)))
                           (fun cl po _ loc -> 
# 624 "plugins/ltac/g_tactic.mlg"
            CAst.make ~loc @@ TacAtom (TacReduce (CbvNative po, cl)) 
# 1628 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("vm_compute"))))))
                             ((Procq.Symbol.opt (Procq.Symbol.nterm ref_or_pattern_occ))))
                            ((Procq.Symbol.nterm clause_dft_concl)))
                           (fun cl po _ loc -> 
# 622 "plugins/ltac/g_tactic.mlg"
            CAst.make ~loc @@ TacAtom (TacReduce (CbvVm po, cl)) 
# 1641 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("compute"))))))
                             ((Procq.Symbol.nterm delta_flag)))
                            ((Procq.Symbol.nterm clause_dft_concl)))
                           (fun cl delta _ loc -> 
# 620 "plugins/ltac/g_tactic.mlg"
            CAst.make ~loc @@ TacAtom (TacReduce (Cbv (all_with ~head:false delta), cl)) 
# 1654 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("lazy"))))))
                             ((Procq.Symbol.nterm strategy_flag)))
                            ((Procq.Symbol.nterm clause_dft_concl)))
                           (fun cl s _ loc -> 
# 618 "plugins/ltac/g_tactic.mlg"
            CAst.make ~loc @@ TacAtom (TacReduce (Lazy s, cl)) 
# 1667 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("cbn"))))))
                             ((Procq.Symbol.nterm strategy_flag)))
                            ((Procq.Symbol.nterm clause_dft_concl)))
                           (fun cl s _ loc -> 
# 616 "plugins/ltac/g_tactic.mlg"
            CAst.make ~loc @@ TacAtom (TacReduce (Cbn s, cl)) 
# 1680 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("cbv"))))))
                             ((Procq.Symbol.nterm strategy_flag)))
                            ((Procq.Symbol.nterm clause_dft_concl)))
                           (fun cl s _ loc -> 
# 614 "plugins/ltac/g_tactic.mlg"
            CAst.make ~loc @@ TacAtom (TacReduce (Cbv s, cl)) 
# 1693 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PIDENT (Some
                                ("simpl"))))))
                               ((Procq.Symbol.opt (Procq.Symbol.rules 
                               [Procq.Rules.make (Procq.Rule.next_norec
                                                  (Procq.Rule.stop)
                                                  ((Procq.Symbol.token (Tok.PIDENT (Some
                                                  ("head"))))))
                                                 (fun _ loc -> 
# 610 "plugins/ltac/g_tactic.mlg"
                                                   () 
# 1711 "plugins/ltac/g_tactic.ml"
)]))))
                              ((Procq.Symbol.nterm delta_flag)))
                             ((Procq.Symbol.opt (Procq.Symbol.nterm ref_or_pattern_occ))))
                            ((Procq.Symbol.nterm clause_dft_concl)))
                           (fun cl po d h _ loc -> 
# 612 "plugins/ltac/g_tactic.mlg"
            CAst.make ~loc @@ TacAtom (TacReduce (Simpl (all_with ~head:(Option.has_some h) d, po), cl)) 
# 1719 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("hnf"))))))
                            ((Procq.Symbol.nterm clause_dft_concl)))
                           (fun cl _ loc -> 
# 609 "plugins/ltac/g_tactic.mlg"
            CAst.make ~loc @@ TacAtom (TacReduce (Hnf, cl)) 
# 1730 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("red"))))))
                            ((Procq.Symbol.nterm clause_dft_concl)))
                           (fun cl _ loc -> 
# 607 "plugins/ltac/g_tactic.mlg"
            CAst.make ~loc @@ TacAtom (TacReduce (Red, cl)) 
# 1741 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PIDENT (Some
                                ("inversion"))))))
                               ((Procq.Symbol.nterm quantified_hypothesis)))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("using")))))
                             ((Procq.Symbol.nterm constr)))
                            ((Procq.Symbol.nterm in_hyp_list)))
                           (fun cl c _ hyp _ loc -> 
# 603 "plugins/ltac/g_tactic.mlg"
              CAst.make ~loc @@ TacAtom (TacInversion (InversionUsing (c,cl), hyp)) 
# 1758 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("inversion_clear"))))))
                              ((Procq.Symbol.nterm quantified_hypothesis)))
                             ((Procq.Symbol.nterm as_or_and_ipat)))
                            ((Procq.Symbol.nterm in_hyp_list)))
                           (fun cl ids hyp _ loc -> 
# 600 "plugins/ltac/g_tactic.mlg"
              CAst.make ~loc @@ TacAtom (TacInversion (NonDepInversion (FullInversionClear, cl, ids), hyp)) 
# 1773 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("inversion"))))))
                              ((Procq.Symbol.nterm quantified_hypothesis)))
                             ((Procq.Symbol.nterm as_or_and_ipat)))
                            ((Procq.Symbol.nterm in_hyp_list)))
                           (fun cl ids hyp _ loc -> 
# 596 "plugins/ltac/g_tactic.mlg"
              CAst.make ~loc @@ TacAtom (TacInversion (NonDepInversion (FullInversion, cl, ids), hyp)) 
# 1788 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PIDENT (Some
                                ("simple"))))))
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("inversion"))))))
                              ((Procq.Symbol.nterm quantified_hypothesis)))
                             ((Procq.Symbol.nterm as_or_and_ipat)))
                            ((Procq.Symbol.nterm in_hyp_list)))
                           (fun cl ids hyp _ _ loc -> 
# 592 "plugins/ltac/g_tactic.mlg"
              CAst.make ~loc @@ TacAtom (TacInversion (NonDepInversion (SimpleInversion, cl, ids), hyp)) 
# 1806 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PIDENT (Some
                                ("dependent"))))))
                               ((Procq.Symbol.rules [Procq.Rules.make 
                                                    (Procq.Rule.next_norec
                                                     (Procq.Rule.stop)
                                                     ((Procq.Symbol.token (Tok.PIDENT (Some
                                                     ("inversion_clear"))))))
                                                    (fun _ loc -> 
# 585 "plugins/ltac/g_tactic.mlg"
                                         FullInversionClear 
# 1824 "plugins/ltac/g_tactic.ml"
);
                                                    Procq.Rules.make 
                                                    (Procq.Rule.next_norec
                                                     (Procq.Rule.stop)
                                                     ((Procq.Symbol.token (Tok.PIDENT (Some
                                                     ("inversion"))))))
                                                    (fun _ loc -> 
# 584 "plugins/ltac/g_tactic.mlg"
                                   FullInversion 
# 1834 "plugins/ltac/g_tactic.ml"
);
                                                    Procq.Rules.make 
                                                    (Procq.Rule.next_norec
                                                     (Procq.Rule.next_norec
                                                      (Procq.Rule.stop)
                                                      ((Procq.Symbol.token (Tok.PIDENT (Some
                                                      ("simple"))))))
                                                     ((Procq.Symbol.token (Tok.PIDENT (Some
                                                     ("inversion"))))))
                                                    (fun _ _ loc -> 
# 583 "plugins/ltac/g_tactic.mlg"
                                                   SimpleInversion 
# 1847 "plugins/ltac/g_tactic.ml"
)])))
                              ((Procq.Symbol.nterm quantified_hypothesis)))
                             ((Procq.Symbol.nterm as_or_and_ipat)))
                            ((Procq.Symbol.opt (Procq.Symbol.rules [Procq.Rules.make 
                                                                   (Procq.Rule.next_norec
                                                                    (
                                                                    Procq.Rule.next_norec
                                                                    (Procq.Rule.stop)
                                                                    ((Procq.Symbol.token (Tok.PKEYWORD ("with")))))
                                                                    ((Procq.Symbol.nterm constr)))
                                                                   (fun c _
                                                                   loc -> 
                                                                   
# 587 "plugins/ltac/g_tactic.mlg"
                                                                  c 
# 1863 "plugins/ltac/g_tactic.ml"
)]))))
                           (fun co ids hyp k _ loc -> 
# 588 "plugins/ltac/g_tactic.mlg"
              CAst.make ~loc @@ TacAtom (TacInversion (DepInversion (k,co,ids),hyp)) 
# 1868 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("erewrite"))))))
                              ((Procq.Symbol.list1sep ((Procq.Symbol.nterm oriented_rewriter)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (","))])) false)))
                             ((Procq.Symbol.nterm clause_dft_concl)))
                            ((Procq.Symbol.nterm by_tactic)))
                           (fun t cl l _ loc -> 
# 581 "plugins/ltac/g_tactic.mlg"
                                                  CAst.make ~loc @@ TacAtom (TacRewrite (true,l,cl,t)) 
# 1883 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("rewrite"))))))
                              ((Procq.Symbol.list1sep ((Procq.Symbol.nterm oriented_rewriter)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (","))])) false)))
                             ((Procq.Symbol.nterm clause_dft_concl)))
                            ((Procq.Symbol.nterm by_tactic)))
                           (fun t cl l _ loc -> 
# 579 "plugins/ltac/g_tactic.mlg"
                                                  CAst.make ~loc @@ TacAtom (TacRewrite (false,l,cl,t)) 
# 1898 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("edestruct"))))))
                            ((Procq.Symbol.nterm induction_clause_list)))
                           (fun icl _ loc -> 
# 575 "plugins/ltac/g_tactic.mlg"
            CAst.make ~loc @@ TacAtom (TacInductionDestruct(false,true,icl)) 
# 1909 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("destruct"))))))
                            ((Procq.Symbol.nterm induction_clause_list)))
                           (fun icl _ loc -> 
# 573 "plugins/ltac/g_tactic.mlg"
            CAst.make ~loc @@ TacAtom (TacInductionDestruct(false,false,icl)) 
# 1920 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("einduction"))))))
                            ((Procq.Symbol.nterm induction_clause_list)))
                           (fun ic _ loc -> 
# 571 "plugins/ltac/g_tactic.mlg"
            CAst.make ~loc @@ TacAtom (TacInductionDestruct(true,true,ic)) 
# 1931 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("induction"))))))
                            ((Procq.Symbol.nterm induction_clause_list)))
                           (fun ic _ loc -> 
# 569 "plugins/ltac/g_tactic.mlg"
            CAst.make ~loc @@ TacAtom (TacInductionDestruct (true,false,ic)) 
# 1942 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next (Procq.Rule.stop)
                                 ((Procq.Symbol.token (Tok.PIDENT (Some
                                 ("generalize"))))))
                                ((Procq.Symbol.nterm constr)))
                               ((Procq.Symbol.nterm lookup_at_as_comma)))
                              ((Procq.Symbol.nterm occs)))
                             ((Procq.Symbol.nterm as_name)))
                            ((Procq.Symbol.list0 (Procq.Symbol.rules 
                            [Procq.Rules.make (Procq.Rule.next_norec
                                               (Procq.Rule.next_norec
                                                (Procq.Rule.next_norec
                                                 (Procq.Rule.stop)
                                                 ((Procq.Symbol.token (Tok.PKEYWORD (",")))))
                                                ((Procq.Symbol.nterm pattern_occ)))
                                               ((Procq.Symbol.nterm as_name)))
                                              (fun na c _ loc -> 
# 564 "plugins/ltac/g_tactic.mlg"
                                                             (c,na) 
# 1968 "plugins/ltac/g_tactic.ml"
)]))))
                           (fun l na nl _ c _ loc -> 
# 565 "plugins/ltac/g_tactic.mlg"
            CAst.make ~loc @@ TacAtom (TacGeneralize (((nl,c),na)::l)) 
# 1973 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("generalize"))))))
                             ((Procq.Symbol.nterm constr)))
                            ((Procq.Symbol.list1 ((Procq.Symbol.nterm constr)))))
                           (fun l c _ loc -> 
# 560 "plugins/ltac/g_tactic.mlg"
            let gen_everywhere c = ((AllOccurrences,c),Names.Name.Anonymous) in
          CAst.make ~loc @@ TacAtom (TacGeneralize (List.map gen_everywhere (c::l))) 
# 1987 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("generalize"))))))
                            ((Procq.Symbol.nterm constr)))
                           (fun c _ loc -> 
# 558 "plugins/ltac/g_tactic.mlg"
            CAst.make ~loc @@ TacAtom (TacGeneralize [((AllOccurrences,c),Names.Name.Anonymous)]) 
# 1998 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("eenough"))))))
                              ((Procq.Symbol.nterm constr)))
                             ((Procq.Symbol.nterm as_ipat)))
                            ((Procq.Symbol.nterm by_tactic)))
                           (fun tac ipat c _ loc -> 
# 555 "plugins/ltac/g_tactic.mlg"
            CAst.make ~loc @@ TacAtom (TacAssert (true,false,Some tac,ipat,c)) 
# 2013 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("enough"))))))
                              ((Procq.Symbol.nterm constr)))
                             ((Procq.Symbol.nterm as_ipat)))
                            ((Procq.Symbol.nterm by_tactic)))
                           (fun tac ipat c _ loc -> 
# 553 "plugins/ltac/g_tactic.mlg"
            CAst.make ~loc @@ TacAtom (TacAssert (false,false,Some tac,ipat,c)) 
# 2028 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("epose"))))))
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("proof"))))))
                             ((Procq.Symbol.nterm lconstr)))
                            ((Procq.Symbol.nterm as_ipat)))
                           (fun ipat c _ _ loc -> 
# 551 "plugins/ltac/g_tactic.mlg"
            CAst.make ~loc @@ TacAtom (TacAssert (true,true,None,ipat,c)) 
# 2044 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("pose"))))))
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("proof"))))))
                             ((Procq.Symbol.nterm lconstr)))
                            ((Procq.Symbol.nterm as_ipat)))
                           (fun ipat c _ _ loc -> 
# 549 "plugins/ltac/g_tactic.mlg"
            CAst.make ~loc @@ TacAtom (TacAssert (false,true,None,ipat,c)) 
# 2060 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next
                                 (Procq.Rule.next
                                  (Procq.Rule.next (Procq.Rule.stop)
                                   ((Procq.Symbol.token (Tok.PIDENT (Some
                                   ("epose"))))))
                                  ((Procq.Symbol.token (Tok.PIDENT (Some
                                  ("proof"))))))
                                 ((Procq.Symbol.nterm test_lpar_id_coloneq)))
                                ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                               ((Procq.Symbol.nterm identref)))
                              ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                             ((Procq.Symbol.nterm lconstr)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                           (fun _ c _ lid _ _ _ _ loc -> 
# 546 "plugins/ltac/g_tactic.mlg"
            let { CAst.loc = loc; v = id } = lid in
          CAst.make ?loc @@ TacAtom ( TacAssert (true,true,None,Some (CAst.make ?loc @@ IntroNaming (IntroIdentifier id)),c)) 
# 2085 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next
                                 (Procq.Rule.next
                                  (Procq.Rule.next (Procq.Rule.stop)
                                   ((Procq.Symbol.token (Tok.PIDENT (Some
                                   ("pose"))))))
                                  ((Procq.Symbol.token (Tok.PIDENT (Some
                                  ("proof"))))))
                                 ((Procq.Symbol.nterm test_lpar_id_coloneq)))
                                ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                               ((Procq.Symbol.nterm identref)))
                              ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                             ((Procq.Symbol.nterm lconstr)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                           (fun _ c _ lid _ _ _ _ loc -> 
# 542 "plugins/ltac/g_tactic.mlg"
            let { CAst.loc = loc; v = id } = lid in
          CAst.make ?loc @@ TacAtom (TacAssert (false,true,None,Some (CAst.make ?loc @@ IntroNaming (IntroIdentifier id)),c)) 
# 2110 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("eassert"))))))
                              ((Procq.Symbol.nterm constr)))
                             ((Procq.Symbol.nterm as_ipat)))
                            ((Procq.Symbol.nterm by_tactic)))
                           (fun tac ipat c _ loc -> 
# 537 "plugins/ltac/g_tactic.mlg"
            CAst.make ~loc @@ TacAtom (TacAssert (true,true,Some tac,ipat,c)) 
# 2125 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("assert"))))))
                              ((Procq.Symbol.nterm constr)))
                             ((Procq.Symbol.nterm as_ipat)))
                            ((Procq.Symbol.nterm by_tactic)))
                           (fun tac ipat c _ loc -> 
# 535 "plugins/ltac/g_tactic.mlg"
            CAst.make ~loc @@ TacAtom (TacAssert (false,true,Some tac,ipat,c)) 
# 2140 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next
                                 (Procq.Rule.next
                                  (Procq.Rule.next (Procq.Rule.stop)
                                   ((Procq.Symbol.token (Tok.PIDENT (Some
                                   ("eenough"))))))
                                  ((Procq.Symbol.nterm test_lpar_id_colon)))
                                 ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                                ((Procq.Symbol.nterm identref)))
                               ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                              ((Procq.Symbol.nterm lconstr)))
                             ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                            ((Procq.Symbol.nterm by_tactic)))
                           (fun tac _ c _ lid _ _ _ loc -> 
# 531 "plugins/ltac/g_tactic.mlg"
            let { CAst.loc = loc; v = id } = lid in
          CAst.make ?loc @@ TacAtom ( TacAssert (true,false,Some tac,Some (CAst.make ?loc @@ IntroNaming (IntroIdentifier id)),c)) 
# 2164 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next
                                 (Procq.Rule.next
                                  (Procq.Rule.next (Procq.Rule.stop)
                                   ((Procq.Symbol.token (Tok.PIDENT (Some
                                   ("enough"))))))
                                  ((Procq.Symbol.nterm test_lpar_id_colon)))
                                 ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                                ((Procq.Symbol.nterm identref)))
                               ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                              ((Procq.Symbol.nterm lconstr)))
                             ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                            ((Procq.Symbol.nterm by_tactic)))
                           (fun tac _ c _ lid _ _ _ loc -> 
# 527 "plugins/ltac/g_tactic.mlg"
            let { CAst.loc = loc; v = id } = lid in
          CAst.make ?loc @@ TacAtom ( TacAssert (false,false,Some tac,Some (CAst.make ?loc @@ IntroNaming (IntroIdentifier id)),c)) 
# 2188 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next
                                 (Procq.Rule.next
                                  (Procq.Rule.next (Procq.Rule.stop)
                                   ((Procq.Symbol.token (Tok.PIDENT (Some
                                   ("eassert"))))))
                                  ((Procq.Symbol.nterm test_lpar_id_colon)))
                                 ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                                ((Procq.Symbol.nterm identref)))
                               ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                              ((Procq.Symbol.nterm lconstr)))
                             ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                            ((Procq.Symbol.nterm by_tactic)))
                           (fun tac _ c _ lid _ _ _ loc -> 
# 521 "plugins/ltac/g_tactic.mlg"
            let { CAst.loc = loc; v = id } = lid in
          CAst.make ?loc @@ TacAtom ( TacAssert (true,true,Some tac,Some (CAst.make ?loc @@ IntroNaming (IntroIdentifier id)),c)) 
# 2212 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next
                                 (Procq.Rule.next
                                  (Procq.Rule.next (Procq.Rule.stop)
                                   ((Procq.Symbol.token (Tok.PIDENT (Some
                                   ("assert"))))))
                                  ((Procq.Symbol.nterm test_lpar_id_colon)))
                                 ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                                ((Procq.Symbol.nterm identref)))
                               ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                              ((Procq.Symbol.nterm lconstr)))
                             ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                            ((Procq.Symbol.nterm by_tactic)))
                           (fun tac _ c _ lid _ _ _ loc -> 
# 517 "plugins/ltac/g_tactic.mlg"
            let { CAst.loc = loc; v = id } = lid in
          CAst.make ?loc @@ TacAtom ( TacAssert (false,true,Some tac,Some (CAst.make ?loc @@ IntroNaming (IntroIdentifier id)),c)) 
# 2236 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next
                                 (Procq.Rule.next (Procq.Rule.stop)
                                  ((Procq.Symbol.token (Tok.PIDENT (Some
                                  ("eassert"))))))
                                 ((Procq.Symbol.nterm test_lpar_id_coloneq)))
                                ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                               ((Procq.Symbol.nterm identref)))
                              ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                             ((Procq.Symbol.nterm lconstr)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                           (fun _ c _ lid _ _ _ loc -> 
# 511 "plugins/ltac/g_tactic.mlg"
            let { CAst.loc = loc; v = id } = lid in
          CAst.make ?loc @@ TacAtom ( TacAssert (true,true,None,Some (CAst.make ?loc @@ IntroNaming (IntroIdentifier id)),c)) 
# 2258 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next
                                 (Procq.Rule.next (Procq.Rule.stop)
                                  ((Procq.Symbol.token (Tok.PIDENT (Some
                                  ("assert"))))))
                                 ((Procq.Symbol.nterm test_lpar_id_coloneq)))
                                ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                               ((Procq.Symbol.nterm identref)))
                              ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                             ((Procq.Symbol.nterm lconstr)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                           (fun _ c _ lid _ _ _ loc -> 
# 507 "plugins/ltac/g_tactic.mlg"
            let { CAst.loc = loc; v = id } = lid in
          CAst.make ?loc @@ TacAtom ( TacAssert (false,true,None,Some (CAst.make ?loc @@ IntroNaming (IntroIdentifier id)),c)) 
# 2280 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PIDENT (Some
                                ("eremember"))))))
                               ((Procq.Symbol.nterm constr)))
                              ((Procq.Symbol.nterm as_name)))
                             ((Procq.Symbol.nterm eqn_ipat)))
                            ((Procq.Symbol.nterm clause_dft_all)))
                           (fun p e na c _ loc -> 
# 502 "plugins/ltac/g_tactic.mlg"
            CAst.make ~loc @@ TacAtom (TacLetTac (true,na,c,p,false,e)) 
# 2297 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PIDENT (Some
                                ("remember"))))))
                               ((Procq.Symbol.nterm constr)))
                              ((Procq.Symbol.nterm as_name)))
                             ((Procq.Symbol.nterm eqn_ipat)))
                            ((Procq.Symbol.nterm clause_dft_all)))
                           (fun p e na c _ loc -> 
# 499 "plugins/ltac/g_tactic.mlg"
            CAst.make ~loc @@ TacAtom (TacLetTac (false,na,c,p,false,e)) 
# 2314 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("eset"))))))
                              ((Procq.Symbol.nterm constr)))
                             ((Procq.Symbol.nterm as_name)))
                            ((Procq.Symbol.nterm clause_dft_concl)))
                           (fun p na c _ loc -> 
# 496 "plugins/ltac/g_tactic.mlg"
            CAst.make ~loc @@ TacAtom (TacLetTac (true,na,c,p,true,None)) 
# 2329 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("eset"))))))
                             ((Procq.Symbol.nterm bindings_with_parameters)))
                            ((Procq.Symbol.nterm clause_dft_concl)))
                           (fun p bl _ loc -> 
# 494 "plugins/ltac/g_tactic.mlg"
            let (id,c) = bl in CAst.make ~loc @@ TacAtom (TacLetTac (true,Names.Name id,c,p,true,None)) 
# 2342 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("set"))))))
                              ((Procq.Symbol.nterm constr)))
                             ((Procq.Symbol.nterm as_name)))
                            ((Procq.Symbol.nterm clause_dft_concl)))
                           (fun p na c _ loc -> 
# 492 "plugins/ltac/g_tactic.mlg"
            CAst.make ~loc @@ TacAtom (TacLetTac (false,na,c,p,true,None)) 
# 2357 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("set"))))))
                             ((Procq.Symbol.nterm bindings_with_parameters)))
                            ((Procq.Symbol.nterm clause_dft_concl)))
                           (fun p bl _ loc -> 
# 490 "plugins/ltac/g_tactic.mlg"
            let (id,c) = bl in CAst.make ~loc @@ TacAtom (TacLetTac (false,Names.Name.Name id,c,p,true,None)) 
# 2370 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("epose"))))))
                             ((Procq.Symbol.nterm constr)))
                            ((Procq.Symbol.nterm as_name)))
                           (fun na b _ loc -> 
# 488 "plugins/ltac/g_tactic.mlg"
            CAst.make ~loc @@ TacAtom (TacLetTac (true,na,b,Locusops.nowhere,true,None)) 
# 2383 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("epose"))))))
                            ((Procq.Symbol.nterm bindings_with_parameters)))
                           (fun bl _ loc -> 
# 486 "plugins/ltac/g_tactic.mlg"
            let (id,b) = bl in CAst.make ~loc @@ TacAtom (TacLetTac (true,Names.Name id,b,Locusops.nowhere,true,None)) 
# 2394 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("pose"))))))
                             ((Procq.Symbol.nterm constr)))
                            ((Procq.Symbol.nterm as_name)))
                           (fun na b _ loc -> 
# 484 "plugins/ltac/g_tactic.mlg"
            CAst.make ~loc @@ TacAtom (TacLetTac (false,na,b,Locusops.nowhere,true,None)) 
# 2407 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("pose"))))))
                            ((Procq.Symbol.nterm bindings_with_parameters)))
                           (fun bl _ loc -> 
# 482 "plugins/ltac/g_tactic.mlg"
            let (id,b) = bl in CAst.make ~loc @@ TacAtom (TacLetTac (false,Names.Name.Name id,b,Locusops.nowhere,true,None)) 
# 2418 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PKEYWORD ("cofix")))))
                              ((Procq.Symbol.nterm ident)))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("with")))))
                            ((Procq.Symbol.list1 ((Procq.Symbol.nterm cofixdecl)))))
                           (fun fd _ id _ loc -> 
# 479 "plugins/ltac/g_tactic.mlg"
            CAst.make ~loc @@ TacAtom (TacMutualCofix (id,List.map mk_cofix_tac fd)) 
# 2432 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PKEYWORD ("fix")))))
                               ((Procq.Symbol.nterm ident)))
                              ((Procq.Symbol.nterm natural)))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("with")))))
                            ((Procq.Symbol.list1 ((Procq.Symbol.nterm fixdecl)))))
                           (fun fd _ n id _ loc -> 
# 477 "plugins/ltac/g_tactic.mlg"
            CAst.make ~loc @@ TacAtom (TacMutualFix (id,n,List.map mk_fix_tac fd)) 
# 2448 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("ecase"))))))
                            ((Procq.Symbol.nterm induction_clause_list)))
                           (fun icl _ loc -> 
# 475 "plugins/ltac/g_tactic.mlg"
                                                        CAst.make ~loc @@ TacAtom (mkTacCase true icl) 
# 2459 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("case"))))))
                            ((Procq.Symbol.nterm induction_clause_list)))
                           (fun icl _ loc -> 
# 474 "plugins/ltac/g_tactic.mlg"
                                                       CAst.make ~loc @@ TacAtom (mkTacCase false icl) 
# 2470 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("eelim"))))))
                             ((Procq.Symbol.nterm constr_with_bindings_arg)))
                            ((Procq.Symbol.opt (Procq.Symbol.nterm eliminator))))
                           (fun el cl _ loc -> 
# 473 "plugins/ltac/g_tactic.mlg"
            CAst.make ~loc @@ TacAtom (TacElim (true,cl,el)) 
# 2483 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("elim"))))))
                             ((Procq.Symbol.nterm constr_with_bindings_arg)))
                            ((Procq.Symbol.opt (Procq.Symbol.nterm eliminator))))
                           (fun el cl _ loc -> 
# 471 "plugins/ltac/g_tactic.mlg"
            CAst.make ~loc @@ TacAtom (TacElim (false,cl,el)) 
# 2496 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("simple"))))))
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("eapply"))))))
                             ((Procq.Symbol.list1sep ((Procq.Symbol.nterm constr_with_bindings_arg)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (","))])) false)))
                            ((Procq.Symbol.nterm in_hyp_as)))
                           (fun inhyp cl _ _ loc -> 
# 469 "plugins/ltac/g_tactic.mlg"
                                 CAst.make ~loc @@ TacAtom (TacApply (false,true,cl,inhyp)) 
# 2512 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("simple"))))))
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("apply"))))))
                             ((Procq.Symbol.list1sep ((Procq.Symbol.nterm constr_with_bindings_arg)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (","))])) false)))
                            ((Procq.Symbol.nterm in_hyp_as)))
                           (fun inhyp cl _ _ loc -> 
# 466 "plugins/ltac/g_tactic.mlg"
                                 CAst.make ~loc @@ TacAtom (TacApply (false,false,cl,inhyp)) 
# 2528 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("eapply"))))))
                             ((Procq.Symbol.list1sep ((Procq.Symbol.nterm constr_with_bindings_arg)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (","))])) false)))
                            ((Procq.Symbol.nterm in_hyp_as)))
                           (fun inhyp cl _ loc -> 
# 463 "plugins/ltac/g_tactic.mlg"
                                 CAst.make ~loc @@ TacAtom (TacApply (true,true,cl,inhyp)) 
# 2541 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("apply"))))))
                             ((Procq.Symbol.list1sep ((Procq.Symbol.nterm constr_with_bindings_arg)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (","))])) false)))
                            ((Procq.Symbol.nterm in_hyp_as)))
                           (fun inhyp cl _ loc -> 
# 461 "plugins/ltac/g_tactic.mlg"
                                 CAst.make ~loc @@ TacAtom (TacApply (true,false,cl,inhyp)) 
# 2554 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("eintros"))))))
                           (fun _ loc -> 
# 458 "plugins/ltac/g_tactic.mlg"
            CAst.make ~loc @@ TacAtom (TacIntroPattern (true,[CAst.make ~loc @@IntroForthcoming false])) 
# 2563 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("eintros"))))))
                            ((Procq.Symbol.nterm ne_intropatterns)))
                           (fun pl _ loc -> 
# 456 "plugins/ltac/g_tactic.mlg"
            CAst.make ~loc @@ TacAtom (TacIntroPattern (true,pl)) 
# 2574 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("intros"))))))
                           (fun _ loc -> 
# 454 "plugins/ltac/g_tactic.mlg"
            CAst.make ~loc @@ TacAtom (TacIntroPattern (false,[CAst.make ~loc @@IntroForthcoming false])) 
# 2583 "plugins/ltac/g_tactic.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("intros"))))))
                            ((Procq.Symbol.nterm ne_intropatterns)))
                           (fun pl _ loc -> 
# 452 "plugins/ltac/g_tactic.mlg"
            CAst.make ~loc @@ TacAtom (TacIntroPattern (false,pl)) 
# 2594 "plugins/ltac/g_tactic.ml"
)])]))
  in ()

