#  Copyright 2000-2025 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.

from typing import Any

def track_cascade_events(descriptor, prop): ...

class UOWTransaction:
    session: Any
    attributes: Any
    deps: Any
    mappers: Any
    presort_actions: Any
    postsort_actions: Any
    dependencies: Any
    states: Any
    post_update_states: Any
    def __init__(self, session): ...
    @property
    def has_work(self): ...
    def was_already_deleted(self, state): ...
    def is_deleted(self, state): ...
    def memo(self, key, callable_): ...
    def remove_state_actions(self, state) -> None: ...
    def get_attribute_history(self, state, key, passive=...): ...
    def has_dep(self, processor): ...
    def register_preprocessor(self, processor, fromparent) -> None: ...
    def register_object(
        self,
        state,
        isdelete: bool = ...,
        listonly: bool = ...,
        cancel_delete: bool = ...,
        operation: Any | None = ...,
        prop: Any | None = ...,
    ): ...
    def register_post_update(self, state, post_update_cols) -> None: ...
    def filter_states_for_dep(self, dep, states): ...
    def states_for_mapper_hierarchy(self, mapper, isdelete, listonly) -> None: ...
    def execute(self): ...
    def finalize_flush_changes(self) -> None: ...

class IterateMappersMixin: ...

class Preprocess(IterateMappersMixin):
    dependency_processor: Any
    fromparent: Any
    processed: Any
    setup_flush_actions: bool
    def __init__(self, dependency_processor, fromparent) -> None: ...
    def execute(self, uow): ...

class PostSortRec:
    disabled: Any
    # At runtime __new__ is defined, not __init__,
    # But if we define __new__ here then all subclasses are identified by pyright
    # as having __init__ methods that are inconsistent with their __new__ methods
    def __init__(self, uow, *args) -> None: ...
    def execute_aggregate(self, uow, recs) -> None: ...

class ProcessAll(IterateMappersMixin, PostSortRec):
    dependency_processor: Any
    sort_key: Any
    isdelete: Any
    fromparent: Any
    def __init__(self, uow, dependency_processor, isdelete, fromparent) -> None: ...
    def execute(self, uow) -> None: ...
    def per_state_flush_actions(self, uow): ...

class PostUpdateAll(PostSortRec):
    mapper: Any
    isdelete: Any
    sort_key: Any
    def __init__(self, uow, mapper, isdelete) -> None: ...
    def execute(self, uow) -> None: ...

class SaveUpdateAll(PostSortRec):
    mapper: Any
    sort_key: Any
    def __init__(self, uow, mapper) -> None: ...
    def execute(self, uow) -> None: ...
    def per_state_flush_actions(self, uow) -> None: ...

class DeleteAll(PostSortRec):
    mapper: Any
    sort_key: Any
    def __init__(self, uow, mapper) -> None: ...
    def execute(self, uow) -> None: ...
    def per_state_flush_actions(self, uow) -> None: ...

class ProcessState(PostSortRec):
    dependency_processor: Any
    sort_key: Any
    isdelete: Any
    state: Any
    def __init__(self, uow, dependency_processor, isdelete, state) -> None: ...
    def execute_aggregate(self, uow, recs) -> None: ...

class SaveUpdateState(PostSortRec):
    state: Any
    mapper: Any
    sort_key: Any
    def __init__(self, uow, state) -> None: ...
    def execute_aggregate(self, uow, recs) -> None: ...

class DeleteState(PostSortRec):
    state: Any
    mapper: Any
    sort_key: Any
    def __init__(self, uow, state) -> None: ...
    def execute_aggregate(self, uow, recs) -> None: ...
