/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.context;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.ClassIndexedSet;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.DeprecationSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.messaging.MessageRuntimeException;
import org.slf4j.Logger;

@NotThreadSafe
public abstract class BaseContext
implements Iterable<BaseContext> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BaseContext.class);
    @Nullable
    private BaseContext parent;
    @Nonnull
    private ClassIndexedSet<BaseContext> subcontexts = new ClassIndexedSet();

    @Nullable
    public BaseContext getParent() {
        return this.parent;
    }

    protected void setParent(@Nullable BaseContext newParent) {
        this.parent = newParent;
    }

    @Nullable
    public <T extends BaseContext> T getSubcontext(@Nonnull Class<T> clazz) {
        return this.getSubcontext(clazz, false);
    }

    @Nonnull
    public <T extends BaseContext> T ensureSubcontext(@Nonnull Class<T> clazz) {
        T newContext = this.getSubcontext(clazz, true);
        if (newContext == null) {
            throw new IllegalStateException("Context of type '" + clazz.getName() + "' did not exist or was not created");
        }
        return newContext;
    }

    @Deprecated(since="5.0.0", forRemoval=false)
    @Nullable
    public <T extends BaseContext> T getSubcontext(@Nonnull Class<T> clazz, boolean autocreate) {
        Constraint.isNotNull(clazz, "Class type cannot be null");
        this.log.trace("Request for subcontext of type: {}", (Object)clazz.getName());
        BaseContext subcontext = (BaseContext)this.subcontexts.get(clazz);
        if (subcontext != null) {
            this.log.trace("Subcontext found of type: {}", (Object)clazz.getName());
            return (T)subcontext;
        }
        if (autocreate) {
            this.log.trace("Subcontext not found of type, autocreating: {}", (Object)clazz.getName());
            subcontext = this.createSubcontext(clazz);
            this.addSubcontext(subcontext);
            return (T)subcontext;
        }
        this.log.trace("Subcontext not found of type: {}", (Object)clazz.getName());
        return null;
    }

    @Nullable
    public BaseContext getSubcontext(@Nonnull @NotEmpty String className) {
        return this.getSubcontext(className, false);
    }

    @Nullable
    public BaseContext ensureSubcontext(@Nonnull @NotEmpty String className) {
        BaseContext newContext = this.getSubcontext(className, true);
        if (newContext == null) {
            throw new IllegalStateException("Context of type '" + className + "' did not exist or was not created");
        }
        return newContext;
    }

    @Deprecated(since="5.0.0", forRemoval=false)
    @Nullable
    public BaseContext getSubcontext(@Nonnull @NotEmpty String className, boolean autocreate) {
        try {
            return this.getSubcontext(Class.forName(className).asSubclass(BaseContext.class), autocreate);
        }
        catch (ClassNotFoundException e) {
            Class<? extends BaseContext> claz;
            DeprecatedContextClassNameLookAside lookaside = ConfigurationService.get(DeprecatedContextClassNameLookAside.class);
            if (lookaside != null && (claz = lookaside.get(className)) != null) {
                return this.getSubcontext(claz, autocreate);
            }
            if (!autocreate) {
                for (BaseContext child : this) {
                    if (!child.getClass().getSimpleName().equals(className)) continue;
                    return child;
                }
            }
            this.log.warn("Trapped ClassNotFoundException on input: " + className);
            return null;
        }
    }

    @Nonnull
    public BaseContext addSubcontext(@Nonnull BaseContext subContext) {
        return this.addSubcontext(subContext, false);
    }

    @Nonnull
    public BaseContext addSubcontext(@Nonnull BaseContext subcontext, boolean replace) {
        Constraint.isNotNull(subcontext, "Subcontext cannot be null");
        BaseContext existing = (BaseContext)this.subcontexts.get(subcontext.getClass());
        if (existing == subcontext) {
            this.log.trace("Subcontext to add is already a child of the current context, skipping");
            return subcontext;
        }
        this.log.trace("Attempting to store a subcontext with type '{}' with replace option '{}'", new Object[]{subcontext.getClass().getName(), Boolean.valueOf(replace).toString()});
        this.subcontexts.add(subcontext, replace);
        BaseContext oldParent = subcontext.getParent();
        if (oldParent != null && oldParent != this) {
            this.log.trace("New subcontext with type '{}' is currently a subcontext of parent with type '{}', removing it", new Object[]{subcontext.getClass().getName(), oldParent.getClass().getName()});
            oldParent.removeSubcontext(subcontext);
        }
        this.log.trace("New subcontext with type '{}' set to have parent with type '{}'", new Object[]{subcontext.getClass().getName(), this.getClass().getName()});
        subcontext.setParent(this);
        if (existing != null) {
            this.log.trace("Old subcontext with type '{}' will have parent cleared", (Object)existing.getClass().getName());
            existing.setParent(null);
        }
        return subcontext;
    }

    public void removeSubcontext(@Nonnull BaseContext subcontext) {
        Constraint.isNotNull(subcontext, "Subcontext cannot be null");
        this.log.trace("Removing subcontext with type '{}' from parent with type '{}'", new Object[]{subcontext.getClass().getName(), this.getClass().getName()});
        subcontext.setParent(null);
        this.subcontexts.remove(subcontext);
    }

    public void removeFromParent() {
        BaseContext localParent = this.getParent();
        if (localParent == null) {
            return;
        }
        localParent.removeSubcontext(this);
    }

    public <T extends BaseContext> void removeSubcontext(@Nonnull Class<T> clazz) {
        T subcontext = this.getSubcontext(clazz);
        if (subcontext != null) {
            this.removeSubcontext((BaseContext)subcontext);
        }
    }

    public <T extends BaseContext> boolean containsSubcontext(@Nonnull Class<T> clazz) {
        Constraint.isNotNull(clazz, "Class type cannot be null");
        return this.subcontexts.contains(clazz);
    }

    public void clearSubcontexts() {
        this.log.trace("Clearing all subcontexts from context with type '{}'", (Object)this.getClass().getName());
        for (BaseContext subcontext : this.subcontexts) {
            subcontext.setParent(null);
        }
        this.subcontexts.clear();
    }

    @Override
    @Nonnull
    public Iterator<BaseContext> iterator() {
        return new ContextSetNoRemoveIteratorDecorator(this.subcontexts.iterator());
    }

    @Nonnull
    protected <T extends BaseContext> T createSubcontext(@Nonnull Class<T> clazz) {
        try {
            return (T)((BaseContext)clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            this.log.error("Error creating subcontext: {}", (Object)e.getMessage());
            throw new MessageRuntimeException("Error creating subcontext", e);
        }
    }

    public static class DeprecatedContextClassNameLookAside {
        @Nonnull
        private final Map<String, Class<? extends BaseContext>> lookAsideMap;

        public DeprecatedContextClassNameLookAside(@Nullable Map<String, Class<? extends BaseContext>> map) {
            this.lookAsideMap = map != null ? CollectionSupport.copyToMap(map) : CollectionSupport.emptyMap();
        }

        @Nullable
        public Class<? extends BaseContext> get(@Nonnull String name) {
            Class<? extends BaseContext> claz = this.lookAsideMap.get(name);
            if (claz != null) {
                DeprecationSupport.warn(DeprecationSupport.ObjectType.CLASS, name, null, claz.getName());
            }
            return claz;
        }
    }

    protected class ContextSetNoRemoveIteratorDecorator
    implements Iterator<BaseContext> {
        private Iterator<BaseContext> wrappedIterator;

        protected ContextSetNoRemoveIteratorDecorator(Iterator<BaseContext> iterator) {
            this.wrappedIterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.wrappedIterator.hasNext();
        }

        @Override
        public BaseContext next() {
            return this.wrappedIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Removal of subcontexts via the iterator is unsupported");
        }
    }
}

