/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.extensions;

import java.util.Map;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.Expression;
import software.amazon.awssdk.enhanced.dynamodb.update.UpdateExpression;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkPublicApi
@ThreadSafe
public final class WriteModification {
    private final Map<String, AttributeValue> transformedItem;
    private final Expression additionalConditionalExpression;
    private final UpdateExpression updateExpression;

    private WriteModification(Builder builder) {
        this.transformedItem = builder.transformedItem;
        this.additionalConditionalExpression = builder.additionalConditionalExpression;
        this.updateExpression = builder.updateExpression;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Map<String, AttributeValue> transformedItem() {
        return this.transformedItem;
    }

    public Expression additionalConditionalExpression() {
        return this.additionalConditionalExpression;
    }

    public UpdateExpression updateExpression() {
        return this.updateExpression;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WriteModification that = (WriteModification)o;
        if (this.transformedItem != null ? !this.transformedItem.equals(that.transformedItem) : that.transformedItem != null) {
            return false;
        }
        if (this.additionalConditionalExpression != null ? !this.additionalConditionalExpression.equals(that.additionalConditionalExpression) : that.additionalConditionalExpression != null) {
            return false;
        }
        return this.updateExpression != null ? this.updateExpression.equals(that.updateExpression) : that.updateExpression == null;
    }

    public int hashCode() {
        int result = this.transformedItem != null ? this.transformedItem.hashCode() : 0;
        result = 31 * result + (this.additionalConditionalExpression != null ? this.additionalConditionalExpression.hashCode() : 0);
        result = 31 * result + (this.updateExpression != null ? this.updateExpression.hashCode() : 0);
        return result;
    }

    @NotThreadSafe
    public static final class Builder {
        private Map<String, AttributeValue> transformedItem;
        private Expression additionalConditionalExpression;
        private UpdateExpression updateExpression;

        private Builder() {
        }

        public Builder transformedItem(Map<String, AttributeValue> transformedItem) {
            this.transformedItem = transformedItem;
            return this;
        }

        public Builder additionalConditionalExpression(Expression additionalConditionalExpression) {
            this.additionalConditionalExpression = additionalConditionalExpression;
            return this;
        }

        public Builder updateExpression(UpdateExpression updateExpression) {
            this.updateExpression = updateExpression;
            return this;
        }

        public WriteModification build() {
            return new WriteModification(this);
        }
    }
}

