/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.indexInsight.MLIndexInsightConfigGetAction;
import org.opensearch.ml.common.transport.indexInsight.MLIndexInsightConfigGetRequest;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.node.NodeClient;

public class RestMLGetIndexInsightConfigAction
extends BaseRestHandler {
    private static final String ML_GET_INDEX_INSIGHT_CONFIG_ACTION = "ml_get_index_insight_config_action";
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLGetIndexInsightConfigAction(MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_GET_INDEX_INSIGHT_CONFIG_ACTION;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        MLIndexInsightConfigGetRequest mlIndexInsightConfigGetRequest = this.getRequest(restRequest);
        return channel -> client.execute((ActionType)MLIndexInsightConfigGetAction.INSTANCE, (ActionRequest)mlIndexInsightConfigGetRequest, (ActionListener)new RestToXContentListener(channel));
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, String.format(Locale.ROOT, "%s/index_insight_config/", "/_plugins/_ml")));
    }

    @VisibleForTesting
    MLIndexInsightConfigGetRequest getRequest(RestRequest request) throws IOException {
        if (!this.mlFeatureEnabledSetting.isAgentFrameworkEnabled()) {
            throw new IllegalStateException("Agent Framework is currently disabled. To enable it, update the setting \"plugins.ml_commons.agent_framework_enabled\" to true.");
        }
        String tenantId = TenantAwareHelper.getTenantID(this.mlFeatureEnabledSetting.isMultiTenancyEnabled(), request);
        return new MLIndexInsightConfigGetRequest(tenantId);
    }
}

