/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.query.criteria.JpaCastTarget;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.tree.AbstractSqmNode;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.SqmTypedNode;

public class SqmCastTarget<T>
extends AbstractSqmNode
implements SqmTypedNode<T>,
JpaCastTarget<T> {
    private final ReturnableType<T> type;
    private final Long length;
    private final Integer precision;
    private final Integer scale;

    public SqmCastTarget(ReturnableType<T> type, NodeBuilder nodeBuilder) {
        this(type, null, nodeBuilder);
    }

    public SqmCastTarget(ReturnableType<T> type, Long length, NodeBuilder nodeBuilder) {
        this(type, length, null, null, nodeBuilder);
    }

    public SqmCastTarget(ReturnableType<T> type, Integer precision, Integer scale, NodeBuilder nodeBuilder) {
        this(type, null, precision, scale, nodeBuilder);
    }

    public SqmCastTarget(ReturnableType<T> type, Long length, Integer precision, Integer scale, NodeBuilder nodeBuilder) {
        super(nodeBuilder);
        this.type = type;
        this.length = length;
        this.precision = precision;
        this.scale = scale;
    }

    @Override
    public @Nullable Long getLength() {
        return this.length;
    }

    @Override
    public @Nullable Integer getPrecision() {
        return this.precision;
    }

    @Override
    public @Nullable Integer getScale() {
        return this.scale;
    }

    @Override
    public SqmCastTarget<T> copy(SqmCopyContext context) {
        return this;
    }

    @Override
    public ReturnableType<T> getType() {
        return this.type;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitCastTarget(this);
    }

    @Override
    public SqmBindableType<T> getNodeType() {
        return this.nodeBuilder().resolveExpressible(this.type);
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        hql.append(this.type.getTypeName());
        if (this.precision != null) {
            hql.append('(');
            hql.append(this.precision);
            if (this.scale != null) {
                hql.append(", ");
                hql.append(this.scale);
            }
            hql.append(')');
        } else if (this.length != null) {
            hql.append('(');
            hql.append(this.length);
            hql.append(')');
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof SqmCastTarget)) return false;
        SqmCastTarget that = (SqmCastTarget)object;
        if (!Objects.equals(this.type, that.type)) return false;
        if (!Objects.equals(this.length, that.length)) return false;
        if (!Objects.equals(this.precision, that.precision)) return false;
        if (!Objects.equals(this.scale, that.scale)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.type, this.length, this.precision, this.scale);
    }
}

