/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.lafwidget.utils;

import org.jvnet.lafwidget.animation.FadeAccelerationStep;
import org.jvnet.lafwidget.animation.FadeConstantStep;
import org.jvnet.lafwidget.animation.FadeStep;

public class LafConstants {

    public static class TabOverviewKind {
        public static final TabOverviewKind GRID = new TabOverviewKind("grid");
        public static final TabOverviewKind ROUND_CAROUSEL = new TabOverviewKind("round carousel");
        public static final TabOverviewKind MENU_CAROUSEL = new TabOverviewKind("menu carousel");
        private String name;

        public TabOverviewKind(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class PasswordStrength {
        public static final PasswordStrength WEAK = new PasswordStrength();
        public static final PasswordStrength MEDIUM = new PasswordStrength();
        public static final PasswordStrength STRONG = new PasswordStrength();

        private PasswordStrength() {
        }
    }

    public static class AnimationKind {
        public static final AnimationKind NONE = new AnimationKind(new FadeConstantStep(1.1f), "none");
        public static final AnimationKind DEBUG_SLOW = new AnimationKind(new FadeConstantStep(0.002f), "debugSlow");
        public static final AnimationKind DEBUG = new AnimationKind(new FadeConstantStep(0.01f), "debug");
        public static final AnimationKind DEBUG_FAST = new AnimationKind(new FadeConstantStep(0.05f), "debugFast");
        public static final AnimationKind SLOW = new AnimationKind(new FadeConstantStep(0.1f), "slow");
        public static final AnimationKind REGULAR = new AnimationKind(new FadeConstantStep(0.2f), "regular");
        public static final AnimationKind FAST = new AnimationKind(new FadeConstantStep(0.3f), "fast");
        private FadeStep step;
        private String name;

        public AnimationKind(FadeStep step, String name) {
            this.step = step;
            this.name = name;
        }

        public FadeStep getStep() {
            return this.step;
        }

        public String getName() {
            return this.name;
        }

        public AnimationKind derive(float factor) {
            FadeStep origStep = this.step;
            String origName = this.name;
            return new AnimationKind(new FadeAccelerationStep(origStep, factor), origName + ".derived." + factor);
        }
    }
}

