_hq() {
    local i cur prev opts cmd
    COMPREPLY=()
    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
        cur="$2"
    else
        cur="${COMP_WORDS[COMP_CWORD]}"
    fi
    prev="$3"
    cmd=""
    opts=""

    for i in "${COMP_WORDS[@]:0:COMP_CWORD}"
    do
        case "${cmd},${i}" in
            ",$1")
                cmd="hq"
                ;;
            hq,alloc)
                cmd="hq__alloc"
                ;;
            hq,dashboard)
                cmd="hq__dashboard"
                ;;
            hq,data)
                cmd="hq__data"
                ;;
            hq,doc)
                cmd="hq__doc"
                ;;
            hq,generate-completion)
                cmd="hq__generate__completion"
                ;;
            hq,job)
                cmd="hq__job"
                ;;
            hq,journal)
                cmd="hq__journal"
                ;;
            hq,output-log)
                cmd="hq__output__log"
                ;;
            hq,server)
                cmd="hq__server"
                ;;
            hq,submit)
                cmd="hq__submit"
                ;;
            hq,task)
                cmd="hq__task"
                ;;
            hq,worker)
                cmd="hq__worker"
                ;;
            hq__alloc,add)
                cmd="hq__alloc__add"
                ;;
            hq__alloc,dry-run)
                cmd="hq__alloc__dry__run"
                ;;
            hq__alloc,info)
                cmd="hq__alloc__info"
                ;;
            hq__alloc,list)
                cmd="hq__alloc__list"
                ;;
            hq__alloc,log)
                cmd="hq__alloc__log"
                ;;
            hq__alloc,pause)
                cmd="hq__alloc__pause"
                ;;
            hq__alloc,remove)
                cmd="hq__alloc__remove"
                ;;
            hq__alloc,resume)
                cmd="hq__alloc__resume"
                ;;
            hq__alloc__add,pbs)
                cmd="hq__alloc__add__pbs"
                ;;
            hq__alloc__add,slurm)
                cmd="hq__alloc__add__slurm"
                ;;
            hq__alloc__dry__run,pbs)
                cmd="hq__alloc__dry__run__pbs"
                ;;
            hq__alloc__dry__run,slurm)
                cmd="hq__alloc__dry__run__slurm"
                ;;
            hq__dashboard,replay)
                cmd="hq__dashboard__replay"
                ;;
            hq__dashboard,stream)
                cmd="hq__dashboard__stream"
                ;;
            hq__data,get)
                cmd="hq__data__get"
                ;;
            hq__data,put)
                cmd="hq__data__put"
                ;;
            hq__doc,autoalloc)
                cmd="hq__doc__autoalloc"
                ;;
            hq__doc,changelog)
                cmd="hq__doc__changelog"
                ;;
            hq__doc,cheatsheet)
                cmd="hq__doc__cheatsheet"
                ;;
            hq__doc,faq)
                cmd="hq__doc__faq"
                ;;
            hq__doc,job)
                cmd="hq__doc__job"
                ;;
            hq__doc,jobs)
                cmd="hq__doc__job"
                ;;
            hq__doc,pbs)
                cmd="hq__doc__autoalloc"
                ;;
            hq__doc,python)
                cmd="hq__doc__python__api"
                ;;
            hq__doc,python-api)
                cmd="hq__doc__python__api"
                ;;
            hq__doc,resources)
                cmd="hq__doc__resources"
                ;;
            hq__doc,slurm)
                cmd="hq__doc__autoalloc"
                ;;
            hq__doc,taskarray)
                cmd="hq__doc__taskarray"
                ;;
            hq__doc,tasks)
                cmd="hq__doc__job"
                ;;
            hq__doc,worker)
                cmd="hq__doc__worker"
                ;;
            hq__doc,workers)
                cmd="hq__doc__worker"
                ;;
            hq__job,cancel)
                cmd="hq__job__cancel"
                ;;
            hq__job,cat)
                cmd="hq__job__cat"
                ;;
            hq__job,close)
                cmd="hq__job__close"
                ;;
            hq__job,forget)
                cmd="hq__job__forget"
                ;;
            hq__job,info)
                cmd="hq__job__info"
                ;;
            hq__job,list)
                cmd="hq__job__list"
                ;;
            hq__job,open)
                cmd="hq__job__open"
                ;;
            hq__job,progress)
                cmd="hq__job__progress"
                ;;
            hq__job,submit)
                cmd="hq__job__submit"
                ;;
            hq__job,submit-file)
                cmd="hq__job__submit__file"
                ;;
            hq__job,summary)
                cmd="hq__job__summary"
                ;;
            hq__job,task-ids)
                cmd="hq__job__task__ids"
                ;;
            hq__job,wait)
                cmd="hq__job__wait"
                ;;
            hq__journal,export)
                cmd="hq__journal__export"
                ;;
            hq__journal,flush)
                cmd="hq__journal__flush"
                ;;
            hq__journal,prune)
                cmd="hq__journal__prune"
                ;;
            hq__journal,replay)
                cmd="hq__journal__replay"
                ;;
            hq__journal,stream)
                cmd="hq__journal__stream"
                ;;
            hq__output__log,cat)
                cmd="hq__output__log__cat"
                ;;
            hq__output__log,export)
                cmd="hq__output__log__export"
                ;;
            hq__output__log,jobs)
                cmd="hq__output__log__jobs"
                ;;
            hq__output__log,show)
                cmd="hq__output__log__show"
                ;;
            hq__output__log,summary)
                cmd="hq__output__log__summary"
                ;;
            hq__server,debug-dump)
                cmd="hq__server__debug__dump"
                ;;
            hq__server,generate-access)
                cmd="hq__server__generate__access"
                ;;
            hq__server,info)
                cmd="hq__server__info"
                ;;
            hq__server,start)
                cmd="hq__server__start"
                ;;
            hq__server,stop)
                cmd="hq__server__stop"
                ;;
            hq__server,wait)
                cmd="hq__server__wait"
                ;;
            hq__task,explain)
                cmd="hq__task__explain"
                ;;
            hq__task,info)
                cmd="hq__task__info"
                ;;
            hq__task,list)
                cmd="hq__task__list"
                ;;
            hq__worker,address)
                cmd="hq__worker__address"
                ;;
            hq__worker,deploy-ssh)
                cmd="hq__worker__deploy__ssh"
                ;;
            hq__worker,hwdetect)
                cmd="hq__worker__hwdetect"
                ;;
            hq__worker,info)
                cmd="hq__worker__info"
                ;;
            hq__worker,list)
                cmd="hq__worker__list"
                ;;
            hq__worker,start)
                cmd="hq__worker__start"
                ;;
            hq__worker,stop)
                cmd="hq__worker__stop"
                ;;
            hq__worker,wait)
                cmd="hq__worker__wait"
                ;;
            *)
                ;;
        esac
    done

    case "${cmd}" in
        hq)
            opts="-h -V --server-dir --colors --output-mode --debug --help --version server job task submit worker output-log alloc journal data dashboard doc generate-completion"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 1 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__alloc)
            opts="-h --server-dir --colors --output-mode --debug --help list info log add pause resume dry-run remove"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__alloc__add)
            opts="-h --server-dir --colors --output-mode --debug --help pbs slurm"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__alloc__add__pbs)
            opts="-b -t -m -n -h --backlog --time-limit --max-workers-per-alloc --max-worker-count --name --cpus --resource --group --coupling --detect-resources --no-hyper-threading --idle-timeout --overview-interval --on-server-lost --no-dry-run --worker-start-cmd --worker-stop-cmd --worker-wrap-cmd --worker-time-limit --min-utilization --server-dir --colors --output-mode --debug --help [ADDITIONAL_ARGS]..."
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 4 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --backlog)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -b)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --time-limit)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -t)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --max-workers-per-alloc)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -m)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --max-worker-count)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --name)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -n)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --cpus)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --resource)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --group)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --coupling)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --detect-resources)
                    COMPREPLY=($(compgen -W "all none cpus mem gpus/nvidia gpus/amd" -- "${cur}"))
                    return 0
                    ;;
                --idle-timeout)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --overview-interval)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --on-server-lost)
                    COMPREPLY=($(compgen -W "stop finish-running" -- "${cur}"))
                    return 0
                    ;;
                --worker-start-cmd)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --worker-stop-cmd)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --worker-wrap-cmd)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --worker-time-limit)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --min-utilization)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__alloc__add__slurm)
            opts="-b -t -m -n -h --backlog --time-limit --max-workers-per-alloc --max-worker-count --name --cpus --resource --group --coupling --detect-resources --no-hyper-threading --idle-timeout --overview-interval --on-server-lost --no-dry-run --worker-start-cmd --worker-stop-cmd --worker-wrap-cmd --worker-time-limit --min-utilization --server-dir --colors --output-mode --debug --help [ADDITIONAL_ARGS]..."
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 4 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --backlog)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -b)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --time-limit)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -t)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --max-workers-per-alloc)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -m)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --max-worker-count)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --name)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -n)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --cpus)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --resource)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --group)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --coupling)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --detect-resources)
                    COMPREPLY=($(compgen -W "all none cpus mem gpus/nvidia gpus/amd" -- "${cur}"))
                    return 0
                    ;;
                --idle-timeout)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --overview-interval)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --on-server-lost)
                    COMPREPLY=($(compgen -W "stop finish-running" -- "${cur}"))
                    return 0
                    ;;
                --worker-start-cmd)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --worker-stop-cmd)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --worker-wrap-cmd)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --worker-time-limit)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --min-utilization)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__alloc__dry__run)
            opts="-h --server-dir --colors --output-mode --debug --help pbs slurm"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__alloc__dry__run__pbs)
            opts="-b -t -m -n -h --backlog --time-limit --max-workers-per-alloc --max-worker-count --name --cpus --resource --group --coupling --detect-resources --no-hyper-threading --idle-timeout --overview-interval --on-server-lost --no-dry-run --worker-start-cmd --worker-stop-cmd --worker-wrap-cmd --worker-time-limit --min-utilization --server-dir --colors --output-mode --debug --help [ADDITIONAL_ARGS]..."
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 4 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --backlog)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -b)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --time-limit)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -t)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --max-workers-per-alloc)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -m)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --max-worker-count)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --name)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -n)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --cpus)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --resource)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --group)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --coupling)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --detect-resources)
                    COMPREPLY=($(compgen -W "all none cpus mem gpus/nvidia gpus/amd" -- "${cur}"))
                    return 0
                    ;;
                --idle-timeout)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --overview-interval)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --on-server-lost)
                    COMPREPLY=($(compgen -W "stop finish-running" -- "${cur}"))
                    return 0
                    ;;
                --worker-start-cmd)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --worker-stop-cmd)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --worker-wrap-cmd)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --worker-time-limit)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --min-utilization)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__alloc__dry__run__slurm)
            opts="-b -t -m -n -h --backlog --time-limit --max-workers-per-alloc --max-worker-count --name --cpus --resource --group --coupling --detect-resources --no-hyper-threading --idle-timeout --overview-interval --on-server-lost --no-dry-run --worker-start-cmd --worker-stop-cmd --worker-wrap-cmd --worker-time-limit --min-utilization --server-dir --colors --output-mode --debug --help [ADDITIONAL_ARGS]..."
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 4 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --backlog)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -b)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --time-limit)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -t)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --max-workers-per-alloc)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -m)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --max-worker-count)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --name)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -n)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --cpus)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --resource)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --group)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --coupling)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --detect-resources)
                    COMPREPLY=($(compgen -W "all none cpus mem gpus/nvidia gpus/amd" -- "${cur}"))
                    return 0
                    ;;
                --idle-timeout)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --overview-interval)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --on-server-lost)
                    COMPREPLY=($(compgen -W "stop finish-running" -- "${cur}"))
                    return 0
                    ;;
                --worker-start-cmd)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --worker-stop-cmd)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --worker-wrap-cmd)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --worker-time-limit)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --min-utilization)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__alloc__info)
            opts="-h --filter --server-dir --colors --output-mode --debug --help <QUEUE>"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --filter)
                    COMPREPLY=($(compgen -W "queued running finished failed" -- "${cur}"))
                    return 0
                    ;;
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__alloc__list)
            opts="-h --server-dir --colors --output-mode --debug --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__alloc__log)
            opts="-h --server-dir --colors --output-mode --debug --help <ALLOCATION> stdout stderr"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__alloc__pause)
            opts="-h --server-dir --colors --output-mode --debug --help <QUEUE_ID>"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__alloc__remove)
            opts="-h --force --server-dir --colors --output-mode --debug --help <QUEUE_ID>"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__alloc__resume)
            opts="-h --server-dir --colors --output-mode --debug --help <QUEUE_ID>"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__dashboard)
            opts="-h --server-dir --colors --output-mode --debug --help stream replay"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__dashboard__replay)
            opts="-h --server-dir --colors --output-mode --debug --help <JOURNAL>"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__dashboard__stream)
            opts="-h --server-dir --colors --output-mode --debug --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__data)
            opts="-h --server-dir --colors --output-mode --debug --help put get"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__data__get)
            opts="-h --server-dir --colors --output-mode --debug --help <INPUT_ID> <PATH>"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__data__put)
            opts="-h --mime-type --server-dir --colors --output-mode --debug --help <DATA_ID> <PATH>"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --mime-type)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__doc)
            opts="-h --open --server-dir --colors --output-mode --debug --help job jobs tasks taskarray resources worker workers autoalloc pbs slurm python-api python cheatsheet changelog faq"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__doc__autoalloc)
            opts="-h --open --server-dir --colors --output-mode --debug --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__doc__changelog)
            opts="-h --open --server-dir --colors --output-mode --debug --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__doc__cheatsheet)
            opts="-h --open --server-dir --colors --output-mode --debug --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__doc__faq)
            opts="-h --open --server-dir --colors --output-mode --debug --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__doc__job)
            opts="-h --open --server-dir --colors --output-mode --debug --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__doc__python__api)
            opts="-h --open --server-dir --colors --output-mode --debug --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__doc__resources)
            opts="-h --open --server-dir --colors --output-mode --debug --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__doc__taskarray)
            opts="-h --open --server-dir --colors --output-mode --debug --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__doc__worker)
            opts="-h --open --server-dir --colors --output-mode --debug --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__generate__completion)
            opts="-h --server-dir --colors --output-mode --debug --help bash elvish fish powershell zsh"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__job)
            opts="-h --server-dir --colors --output-mode --debug --help list summary info cancel forget cat submit submit-file wait progress task-ids open close"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__job__cancel)
            opts="-h --server-dir --colors --output-mode --debug --help <SELECTOR>"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__job__cat)
            opts="-h --tasks --task-status --print-task-header --server-dir --colors --output-mode --debug --help <JOB_SELECTOR> stdout stderr"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --tasks)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --task-status)
                    COMPREPLY=($(compgen -W "waiting running finished failed canceled opened" -- "${cur}"))
                    return 0
                    ;;
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__job__close)
            opts="-h --server-dir --colors --output-mode --debug --help <SELECTOR>"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__job__forget)
            opts="-h --filter --server-dir --colors --output-mode --debug --help <SELECTOR>"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --filter)
                    COMPREPLY=($(compgen -W "finished failed canceled" -- "${cur}"))
                    return 0
                    ;;
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__job__info)
            opts="-h --server-dir --colors --output-mode --debug --help <SELECTOR>"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__job__list)
            opts="-h --all --filter --server-dir --colors --output-mode --debug --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --filter)
                    COMPREPLY=($(compgen -W "waiting running finished failed canceled opened" -- "${cur}"))
                    return 0
                    ;;
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__job__open)
            opts="-h --name --max-fails --server-dir --colors --output-mode --debug --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --name)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --max-fails)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__job__progress)
            opts="-h --server-dir --colors --output-mode --debug --help <SELECTOR>"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__job__submit)
            opts="-h --name --max-fails --nodes --cpus --resource --time-request --pin --cwd --stdout --stderr --env --each-line --from-json --array --priority --time-limit --stream --task-dir --crash-limit --job --wait --progress --stdin --directives --server-dir --colors --output-mode --debug --help <COMMANDS>..."
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --name)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --max-fails)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --nodes)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --cpus)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --resource)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --time-request)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --pin)
                    COMPREPLY=($(compgen -W "taskset omp" -- "${cur}"))
                    return 0
                    ;;
                --cwd)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --stdout)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --stderr)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --env)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --each-line)
                    local oldifs
                    if [ -n "${IFS+x}" ]; then
                        oldifs="$IFS"
                    fi
                    IFS=$'\n'
                    COMPREPLY=($(compgen -f "${cur}"))
                    if [ -n "${oldifs+x}" ]; then
                        IFS="$oldifs"
                    fi
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o filenames
                    fi
                    return 0
                    ;;
                --from-json)
                    local oldifs
                    if [ -n "${IFS+x}" ]; then
                        oldifs="$IFS"
                    fi
                    IFS=$'\n'
                    COMPREPLY=($(compgen -f "${cur}"))
                    if [ -n "${oldifs+x}" ]; then
                        IFS="$oldifs"
                    fi
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o filenames
                    fi
                    return 0
                    ;;
                --array)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --priority)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --time-limit)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --stream)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --crash-limit)
                    COMPREPLY=($(compgen -W "never-restart unlimited <number>" -- "${cur}"))
                    return 0
                    ;;
                --job)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --directives)
                    COMPREPLY=($(compgen -W "auto file stdin off" -- "${cur}"))
                    return 0
                    ;;
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__job__submit__file)
            opts="-h --job --server-dir --colors --output-mode --debug --help <PATH>"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --job)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__job__summary)
            opts="-h --server-dir --colors --output-mode --debug --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__job__task__ids)
            opts="-h --filter --server-dir --colors --output-mode --debug --help <SELECTOR>"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --filter)
                    COMPREPLY=($(compgen -W "waiting running finished failed canceled opened" -- "${cur}"))
                    return 0
                    ;;
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__job__wait)
            opts="-h --without-close --server-dir --colors --output-mode --debug --help <SELECTOR>"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__journal)
            opts="-h --server-dir --colors --output-mode --debug --help export stream replay prune flush"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__journal__export)
            opts="-h --server-dir --colors --output-mode --debug --help <JOURNAL>"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__journal__flush)
            opts="-h --server-dir --colors --output-mode --debug --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__journal__prune)
            opts="-h --server-dir --colors --output-mode --debug --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__journal__replay)
            opts="-h --server-dir --colors --output-mode --debug --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__journal__stream)
            opts="-h --server-dir --colors --output-mode --debug --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__output__log)
            opts="-h --server-uid --server-dir --colors --output-mode --debug --help <PATH> summary jobs show cat export"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-uid)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__output__log__cat)
            opts="-h --task --allow-unfinished --server-dir --colors --output-mode --debug --help <JOB> stdout stderr"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --task)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__output__log__export)
            opts="-h --task --server-dir --colors --output-mode --debug --help <JOB>"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --task)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__output__log__jobs)
            opts="-h --server-dir --colors --output-mode --debug --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__output__log__show)
            opts="-h --job --channel --server-dir --colors --output-mode --debug --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --job)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --channel)
                    COMPREPLY=($(compgen -W "stdout stderr" -- "${cur}"))
                    return 0
                    ;;
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__output__log__summary)
            opts="-h --server-dir --colors --output-mode --debug --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__server)
            opts="-h --server-dir --colors --output-mode --debug --help start stop info generate-access debug-dump wait"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__server__debug__dump)
            opts="-h --server-dir --colors --output-mode --debug --help <PATH>"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__server__generate__access)
            opts="-h --client-file --worker-file --host --client-host --worker-host --client-port --worker-port --server-dir --colors --output-mode --debug --help <ACCESS_FILE>"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --client-file)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --worker-file)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --host)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --client-host)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --worker-host)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --client-port)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --worker-port)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__server__info)
            opts="-h --server-dir --colors --output-mode --debug --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__server__start)
            opts="-h --host --idle-timeout --client-port --worker-port --journal --journal-flush-period --access-file --disable-client-authentication-and-encryption --disable-worker-authentication-and-encryption --server-dir --colors --output-mode --debug --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --host)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --idle-timeout)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --client-port)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --worker-port)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --journal)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --journal-flush-period)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --access-file)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__server__stop)
            opts="-h --server-dir --colors --output-mode --debug --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__server__wait)
            opts="-h --timeout --server-dir --colors --output-mode --debug --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --timeout)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__submit)
            opts="-h --name --max-fails --nodes --cpus --resource --time-request --pin --cwd --stdout --stderr --env --each-line --from-json --array --priority --time-limit --stream --task-dir --crash-limit --job --wait --progress --stdin --directives --server-dir --colors --output-mode --debug --help <COMMANDS>..."
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --name)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --max-fails)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --nodes)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --cpus)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --resource)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --time-request)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --pin)
                    COMPREPLY=($(compgen -W "taskset omp" -- "${cur}"))
                    return 0
                    ;;
                --cwd)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --stdout)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --stderr)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --env)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --each-line)
                    local oldifs
                    if [ -n "${IFS+x}" ]; then
                        oldifs="$IFS"
                    fi
                    IFS=$'\n'
                    COMPREPLY=($(compgen -f "${cur}"))
                    if [ -n "${oldifs+x}" ]; then
                        IFS="$oldifs"
                    fi
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o filenames
                    fi
                    return 0
                    ;;
                --from-json)
                    local oldifs
                    if [ -n "${IFS+x}" ]; then
                        oldifs="$IFS"
                    fi
                    IFS=$'\n'
                    COMPREPLY=($(compgen -f "${cur}"))
                    if [ -n "${oldifs+x}" ]; then
                        IFS="$oldifs"
                    fi
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o filenames
                    fi
                    return 0
                    ;;
                --array)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --priority)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --time-limit)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --stream)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --crash-limit)
                    COMPREPLY=($(compgen -W "never-restart unlimited <number>" -- "${cur}"))
                    return 0
                    ;;
                --job)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --directives)
                    COMPREPLY=($(compgen -W "auto file stdin off" -- "${cur}"))
                    return 0
                    ;;
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__task)
            opts="-h --server-dir --colors --output-mode --debug --help list info explain"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__task__explain)
            opts="-h --server-dir --colors --output-mode --debug --help <JOB_SELECTOR> <TASK_ID>"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__task__info)
            opts="-v -h --server-dir --colors --output-mode --debug --help <JOB_SELECTOR> <TASK_SELECTOR>"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__task__list)
            opts="-v -h --tasks --task-status --server-dir --colors --output-mode --debug --help <JOB_SELECTOR>"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --tasks)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --task-status)
                    COMPREPLY=($(compgen -W "waiting running finished failed canceled opened" -- "${cur}"))
                    return 0
                    ;;
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__worker)
            opts="-h --server-dir --colors --output-mode --debug --help start stop list hwdetect info address wait deploy-ssh"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__worker__address)
            opts="-h --server-dir --colors --output-mode --debug --help <WORKER_ID>"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__worker__deploy__ssh)
            opts="-h --show-output --server-dir --colors --output-mode --debug --help <HOSTFILE> [WORKER_START_ARGS]..."
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__worker__hwdetect)
            opts="-h --no-hyper-threading --server-dir --colors --output-mode --debug --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__worker__info)
            opts="-h --server-dir --colors --output-mode --debug --help <WORKER_ID>"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__worker__list)
            opts="-h --all --filter --server-dir --colors --output-mode --debug --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --filter)
                    COMPREPLY=($(compgen -W "running offline" -- "${cur}"))
                    return 0
                    ;;
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__worker__start)
            opts="-h --cpus --resource --group --coupling --detect-resources --no-hyper-threading --idle-timeout --overview-interval --heartbeat --time-limit --manager --hostname --on-server-lost --work-dir --max-parallel-downloads --max-download-tries --wait-between-download-tries --server-dir --colors --output-mode --debug --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --cpus)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --resource)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --group)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --coupling)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --detect-resources)
                    COMPREPLY=($(compgen -W "all none cpus mem gpus/nvidia gpus/amd" -- "${cur}"))
                    return 0
                    ;;
                --idle-timeout)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --overview-interval)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --heartbeat)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --time-limit)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --manager)
                    COMPREPLY=($(compgen -W "detect none pbs slurm" -- "${cur}"))
                    return 0
                    ;;
                --hostname)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --on-server-lost)
                    COMPREPLY=($(compgen -W "stop finish-running" -- "${cur}"))
                    return 0
                    ;;
                --work-dir)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --max-parallel-downloads)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --max-download-tries)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --wait-between-download-tries)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__worker__stop)
            opts="-h --server-dir --colors --output-mode --debug --help <SELECTOR_ARG>"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        hq__worker__wait)
            opts="-h --server-dir --colors --output-mode --debug --help <WORKER_COUNT>"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --server-dir)
                    COMPREPLY=()
                    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
                        compopt -o plusdirs
                    fi
                    return 0
                    ;;
                --colors)
                    COMPREPLY=($(compgen -W "auto always never" -- "${cur}"))
                    return 0
                    ;;
                --output-mode)
                    COMPREPLY=($(compgen -W "cli json quiet" -- "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
    esac
}

if [[ "${BASH_VERSINFO[0]}" -eq 4 && "${BASH_VERSINFO[1]}" -ge 4 || "${BASH_VERSINFO[0]}" -gt 4 ]]; then
    complete -F _hq -o nosort -o bashdefault -o default hq
else
    complete -F _hq -o bashdefault -o default hq
fi
