/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.save;

import tim.prune.data.Track;
import tim.prune.data.TrackExtents;

public abstract class ImageSizeLimits {
    private static final int MIN_PIXELS_ALLOWED = 100;
    private static final int MAX_PIXELS_ALLOWED = 8000;

    public static boolean isZoomLevelOk(Track track, int n) {
        int n2 = ImageSizeLimits.getPixelCount(track, n);
        return n2 > 100 && n2 < 8000;
    }

    private static int getPixelCount(Track track, int n) {
        TrackExtents trackExtents = new TrackExtents(track);
        trackExtents.applySquareBorder();
        int n2 = 1 << n;
        return (int)(trackExtents.getXRange().getRange() * (double)n2 * 256.0);
    }
}

