/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.breakpoint;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import ghidra.trace.model.breakpoint.TraceBreakpointLocation;
import ghidra.trace.model.breakpoint.TraceBreakpointSpec;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.exception.DuplicateNameException;
import java.util.Collection;

public interface TraceBreakpointManager {
    public TraceBreakpointLocation addBreakpoint(String var1, Lifespan var2, AddressRange var3, Collection<TraceThread> var4, Collection<TraceBreakpointKind> var5, boolean var6, String var7) throws DuplicateNameException;

    default public TraceBreakpointLocation addBreakpoint(String path, Lifespan lifespan, Address address, Collection<TraceThread> threads, Collection<TraceBreakpointKind> kinds, boolean enabled, String comment) throws DuplicateNameException {
        return this.addBreakpoint(path, lifespan, (AddressRange)new AddressRangeImpl(address, address), threads, kinds, enabled, comment);
    }

    default public TraceBreakpointLocation placeBreakpoint(String path, long snap, AddressRange range, Collection<TraceThread> threads, Collection<TraceBreakpointKind> kinds, boolean enabled, String comment) throws DuplicateNameException {
        return this.addBreakpoint(path, Lifespan.nowOn(snap), range, threads, kinds, enabled, comment);
    }

    default public TraceBreakpointLocation placeBreakpoint(String path, long snap, Address address, Collection<TraceThread> threads, Collection<TraceBreakpointKind> kinds, boolean enabled, String comment) throws DuplicateNameException {
        return this.addBreakpoint(path, Lifespan.nowOn(snap), (AddressRange)new AddressRangeImpl(address, address), threads, kinds, enabled, comment);
    }

    public Collection<? extends TraceBreakpointSpec> getAllBreakpointSpecifications();

    public Collection<? extends TraceBreakpointLocation> getAllBreakpointLocations();

    public Collection<? extends TraceBreakpointSpec> getBreakpointSpecificationsByPath(String var1);

    public Collection<? extends TraceBreakpointLocation> getBreakpointLocationsByPath(String var1);

    public TraceBreakpointLocation getPlacedBreakpointByPath(long var1, String var3);

    public Collection<? extends TraceBreakpointLocation> getBreakpointsAt(long var1, Address var3);

    public Collection<? extends TraceBreakpointLocation> getBreakpointsIntersecting(Lifespan var1, AddressRange var2);
}

