/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

public enum StringLayoutEnum {
    FIXED_LEN("fixed length"),
    CHAR_SEQ("char sequence"),
    NULL_TERMINATED_UNBOUNDED("null-terminated & unbounded"),
    NULL_TERMINATED_BOUNDED("null-terminated & bounded"),
    PASCAL_255("pascal255"),
    PASCAL_64k("pascal64k");

    private final String s;

    private StringLayoutEnum(String s) {
        this.s = s;
    }

    public String toString() {
        return this.s;
    }

    public boolean isPascal() {
        return this == PASCAL_255 || this == PASCAL_64k;
    }

    public boolean isNullTerminated() {
        return this == NULL_TERMINATED_UNBOUNDED || this == NULL_TERMINATED_BOUNDED;
    }

    public boolean shouldTrimTrailingNulls() {
        return this == NULL_TERMINATED_UNBOUNDED || this == NULL_TERMINATED_BOUNDED || this == FIXED_LEN;
    }

    public boolean isFixedLen() {
        return this == FIXED_LEN || this == CHAR_SEQ;
    }
}

