/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database;

import ghidra.program.database.OverlayRegionSupplier;
import ghidra.program.database.ProgramAddressFactory;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.OverlayAddressSpace;
import ghidra.util.exception.DuplicateNameException;

public class ProgramOverlayAddressSpace
extends OverlayAddressSpace {
    private final long key;
    private final OverlayRegionSupplier overlayRegionSupplier;
    private String overlayName;
    private AddressSetView overlaySet;

    public ProgramOverlayAddressSpace(long key, String overlayName, AddressSpace baseSpace, int unique, OverlayRegionSupplier overlayRegionSupplier, ProgramAddressFactory factory) throws DuplicateNameException {
        super(baseSpace, unique, factory.generateOrderedKey(overlayName));
        this.key = key;
        this.overlayName = overlayName;
        this.overlayRegionSupplier = overlayRegionSupplier;
        factory.addOverlaySpace(this);
    }

    protected synchronized void invalidate() {
        this.overlaySet = null;
    }

    private void validate() {
        if (this.overlaySet == null) {
            AddressSetView addressSetView = this.overlaySet = this.overlayRegionSupplier != null ? this.overlayRegionSupplier.getOverlayAddressSet(this) : new AddressSet();
            if (this.overlaySet == null) {
                this.overlaySet = new AddressSet();
            }
        }
    }

    public long getKey() {
        return this.key;
    }

    @Override
    public String getName() {
        return this.overlayName;
    }

    public void setName(String name) {
        this.overlayName = name;
    }

    @Override
    public synchronized boolean contains(long offset) {
        try {
            Address addr = this.getAddressInThisSpaceOnly(this.makeValidOffset(offset));
            return this.getOverlayAddressSet().contains(addr);
        }
        catch (AddressOutOfBoundsException e) {
            return false;
        }
    }

    @Override
    public synchronized AddressSetView getOverlayAddressSet() {
        this.validate();
        return this.overlaySet;
    }
}

