/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.utils;

import ghidra.pcodeCPort.context.SleighError;
import ghidra.pcodeCPort.utils.MutableInt;
import ghidra.sleigh.grammar.Location;

public class Utils {
    public static final String endl = System.getProperty("line.separator");
    private static long[] uintbmasks = new long[]{0L, 255L, 65535L, 0xFFFFFFL, 0xFFFFFFFFL, 0xFFFFFFFFFFL, 0xFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL, -1L};

    public static long calc_mask(int size) {
        return uintbmasks[Integer.compareUnsigned(size, 8) < 0 ? size : 8];
    }

    public static long pcode_right(long val, int sa) {
        if (sa >= 64) {
            return 0L;
        }
        return val >>> sa;
    }

    public static long pcode_left(long val, int sa) {
        if (sa >= 64) {
            return 0L;
        }
        return val << sa;
    }

    public static boolean signbit_negative(long val, int size) {
        long mask = 128L;
        return (val & (mask <<= 8 * (size - 1))) != 0L;
    }

    public static long uintb_negate(long in, int size) {
        return (in ^ 0xFFFFFFFFFFFFFFFFL) & Utils.calc_mask(size);
    }

    public static long sign_extend(long in, int sizein, int sizeout) {
        int signbit = sizein * 8 - 1;
        in &= Utils.calc_mask(sizein);
        if (sizein >= sizeout) {
            return in;
        }
        if (in >>> signbit != 0L) {
            long mask = Utils.calc_mask(sizeout);
            long tmp = mask << signbit;
            tmp = tmp << 1 & mask;
            in |= tmp;
        }
        return in;
    }

    public static long zzz_sign_extend(long val, int bit) {
        long mask = 0L;
        mask = (mask ^ 0xFFFFFFFFFFFFFFFFL) << bit;
        val = (val >>> bit & 1L) != 0L ? (val |= mask) : (val &= mask ^ 0xFFFFFFFFFFFFFFFFL);
        return val;
    }

    public static long zzz_zero_extend(long val, int bit) {
        long mask = 0L;
        mask = (mask ^ 0xFFFFFFFFFFFFFFFFL) << bit;
        return val &= (mask <<= 1) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static long byte_swap(long val, int size) {
        long res = 0L;
        while (size > 0) {
            res <<= 8;
            res |= val & 0xFFL;
            val >>>= 8;
            --size;
        }
        return res;
    }

    long byte_swap(int val) {
        long res = 0L;
        for (int i = 0; i < 4; ++i) {
            res <<= 8;
            res |= (long)(val & 0xFF);
            val >>>= 8;
        }
        return res;
    }

    public static boolean isprint(int c) {
        return c >= 32 && c <= 126;
    }

    public static boolean isascii(int c) {
        return c >= 0 && c <= 127;
    }

    public static int leastsigbit_set(long val) {
        if (val == 0L) {
            return -1;
        }
        int res = 0;
        int sz = 32;
        long mask = -1L;
        do {
            if (((mask >>>= sz) & val) != 0L) continue;
            res += sz;
            val >>>= sz;
        } while ((sz >>= 1) != 0);
        return res;
    }

    public static int mostsigbit_set(long val) {
        if (val == 0L) {
            return -1;
        }
        int res = 63;
        int sz = 32;
        long mask = -1L;
        do {
            if (((mask <<= sz) & val) != 0L) continue;
            res -= sz;
            val <<= sz;
        } while ((sz >>= 1) != 0);
        return res;
    }

    public static long coveringmask(long val) {
        long res = val;
        for (int sz = 1; sz < 64; sz <<= 1) {
            res |= res >>> sz;
        }
        return res;
    }

    public static String paddedHexString(long value, int padLength) {
        String decodedString = Long.toString(value, 16);
        if (decodedString.length() >= padLength) {
            return decodedString;
        }
        StringBuffer buffer = new StringBuffer();
        int missingLength = padLength - decodedString.length();
        for (int i = 0; i < missingLength; ++i) {
            buffer.append("0");
        }
        buffer.append(decodedString);
        return buffer.toString();
    }

    public static int unsignedCompare(long v1, long v2) {
        if (v1 == v2) {
            return 0;
        }
        if (v1 >= 0L && v2 >= 0L) {
            return v1 < v2 ? -1 : 1;
        }
        if (v1 < 0L && v2 < 0L) {
            return v1 < v2 ? -1 : 1;
        }
        if (v1 < 0L) {
            return 1;
        }
        return -1;
    }

    public static int unsignedCompare(int v1, int v2) {
        if (v1 == v2) {
            return 0;
        }
        if (v1 >= 0 && v2 >= 0) {
            return v1 < v2 ? -1 : 1;
        }
        if (v1 < 0 && v2 < 0) {
            return v1 < v2 ? -1 : 1;
        }
        if (v1 < 0) {
            return 1;
        }
        return -1;
    }

    public static void calc_maskword(Location location, int sbit, int ebit, MutableInt num, MutableInt shift, MutableInt mask) {
        num.set(Utils.unsignedDivide(sbit, 32));
        if (num.get() != Utils.unsignedDivide(ebit, 32)) {
            throw new SleighError("Context field not contained within one machine int", location);
        }
        shift.set(32 - (ebit -= (int)(Utils.unsignedInt(num.get()) * 8L * 4L)) - 1);
        int m = -1 >>> (sbit -= (int)(Utils.unsignedInt(num.get()) * 8L * 4L)) + shift.get();
        mask.set(m <<= shift.get());
    }

    public static int bytesToInt(byte[] bytes, boolean bigEndian) {
        int result = 0;
        if (bigEndian) {
            for (int i = 0; i < 4; ++i) {
                result <<= 8;
                result |= bytes[i] & 0xFF;
            }
        } else {
            for (int i = 3; i >= 0; --i) {
                result <<= 8;
                result |= bytes[i] & 0xFF;
            }
        }
        return result;
    }

    public static long shiftLeft(long a, long b) {
        if ((b &= 0xFFL) >= 64L) {
            return 0L;
        }
        return a << (int)b;
    }

    public static long ashiftRight(long a, long b) {
        if ((b &= 0xFFL) >= 64L) {
            return -1L;
        }
        return a >> (int)b;
    }

    public static long lshiftRight(long a, long b) {
        if ((b &= 0xFFL) >= 64L) {
            return 0L;
        }
        return a >>> (int)b;
    }

    public static long unsignedInt(int a) {
        long result = a;
        if (result < 0L) {
            result += 0x100000000L;
        }
        return result;
    }

    public static int unsignedDivide(int a, int b) {
        long la = Utils.unsignedInt(a);
        long lb = Utils.unsignedInt(b);
        long result = la / lb;
        return (int)result;
    }

    public static int unsignedModulo(int a, int b) {
        long la = Utils.unsignedInt(a);
        long lb = Utils.unsignedInt(b);
        long result = la % lb;
        return (int)result;
    }

    public static void main(String[] args) {
        System.out.println(Utils.unsignedDivide(-8, 32));
        System.out.println(Utils.unsignedModulo(-8, 32));
    }

    public static String toUnsignedIntHex(int n) {
        return Long.toHexString(Utils.unsignedInt(n));
    }

    public static long bytesToLong(byte[] byteBuf) {
        long value = 0L;
        for (int i = 0; i < 8; ++i) {
            value = value << 8 | (long)byteBuf[i];
        }
        return value;
    }
}

