/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symboltree.actions;

import docking.action.MenuData;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.symboltree.SymbolTreeActionContext;
import ghidra.app.plugin.core.symboltree.SymbolTreePlugin;
import ghidra.app.plugin.core.symboltree.actions.SymbolTreeContextAction;
import ghidra.app.plugin.core.symboltree.nodes.NamespaceCategoryNode;
import ghidra.app.plugin.core.symboltree.nodes.SymbolNode;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.awt.Component;
import javax.swing.tree.TreePath;

public class CreateNamespaceAction
extends SymbolTreeContextAction {
    public CreateNamespaceAction(SymbolTreePlugin plugin, String group, String subGroup) {
        super("Create Namespace", plugin.getName());
        MenuData menuData = new MenuData(new String[]{"Create Namespace"}, group);
        menuData.setMenuSubGroup(subGroup);
        this.setPopupMenuData(menuData);
        this.setEnabled(false);
    }

    @Override
    public boolean isEnabledForContext(SymbolTreeActionContext context) {
        TreePath[] selectionPaths = context.getSelectedSymbolTreePaths();
        if (selectionPaths.length != 1) {
            return false;
        }
        Object object = selectionPaths[0].getLastPathComponent();
        if (object instanceof SymbolNode) {
            SymbolNode symbolNode = (SymbolNode)((Object)object);
            Symbol symbol = symbolNode.getSymbol();
            SymbolType symbolType = symbol.getSymbolType();
            if (symbolType == SymbolType.FUNCTION) {
                return !symbol.isExternal();
            }
            return symbolType == SymbolType.NAMESPACE || symbolType == SymbolType.CLASS || symbolType == SymbolType.LIBRARY;
        }
        return object instanceof NamespaceCategoryNode;
    }

    @Override
    public void actionPerformed(SymbolTreeActionContext context) {
        GTree tree = (GTree)context.getContextObject();
        if (tree.isFiltered()) {
            Msg.showWarn(((Object)((Object)this)).getClass(), (Component)tree, (String)"Create Namespace Not Allowed", (Object)"Cannot create namespace while the tree is filtered!");
            return;
        }
        this.createNamespace(context);
    }

    private void createNamespace(SymbolTreeActionContext context) {
        Symbol symbol;
        TreePath[] selectionPaths = context.getSelectedSymbolTreePaths();
        Program program = context.getProgram();
        Namespace parent = program.getGlobalNamespace();
        GTreeNode node = (GTreeNode)selectionPaths[0].getLastPathComponent();
        if (node instanceof SymbolNode && (parent = (Namespace)(symbol = ((SymbolNode)node).getSymbol()).getObject()) == null) {
            return;
        }
        String newNamespaceName = this.createNamespace(program, parent);
        if (newNamespaceName == null) {
            return;
        }
        program.flushEvents();
        context.getSymbolTree().startEditing(node, newNamespaceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - bad return control flow
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String createNamespace(Program program, Namespace parent) {
        Object namespaceName = "NewNamespace";
        int transactionID = program.startTransaction("Create Namespace");
        try {
            SymbolTable symbolTable = program.getSymbolTable();
            int oneUp = 0;
            namespaceName = "NewNamespace";
            Namespace namespace = null;
            while (namespace == null) {
                try {
                    namespace = symbolTable.createNameSpace(parent, (String)namespaceName, SourceType.USER_DEFINED);
                }
                catch (DuplicateNameException e) {
                    namespaceName = "NewNamespace(" + ++oneUp + ")";
                }
                catch (InvalidInputException e) {
                    Msg.debug((Object)((Object)this), (Object)("Failed to create namespace: " + e.getMessage()));
                    String string = null;
                    program.endTransaction(transactionID, true);
                    return string;
                    return namespaceName;
                }
            }
        }
        finally {
            program.endTransaction(transactionID, true);
        }
    }
}

