/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.squashfs;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.squashfs.SquashDirectoryTableEntry;
import ghidra.file.formats.squashfs.SquashSuperBlock;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SquashDirectoryTableHeader {
    private final long numberOfEntries;
    private final long directoryInodeOffset;
    private final long baseInode;
    private final List<SquashDirectoryTableEntry> entries;

    public SquashDirectoryTableHeader(BinaryReader reader, SquashSuperBlock superBlock, TaskMonitor monitor) throws IOException, CancelledException {
        this.numberOfEntries = reader.readNextUnsignedInt();
        this.directoryInodeOffset = reader.readNextUnsignedInt();
        this.baseInode = reader.readNextUnsignedInt();
        this.entries = new ArrayList<SquashDirectoryTableEntry>();
        int i = 0;
        while ((long)i < this.numberOfEntries + 1L) {
            monitor.checkCancelled();
            this.entries.add(new SquashDirectoryTableEntry(reader, superBlock, this.baseInode));
            ++i;
        }
    }

    public List<SquashDirectoryTableEntry> getEntries() {
        return this.entries;
    }

    public long getBaseInodeNumber() {
        return this.baseInode;
    }

    public long getDirectoryInodeOffset() {
        return this.directoryInodeOffset;
    }
}

