/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.fbpk;

import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.flatapi.FlatProgramAPI;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.RefType;
import ghidra.util.task.TaskMonitor;

public abstract class FBPK_Partition
implements StructConverter {
    protected int headerSize;
    protected int type;
    protected String name;
    protected int partitionIndex;

    public final int getHeaderSize() {
        return this.headerSize;
    }

    public final int getType() {
        return this.type;
    }

    public final String getName() {
        return this.name;
    }

    public abstract long getDataStartOffset();

    public abstract int getDataSize();

    public abstract boolean isFile();

    public abstract int getOffsetToNextPartitionTable();

    public final int getPartitionIndex() {
        return this.partitionIndex;
    }

    public void markup(Program program, Address address, TaskMonitor monitor, MessageLog log) throws Exception {
        FlatProgramAPI api = new FlatProgramAPI(program);
        DataType partitionDataType = this.toDataType();
        Data partitionData = program.getListing().createData(address, partitionDataType);
        if (partitionData == null) {
            log.appendMsg("Unable to apply partition data, stopping - " + String.valueOf(address));
            return;
        }
        program.getListing().setComment(address, CommentType.PLATE, this.getName() + " - " + this.getPartitionIndex());
        api.createFragment(this.getName(), address, (long)partitionDataType.getLength());
        Address dataStart = api.toAddr(this.getDataStartOffset());
        api.createFragment(this.getName(), dataStart, (long)this.getDataSize());
        Data offsetData = partitionData.getComponent(2);
        api.createMemoryReference(offsetData, dataStart, RefType.DATA);
        address = address.add((long)partitionDataType.getLength());
    }
}

