/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.fid.hash;

import ghidra.program.model.lang.Processor;
import ghidra.util.search.InstructionSkipper;

public class X86InstructionSkipper
implements InstructionSkipper {
    private static final byte[][] PATTERNS = new byte[][]{{-112}, {-117, -64}, {-117, -55}, {-117, -46}, {-117, -37}, {-117, -28}, {-117, -19}, {-117, -10}, {-117, -1}, {102, -112}, {15, 31, 0}, {15, 31, 64, 0}, {15, 31, 68, 0, 0}, {102, 15, 31, 68, 0, 0}, {15, 31, -128, 0, 0, 0, 0}, {15, 31, -124, 0, 0, 0, 0, 0}, {102, 15, 31, -124, 0, 0, 0, 0, 0}};

    public Processor getApplicableProcessor() {
        return Processor.findOrPossiblyCreateProcessor((String)"x86");
    }

    public boolean shouldSkip(byte[] buffer, int size) {
        for (int ii = 0; ii < PATTERNS.length; ++ii) {
            int i;
            byte[] pat = PATTERNS[ii];
            if (pat.length != size) continue;
            for (i = 0; i < size && pat[i] == buffer[i]; ++i) {
            }
            if (i != size) continue;
            return true;
        }
        return false;
    }
}

