/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import java.io.IOException;
import java.io.InputStream;

public class BoundedInputStream
extends InputStream {
    private final InputStream wrappedInputStream;
    private final long limit;
    private long position;

    public BoundedInputStream(InputStream wrappedInputStream, long size) {
        this.wrappedInputStream = wrappedInputStream;
        this.limit = size;
    }

    @Override
    public int read() throws IOException {
        if (this.position >= this.limit) {
            return -1;
        }
        ++this.position;
        return this.wrappedInputStream.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.position >= this.limit) {
            return -1;
        }
        int bytesLeft = (int)Math.min(this.limit - this.position, Integer.MAX_VALUE);
        int bytesToRead = Math.min(len, bytesLeft);
        int bytesRead = this.wrappedInputStream.read(b, off, bytesToRead);
        if (bytesRead >= 0) {
            this.position += (long)bytesRead;
        }
        return bytesRead;
    }

    @Override
    public void close() throws IOException {
        this.wrappedInputStream.close();
    }

    @Override
    public long skip(long n) throws IOException {
        long bytesLeft = this.limit - this.position;
        long toSkip = Math.min(bytesLeft, n);
        long skipped = this.wrappedInputStream.skip(toSkip);
        this.position += skipped;
        return skipped;
    }
}

