/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DirectionalityHelper {
    public static Directionality getDirectionality(Element element) {
        while (true) {
            Node node;
            String dirAttr;
            if ((dirAttr = element.getAttribute("dir")).length() != 0) {
                if ("rtl".equalsIgnoreCase(dirAttr)) {
                    return Directionality.RTL;
                }
                if ("ltr".equalsIgnoreCase(dirAttr)) break;
                if ("auto".equalsIgnoreCase(dirAttr)) {
                    return DirectionalityHelper.autoDirection(element);
                }
                if ("bdi".equals(element.getLocalName())) {
                    return DirectionalityHelper.bdiDirection(element);
                }
                if ("input".equals(element.getLocalName()) && "telephone".equalsIgnoreCase(element.getAttribute("type"))) {
                    break;
                }
            } else if ("bdi".equals(element.getLocalName())) {
                return DirectionalityHelper.bdiDirection(element);
            }
            if ((node = element.getParentNode()) == null || node.getNodeType() != 1) break;
            element = (Element)node;
        }
        return Directionality.LTR;
    }

    private static Directionality autoDirection(Element element) {
        String name = element.getLocalName();
        if ("textarea".equals(name)) {
            String value = element.getTextContent().trim();
            return DirectionalityHelper.valueDirection(element, value);
        }
        if ("input".equals(name)) {
            String value = element.getAttribute("value");
            return DirectionalityHelper.valueDirection(element, value);
        }
        byte ret = DirectionalityHelper.descendantTextDirection(element);
        switch (ret) {
            case 0: {
                return Directionality.LTR;
            }
            case 1: {
                return Directionality.RTL;
            }
        }
        return DirectionalityHelper.parentDirection(element);
    }

    private static Directionality bdiDirection(Element element) {
        byte ret = DirectionalityHelper.descendantTextDirection(element);
        switch (ret) {
            case 0: {
                return Directionality.LTR;
            }
            case 1: {
                return Directionality.RTL;
            }
        }
        return DirectionalityHelper.parentDirection(element);
    }

    private static byte descendantTextDirection(Element element) {
        block22: {
            if (!element.hasChildNodes()) break block22;
            NodeList list = element.getChildNodes();
            if (list instanceof Iterable) {
                for (Node node : (Iterable)((Object)list)) {
                    switch (node.getNodeType()) {
                        case 1: {
                            byte ret;
                            element = (Element)node;
                            String name = element.getLocalName();
                            if ("bdi".equals(name) || "script".equals(name) || "style".equals(name) || "textarea".equals(name) || DirectionalityHelper.hasLtrOrRtlDir(element) || (ret = DirectionalityHelper.descendantTextDirection(element)) == -1) break;
                            return ret;
                        }
                        case 3: 
                        case 4: {
                            String data = node.getNodeValue();
                            int len = data.length();
                            int i = 0;
                            while (i < len) {
                                int cp = data.codePointAt(i);
                                byte cpDir = Character.getDirectionality(cp);
                                switch (cpDir) {
                                    case 0: {
                                        return 0;
                                    }
                                    case 1: 
                                    case 2: {
                                        return 1;
                                    }
                                }
                                i = data.offsetByCodePoints(i, 1);
                            }
                            break;
                        }
                    }
                }
            } else {
                block18: for (int idx = 0; idx < list.getLength(); ++idx) {
                    Node node = list.item(idx);
                    switch (node.getNodeType()) {
                        case 1: {
                            byte ret;
                            element = (Element)node;
                            String name = element.getLocalName();
                            if ("bdi".equals(name) || "script".equals(name) || "style".equals(name) || "textarea".equals(name) || DirectionalityHelper.hasLtrOrRtlDir(element) || (ret = DirectionalityHelper.descendantTextDirection(element)) == -1) continue block18;
                            return ret;
                        }
                        case 3: 
                        case 4: {
                            String data = node.getNodeValue();
                            int len = data.length();
                            int i = 0;
                            while (i < len) {
                                int cp = data.codePointAt(i);
                                byte cpDir = Character.getDirectionality(cp);
                                switch (cpDir) {
                                    case 0: {
                                        return 0;
                                    }
                                    case 1: 
                                    case 2: {
                                        return 1;
                                    }
                                }
                                i = data.offsetByCodePoints(i, 1);
                            }
                            continue block18;
                        }
                    }
                }
            }
        }
        return -1;
    }

    private static boolean hasLtrOrRtlDir(Element element) {
        String dir = element.getAttribute("dir");
        return "ltr".equalsIgnoreCase(dir) || "rtl".equalsIgnoreCase(dir);
    }

    private static Directionality parentDirection(Element element) {
        Node node = element.getParentNode();
        if (node != null && node.getNodeType() == 1) {
            return DirectionalityHelper.getDirectionality((Element)node);
        }
        return Directionality.LTR;
    }

    private static Directionality valueDirection(Element element, String value) {
        int len = value.length();
        int i = 0;
        while (i < len) {
            int cp = value.codePointAt(i);
            byte cpDir = Character.getDirectionality(cp);
            switch (cpDir) {
                case 0: {
                    return Directionality.LTR;
                }
                case 1: 
                case 2: {
                    return Directionality.RTL;
                }
            }
            i = value.offsetByCodePoints(i, 1);
        }
        return DirectionalityHelper.parentDirection(element);
    }

    public static enum Directionality {
        LTR,
        RTL;

    }
}

