"""
Fast and minimalist 3D viewer
"""

# This file is auto-generated by CMake, do not edit!
# Refer to python/__init__.py.in source file

import os
import re
import sys
import warnings
from pathlib import Path
from typing import Any, Iterable, Mapping, Union

F3D_ABSOLUTE_DLLS: list[str] = [
    # 
]
F3D_RELATIVE_DLLS: list[str] = [
    # 
]


def _add_dll_directories():
    if sys.version_info >= (3, 8) and sys.platform == "win32":
        for abs_path in F3D_ABSOLUTE_DLLS:
            os.add_dll_directory(abs_path)
        root = Path(__file__).parent
        for rel_path in F3D_RELATIVE_DLLS:
            os.add_dll_directory((root / rel_path).resolve())


_add_dll_directories()

from .pyf3d import *

# Automatically populate __all__ with symbols imported from pyf3d
__all__ = [name for name in dir(pyf3d) if not name.startswith("_")]

# Automatically load plugins for the user
Engine.autoload_plugins()

__version__ = "3.4.1"


################################################################################
# monkey patch `options.update`


def _f3d_options_update(
    self, arg: Union[Mapping[str, Any], Iterable[tuple[str, Any]]]
) -> None:
    try:
        for k, v in arg.items():
            self[k] = v
        return
    except AttributeError:  # `arg` doesn't have `.items()`
        pass

    try:
        for k, v in arg:
            self[k] = v
        return
    except TypeError:  # `arg` isn't iterable
        pass
    except ValueError:  # `arg` isn't iterable of pairs
        pass

    raise ValueError(f"cannot update {self} from {arg}")


Options.update = _f3d_options_update


################################################################################
# add deprecated warnings


def _deprecated_decorator(f, reason):
    def g(*args, **kwargs):
        warnings.warn(reason, DeprecationWarning, 2)
        return f(*args, **kwargs)

    return g


def _add_deprecation_warnings():
    for f3d_class in (
        Camera,
        Scene,
        Options,
        Interactor,
        Engine,
        Window,
        Image,
    ):
        for name, member in f3d_class.__dict__.items():
            if callable(member) and member.__doc__:
                m = re.search(r"DEPRECATED(:\s*.+)?", member.__doc__)
                if m:
                    reason = m.group(1) or ""
                    msg = f"{f3d_class.__qualname__}.{name} is deprecated{reason}"
                    setattr(f3d_class, name, _deprecated_decorator(member, msg))


_add_deprecation_warnings()
