/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.configurator;

import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.update.internal.configurator.IConfigurationConstants;
import org.eclipse.update.internal.configurator.Utils;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ConfigurationActivator
implements BundleActivator,
IConfigurationConstants {
    public static String PI_CONFIGURATOR = "org.eclipse.update.configurator";
    public static final String LAST_CONFIG_STAMP = "last.config.stamp";
    public static final String NAME_SPACE = "org.eclipse.update";
    public static final String UPDATE_PREFIX = "update@";
    public static String OPTION_DEBUG = PI_CONFIGURATOR + "/debug";
    public static boolean DEBUG = false;
    private static BundleContext context;

    public void start(BundleContext ctx) throws Exception {
        context = ctx;
        this.loadOptions();
        this.acquireFrameworkLogService();
        Utils.debug("Starting update configurator...");
    }

    public void stop(BundleContext ctx) throws Exception {
        Utils.shutdown();
    }

    private void loadOptions() {
        DebugOptions service = null;
        ServiceReference reference = context.getServiceReference(DebugOptions.class);
        if (reference != null) {
            service = (DebugOptions)context.getService(reference);
        }
        if (service == null) {
            return;
        }
        try {
            DEBUG = service.getBooleanOption(OPTION_DEBUG, false);
        }
        finally {
            context.ungetService(reference);
        }
    }

    public static BundleContext getBundleContext() {
        return context;
    }

    private void acquireFrameworkLogService() {
        ServiceReference logServiceReference = context.getServiceReference(FrameworkLog.class);
        if (logServiceReference == null) {
            return;
        }
        Utils.log = (FrameworkLog)context.getService(logServiceReference);
    }
}

