/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceConfigurationStorage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.registry.DataSourceConfigurationManager;
import org.jkiss.dbeaver.registry.DataSourceFileStorage;
import org.jkiss.dbeaver.utils.ContentUtils;

public class DataSourceConfigurationManagerNIO
implements DataSourceConfigurationManager {
    private static final Log log = Log.getLog(DataSourceConfigurationManagerNIO.class);
    @NotNull
    private final DBPProject project;

    public DataSourceConfigurationManagerNIO(@NotNull DBPProject project) {
        this.project = project;
    }

    private Path getConfigurationPath(boolean create) {
        return this.project.getMetadataFolder(create);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    @Override
    public List<DBPDataSourceConfigurationStorage> getConfigurationStorages() {
        String fileName;
        List<Path> mdFiles;
        Stream<Path> list;
        Object var5_9;
        ArrayList<DBPDataSourceConfigurationStorage> storages = new ArrayList<DBPDataSourceConfigurationStorage>();
        Path metadataFolder = this.project.getMetadataFolder(false);
        boolean modernFormat = false;
        if (Files.exists(metadataFolder, new LinkOption[0])) {
            try {
                Throwable throwable = null;
                var5_9 = null;
                try {
                    list = Files.list(metadataFolder);
                    try {
                        mdFiles = list.filter(path -> !Files.isDirectory(path, new LinkOption[0]) && Files.exists(path, new LinkOption[0])).toList();
                        for (Path res : mdFiles) {
                            fileName = res.getFileName().toString();
                            if (!fileName.startsWith("data-sources") || !fileName.endsWith(".json")) continue;
                            storages.add(new DataSourceFileStorage(res, false, fileName.equals("data-sources.json")));
                            modernFormat = true;
                        }
                    }
                    finally {
                        if (list != null) {
                            list.close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                log.error((Object)"Error during project files read", (Throwable)e);
            }
        }
        if (!modernFormat && Files.exists(this.project.getAbsolutePath(), new LinkOption[0])) {
            try {
                Throwable e = null;
                var5_9 = null;
                try {
                    list = Files.list(this.project.getAbsolutePath());
                    try {
                        mdFiles = list.filter(path -> !Files.isDirectory(path, new LinkOption[0]) && Files.exists(path, new LinkOption[0])).toList();
                        for (Path res : mdFiles) {
                            fileName = res.getFileName().toString();
                            if (!fileName.startsWith(".dbeaver-data-sources") || !fileName.endsWith(".xml")) continue;
                            storages.add(new DataSourceFileStorage(res, true, fileName.equals(".dbeaver-data-sources.xml")));
                        }
                    }
                    finally {
                        if (list != null) {
                            list.close();
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                    } else if (e != throwable) {
                        e.addSuppressed(throwable);
                    }
                    throw e;
                }
            }
            catch (IOException e) {
                log.error((Object)"Error during legacy project files read", (Throwable)e);
            }
        }
        if (storages.isEmpty()) {
            storages.add(new DataSourceFileStorage(metadataFolder.resolve("data-sources.json"), false, true));
        }
        return storages;
    }

    @Override
    public InputStream readConfiguration(@NotNull String name, Collection<String> dataSourceIds) throws IOException {
        Path path = this.getConfigurationPath(false).resolve(name);
        if (Files.notExists(path, new LinkOption[0])) {
            path = this.project.getAbsolutePath().resolve(name);
        }
        if (Files.notExists(path, new LinkOption[0])) {
            return null;
        }
        return Files.newInputStream(path, new OpenOption[0]);
    }

    @Override
    public void writeConfiguration(@NotNull String name, @Nullable byte[] data) throws IOException {
        Path configFile = this.getConfigurationPath(true).resolve(name);
        ContentUtils.makeFileBackup((Path)configFile);
        if (data == null || data.length == 0) {
            if (Files.exists(configFile, new LinkOption[0])) {
                try {
                    Files.delete(configFile);
                }
                catch (IOException e) {
                    log.debug((Object)("Error deleting file " + String.valueOf(configFile.toAbsolutePath())), (Throwable)e);
                }
            }
        } else {
            Files.write(configFile, data, new OpenOption[0]);
        }
    }
}

