/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.project.MavenProject;

class FilteredProjectDependencyGraph
implements ProjectDependencyGraph {
    private ProjectDependencyGraph projectDependencyGraph;
    private Map<MavenProject, ?> whiteList;
    private List<MavenProject> sortedProjects;

    FilteredProjectDependencyGraph(ProjectDependencyGraph projectDependencyGraph, Collection<? extends MavenProject> whiteList) {
        this.projectDependencyGraph = Objects.requireNonNull(projectDependencyGraph, "projectDependencyGraph cannot be null");
        this.whiteList = new IdentityHashMap();
        for (MavenProject mavenProject : whiteList) {
            this.whiteList.put(mavenProject, null);
        }
    }

    @Override
    public List<MavenProject> getAllProjects() {
        return this.projectDependencyGraph.getAllProjects();
    }

    @Override
    public List<MavenProject> getSortedProjects() {
        if (this.sortedProjects == null) {
            this.sortedProjects = this.applyFilter(this.projectDependencyGraph.getSortedProjects());
        }
        return new ArrayList<MavenProject>(this.sortedProjects);
    }

    @Override
    public List<MavenProject> getDownstreamProjects(MavenProject project2, boolean transitive) {
        return this.applyFilter(this.projectDependencyGraph.getDownstreamProjects(project2, transitive));
    }

    @Override
    public List<MavenProject> getUpstreamProjects(MavenProject project2, boolean transitive) {
        return this.applyFilter(this.projectDependencyGraph.getUpstreamProjects(project2, transitive));
    }

    private List<MavenProject> applyFilter(Collection<? extends MavenProject> projects) {
        ArrayList<MavenProject> filtered = new ArrayList<MavenProject>(projects.size());
        for (MavenProject mavenProject : projects) {
            if (!this.whiteList.containsKey(mavenProject)) continue;
            filtered.add(mavenProject);
        }
        return filtered;
    }

    public String toString() {
        return this.getSortedProjects().toString();
    }
}

