/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import com.google.common.annotations.VisibleForTesting;
import java.lang.invoke.MethodHandles;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.jcip.annotations.NotThreadSafe;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.QueryLimit;
import org.apache.solr.util.ThreadCpuTimer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class CpuAllowedLimit
implements QueryLimit {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final long requestedTimeoutNs;
    private volatile long timedOutAt = 0L;
    AtomicLong accumulatedTime = new AtomicLong(0L);
    public static final String TIMING_CONTEXT = CpuAllowedLimit.class.getName();

    public CpuAllowedLimit(SolrQueryRequest req) {
        if (!ThreadCpuTimer.isSupported()) {
            throw new IllegalArgumentException("Thread CPU time monitoring is not available.");
        }
        long reqCpuLimit = req.getParams().getLong("cpuAllowed", -1L);
        if (reqCpuLimit <= 0L) {
            throw new IllegalArgumentException("Check for limit with hasCpuLimit(req) before creating a CpuAllowedLimit");
        }
        this.requestedTimeoutNs = TimeUnit.NANOSECONDS.convert(reqCpuLimit, TimeUnit.MILLISECONDS);
        ThreadCpuTimer.beginContext(TIMING_CONTEXT);
    }

    @VisibleForTesting
    CpuAllowedLimit(long limitMs) {
        this.requestedTimeoutNs = TimeUnit.NANOSECONDS.convert(limitMs, TimeUnit.MILLISECONDS);
    }

    static boolean hasCpuLimit(SolrQueryRequest req) {
        return req.getParams().getLong("cpuAllowed", -1L) > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldExit() {
        Long delta;
        block7: {
            boolean bl;
            if (this.timedOutAt > 0L) {
                return true;
            }
            delta = ThreadCpuTimer.readNSAndReset(TIMING_CONTEXT).orElse(0L);
            try {
                if (this.accumulatedTime.addAndGet(delta) <= this.requestedTimeoutNs) break block7;
                this.timedOutAt = this.accumulatedTime.get();
                bl = true;
            }
            catch (Throwable throwable) {
                if (log.isTraceEnabled()) {
                    DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.US);
                    DecimalFormat formatter = new DecimalFormat("#,###", symbols);
                    String threadName = Thread.currentThread().getName();
                    String deltaFmt = formatter.format(delta);
                    String accumulated = formatter.format(this.accumulatedTime.get());
                    String timeoutForComparison = formatter.format(this.requestedTimeoutNs);
                    log.trace("++++++++++++ SHOULD_EXIT - measuredDelta:{} accumulated:{} vs {} ++++ ON:{}", new Object[]{deltaFmt, accumulated, timeoutForComparison, threadName});
                }
                throw throwable;
            }
            if (log.isTraceEnabled()) {
                DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.US);
                DecimalFormat formatter = new DecimalFormat("#,###", symbols);
                String threadName = Thread.currentThread().getName();
                String deltaFmt = formatter.format(delta);
                String accumulated = formatter.format(this.accumulatedTime.get());
                String timeoutForComparison = formatter.format(this.requestedTimeoutNs);
                log.trace("++++++++++++ SHOULD_EXIT - measuredDelta:{} accumulated:{} vs {} ++++ ON:{}", new Object[]{deltaFmt, accumulated, timeoutForComparison, threadName});
            }
            return bl;
        }
        boolean bl = false;
        if (log.isTraceEnabled()) {
            DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.US);
            DecimalFormat formatter = new DecimalFormat("#,###", symbols);
            String threadName = Thread.currentThread().getName();
            String deltaFmt = formatter.format(delta);
            String accumulated = formatter.format(this.accumulatedTime.get());
            String timeoutForComparison = formatter.format(this.requestedTimeoutNs);
            log.trace("++++++++++++ SHOULD_EXIT - measuredDelta:{} accumulated:{} vs {} ++++ ON:{}", new Object[]{deltaFmt, accumulated, timeoutForComparison, threadName});
        }
        return bl;
    }

    @Override
    public Object currentValue() {
        return this.timedOutAt > 0L ? this.timedOutAt : this.accumulatedTime.get();
    }
}

