/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.filestore;

import jakarta.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import org.apache.solr.api.JerseyResource;
import org.apache.solr.client.api.endpoint.NodeFileStoreApis;
import org.apache.solr.client.api.model.FileStoreJsonFileResponse;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.filestore.ClusterFileStore;
import org.apache.solr.filestore.FileStore;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeFileStore
extends JerseyResource
implements NodeFileStoreApis {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final CoreContainer coreContainer;
    private final SolrQueryRequest req;
    private final SolrQueryResponse rsp;
    private final FileStore fileStore;

    @Inject
    public NodeFileStore(CoreContainer coreContainer, FileStore fileStore, SolrQueryRequest req, SolrQueryResponse rsp) {
        this.coreContainer = coreContainer;
        this.req = req;
        this.rsp = rsp;
        this.fileStore = fileStore;
    }

    @PermissionName(value=PermissionNameProvider.Name.FILESTORE_READ_PERM)
    @Deprecated
    public SolrJerseyResponse getFile(String path, Boolean sync, String getFrom, Boolean meta) {
        ClusterFileStore clusterFileApi = new ClusterFileStore(this.coreContainer, this.fileStore, this.req, this.rsp);
        if (Boolean.TRUE.equals(sync)) {
            return clusterFileApi.syncFile(path);
        }
        if (path == null) {
            path = "";
        }
        String pathCopy = path;
        if (getFrom != null) {
            return clusterFileApi.fetchFile(path, getFrom);
        }
        FileStore.FileType type = this.fileStore.getType(path, false);
        if (type == FileStore.FileType.NOFILE || type == FileStore.FileType.DIRECTORY || Boolean.TRUE.equals(meta) && type == FileStore.FileType.FILE) {
            return clusterFileApi.getMetadata(path);
        }
        if ("json".equals(this.req.getParams().get("wt"))) {
            FileStoreJsonFileResponse jsonResponse = this.instantiateJerseyResponse(FileStoreJsonFileResponse.class);
            try {
                this.fileStore.get(pathCopy, it -> {
                    try {
                        InputStream inputStream = it.getInputStream();
                        if (inputStream != null) {
                            jsonResponse.response = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
                        }
                    }
                    catch (IOException e) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error reading file " + pathCopy);
                    }
                }, false);
                return jsonResponse;
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error getting file from path " + path);
            }
        }
        return clusterFileApi.getFile(path);
    }
}

