/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.converter;

import java.util.EnumSet;
import java.util.Set;
import org.apache.sis.internal.converter.SystemConverter;
import org.apache.sis.internal.converter.SystemRegistry;
import org.apache.sis.math.FunctionProperty;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.resources.Errors;

final class NumberConverter<S extends Number, T extends Number>
extends SystemConverter<S, T> {
    private static final long serialVersionUID = 3339549290992876106L;
    private volatile transient ObjectConverter<T, S> inverse;

    NumberConverter(Class<S> clazz, Class<T> clazz2) {
        super(clazz, clazz2);
    }

    @Override
    public ObjectConverter<T, S> inverse() throws UnsupportedOperationException {
        ObjectConverter<Object, Object> objectConverter = this.inverse;
        if (objectConverter == null) {
            try {
                this.inverse = objectConverter = SystemRegistry.INSTANCE.findExact(this.targetClass, this.sourceClass);
            }
            catch (UnconvertibleObjectException unconvertibleObjectException) {
                throw new UnsupportedOperationException(Errors.format((short)102), unconvertibleObjectException);
            }
        }
        return objectConverter;
    }

    @Override
    public Set<FunctionProperty> properties() {
        return EnumSet.of(Numbers.widestClass(this.sourceClass, this.targetClass) == this.targetClass ? FunctionProperty.INJECTIVE : FunctionProperty.SURJECTIVE, FunctionProperty.ORDER_PRESERVING, FunctionProperty.INVERTIBLE);
    }

    @Override
    public T apply(S s) {
        double d;
        Object n;
        double d2 = ((Number)s).doubleValue();
        try {
            n = Numbers.cast(s, this.targetClass);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UnconvertibleObjectException(this.formatErrorMessage(s), illegalArgumentException);
        }
        double d3 = ((Number)n).doubleValue();
        if (Double.doubleToLongBits(d3) != Double.doubleToLongBits(d2) && !((d = Math.abs(d3 - d2)) < 0.5)) {
            if (d < 1.0) {
                n = Numbers.cast(Math.round(d2), this.targetClass);
            } else {
                throw new UnconvertibleObjectException(this.formatErrorMessage(s));
            }
        }
        return (T)n;
    }

    static final class Comparable<S extends Number>
    extends SystemConverter<S, java.lang.Comparable<?>> {
        private static final long serialVersionUID = -6366381413315460619L;

        Comparable(Class<S> clazz) {
            super(clazz, java.lang.Comparable.class);
        }

        @Override
        public Set<FunctionProperty> properties() {
            if (this.targetClass.isAssignableFrom(this.sourceClass)) {
                return Comparable.bijective();
            }
            return EnumSet.noneOf(FunctionProperty.class);
        }

        @Override
        public java.lang.Comparable<?> apply(Number number) {
            if (number == null || number instanceof java.lang.Comparable) {
                return (java.lang.Comparable)((Object)number);
            }
            return (java.lang.Comparable)((Object)Numbers.narrowestNumber(number));
        }
    }
}

