/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.utils;

import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.codec.binary.Hex;
import org.apache.tika.parser.DigestingParser;
import org.apache.tika.parser.digest.CompositeDigester;
import org.apache.tika.parser.digest.InputStreamDigester;

public class CommonsDigester
extends CompositeDigester {
    public CommonsDigester(int markLimit, String algorithmString) {
        super(CommonsDigester.buildDigesters(markLimit, algorithmString));
    }

    public CommonsDigester(int markLimit, DigestAlgorithm ... algorithms) {
        super(CommonsDigester.buildDigesters(markLimit, algorithms));
    }

    private static DigestingParser.Digester[] buildDigesters(int markLimit, DigestAlgorithm[] algorithms) {
        DigestingParser.Digester[] digesters = new DigestingParser.Digester[algorithms.length];
        int i = 0;
        for (DigestAlgorithm algorithm : algorithms) {
            digesters[i++] = new InputStreamDigester(markLimit, algorithm.getJavaName(), algorithm.name(), (DigestingParser.Encoder)new HexEncoder());
        }
        return digesters;
    }

    @Deprecated
    public static DigestAlgorithm[] parse(String s) {
        assert (s != null);
        ArrayList<DigestAlgorithm> ret = new ArrayList<DigestAlgorithm>();
        for (String algoString : s.split(",")) {
            ret.add(CommonsDigester.getDigestAlgorithm(algoString));
        }
        return ret.toArray(new DigestAlgorithm[ret.size()]);
    }

    private static DigestAlgorithm getDigestAlgorithm(String algoString) {
        String uc = algoString.toUpperCase(Locale.ROOT);
        if (uc.equals(DigestAlgorithm.MD2.toString())) {
            return DigestAlgorithm.MD2;
        }
        if (uc.equals(DigestAlgorithm.MD5.toString())) {
            return DigestAlgorithm.MD5;
        }
        if (uc.equals(DigestAlgorithm.SHA1.toString())) {
            return DigestAlgorithm.SHA1;
        }
        if (uc.equals(DigestAlgorithm.SHA256.toString())) {
            return DigestAlgorithm.SHA256;
        }
        if (uc.equals(DigestAlgorithm.SHA384.toString())) {
            return DigestAlgorithm.SHA384;
        }
        if (uc.equals(DigestAlgorithm.SHA512.toString())) {
            return DigestAlgorithm.SHA512;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (DigestAlgorithm algo : DigestAlgorithm.values()) {
            if (i++ > 0) {
                sb.append(", ");
            }
            sb.append(algo.toString());
        }
        throw new IllegalArgumentException("Couldn't match " + algoString + " with any of: " + sb.toString());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static DigestingParser.Digester[] buildDigesters(int markLimit, String digesterDef) {
        String[] digests = digesterDef.split(",");
        DigestingParser.Digester[] digesters = new DigestingParser.Digester[digests.length];
        int i = 0;
        for (String digest : digests) {
            void var10_10;
            String[] parts = digest.split(":");
            Object var10_11 = null;
            if (parts.length > 1) {
                if (parts[1].equals("16")) {
                    HexEncoder hexEncoder = new HexEncoder();
                } else {
                    if (!parts[1].equals("32")) throw new IllegalArgumentException("Value must be '16' or '32'");
                    Base32Encoder base32Encoder = new Base32Encoder();
                }
            } else {
                HexEncoder hexEncoder = new HexEncoder();
            }
            DigestAlgorithm digestAlgorithm = CommonsDigester.getDigestAlgorithm(parts[0]);
            digesters[i++] = new InputStreamDigester(markLimit, digestAlgorithm.getJavaName(), digestAlgorithm.name(), (DigestingParser.Encoder)var10_10);
        }
        return digesters;
    }

    private static class Base32Encoder
    implements DigestingParser.Encoder {
        private Base32Encoder() {
        }

        public String encode(byte[] bytes) {
            return new Base32().encodeToString(bytes);
        }
    }

    private static class HexEncoder
    implements DigestingParser.Encoder {
        private HexEncoder() {
        }

        public String encode(byte[] bytes) {
            return Hex.encodeHexString((byte[])bytes);
        }
    }

    public static enum DigestAlgorithm {
        MD2("MD2"),
        MD5("MD5"),
        SHA1("SHA-1"),
        SHA256("SHA-256"),
        SHA384("SHA-384"),
        SHA512("SHA-512");

        private final String javaName;

        private DigestAlgorithm(String javaName) {
            this.javaName = javaName;
        }

        String getJavaName() {
            return this.javaName;
        }

        String getMetadataKey() {
            return "X-TIKA:digest:" + this.toString();
        }
    }
}

