/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.snowflake.client.jdbc.internal.com.nimbusds.common.contenttype.ContentType;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.AbstractOptionallyIdentifiedRequest;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.ParseException;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.SerializeException;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.id.ClientID;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.token.AccessToken;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.token.RefreshToken;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.token.Token;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.token.TypelessAccessToken;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.token.TypelessToken;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.util.StringUtils;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.util.URLUtils;
import net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.nativesso.DeviceSecret;
import net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.nativesso.DeviceSecretToken;
import net.snowflake.client.jdbc.internal.net.jcip.annotations.Immutable;

@Immutable
public final class TokenRevocationRequest
extends AbstractOptionallyIdentifiedRequest {
    private final Token token;

    public TokenRevocationRequest(URI endpoint, ClientAuthentication clientAuth, Token token) {
        super(endpoint, Objects.requireNonNull(clientAuth));
        this.token = Objects.requireNonNull(token);
    }

    public TokenRevocationRequest(URI endpoint, ClientID clientID, Token token) {
        super(endpoint, Objects.requireNonNull(clientID));
        this.token = Objects.requireNonNull(token);
    }

    public Token getToken() {
        return this.token;
    }

    @Override
    public HTTPRequest toHTTPRequest() {
        if (this.getEndpointURI() == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        HTTPRequest httpRequest = new HTTPRequest(HTTPRequest.Method.POST, this.getEndpointURI());
        httpRequest.setEntityContentType(ContentType.APPLICATION_URLENCODED);
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        if (this.getClientID() != null) {
            params.put("client_id", Collections.singletonList(this.getClientID().getValue()));
        }
        params.put("token", Collections.singletonList(this.token.getValue()));
        if (this.token instanceof AccessToken) {
            params.put("token_type_hint", Collections.singletonList("access_token"));
        } else if (this.token instanceof RefreshToken) {
            params.put("token_type_hint", Collections.singletonList("refresh_token"));
        } else if (this.token instanceof DeviceSecretToken) {
            params.put("token_type_hint", Collections.singletonList("device_secret"));
        }
        httpRequest.setBody(URLUtils.serializeParameters(params));
        if (this.getClientAuthentication() != null) {
            this.getClientAuthentication().applyTo(httpRequest);
        }
        return httpRequest;
    }

    public static TokenRevocationRequest parse(HTTPRequest httpRequest) throws ParseException {
        httpRequest.ensureMethod(HTTPRequest.Method.POST);
        httpRequest.ensureEntityContentType(ContentType.APPLICATION_URLENCODED);
        Map params = httpRequest.getBodyAsFormParameters();
        String tokenValue = (String)MultivaluedMapUtils.getFirstValue(params, "token");
        if (StringUtils.isBlank(tokenValue)) {
            throw new ParseException("Missing required token parameter");
        }
        String tokenTypeHint = (String)MultivaluedMapUtils.getFirstValue(params, "token_type_hint");
        Token token = "access_token".equals(tokenTypeHint) ? new TypelessAccessToken(tokenValue) : ("refresh_token".equals(tokenTypeHint) ? new RefreshToken(tokenValue) : ("device_secret".equals(tokenTypeHint) ? new DeviceSecretToken(new DeviceSecret(tokenValue)) : new TypelessToken(tokenValue)));
        URI uri = httpRequest.getURI();
        ClientAuthentication clientAuth = ClientAuthentication.parse(httpRequest);
        if (clientAuth != null) {
            return new TokenRevocationRequest(uri, clientAuth, token);
        }
        String clientIDString = (String)MultivaluedMapUtils.getFirstValue(params, "client_id");
        if (StringUtils.isBlank(clientIDString)) {
            throw new ParseException("Invalid token revocation request: No client authentication or client_id parameter found");
        }
        return new TokenRevocationRequest(uri, new ClientID(clientIDString), token);
    }
}

