/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.Serializable;
import net.snowflake.client.jdbc.SFBaseFileTransferAgent;
import net.snowflake.client.jdbc.SnowflakeFileTransferMetadata;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.cloud.storage.StageInfo;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.annotation.JsonProperty;
import net.snowflake.client.jdbc.internal.snowflake.common.core.RemoteStoreFileEncryptionMaterial;

public class SnowflakeFileTransferMetadataV1
implements SnowflakeFileTransferMetadata,
Serializable {
    private static final long serialVersionUID = 1L;
    private String presignedUrl;
    private String presignedUrlFileName;
    private String encryptionMaterial_queryStageMasterKey;
    private String encryptionMaterial_queryId;
    private Long encryptionMaterial_smkId;
    private SFBaseFileTransferAgent.CommandType commandType;
    private StageInfo stageInfo;

    public SnowflakeFileTransferMetadataV1(String presignedUrl, String presignedUrlFileName, String encryptionMaterial_queryStageMasterKey, String encryptionMaterial_queryId, Long encryptionMaterial_smkId, SFBaseFileTransferAgent.CommandType commandType, StageInfo stageInfo) {
        this.presignedUrl = presignedUrl;
        this.presignedUrlFileName = presignedUrlFileName;
        this.encryptionMaterial_queryStageMasterKey = encryptionMaterial_queryStageMasterKey;
        this.encryptionMaterial_queryId = encryptionMaterial_queryId;
        this.encryptionMaterial_smkId = encryptionMaterial_smkId;
        this.commandType = commandType;
        this.stageInfo = stageInfo;
    }

    @Override
    public boolean isForOneFile() {
        return this.stageInfo.getStageType() == StageInfo.StageType.GCS && !SnowflakeUtil.isNullOrEmpty(this.presignedUrl) && !"null".equalsIgnoreCase(this.presignedUrl);
    }

    @JsonProperty(value="presignedUrl")
    public String getPresignedUrl() {
        return this.presignedUrl;
    }

    public void setPresignedUrl(String presignedUrl) {
        this.presignedUrl = presignedUrl;
    }

    @JsonProperty(value="presignedUrlFileName")
    public String getPresignedUrlFileName() {
        return this.presignedUrlFileName;
    }

    public void setPresignedUrlFileName(String presignedUrlFileName) {
        this.presignedUrlFileName = presignedUrlFileName;
    }

    @JsonProperty(value="encryptionMaterial")
    public RemoteStoreFileEncryptionMaterial getEncryptionMaterial() {
        return new RemoteStoreFileEncryptionMaterial(this.encryptionMaterial_queryStageMasterKey, this.encryptionMaterial_queryId, this.encryptionMaterial_smkId);
    }

    public void setEncryptionMaterial(String encryptionMaterial_queryStageMasterKey, String encryptionMaterial_queryId, Long encryptionMaterial_smkId) {
        this.encryptionMaterial_queryStageMasterKey = encryptionMaterial_queryStageMasterKey;
        this.encryptionMaterial_queryId = encryptionMaterial_queryId;
        this.encryptionMaterial_smkId = encryptionMaterial_smkId;
    }

    @JsonProperty(value="commandType")
    public SFBaseFileTransferAgent.CommandType getCommandType() {
        return this.commandType;
    }

    public void setCommandType(SFBaseFileTransferAgent.CommandType commandType) {
        this.commandType = commandType;
    }

    @JsonProperty(value="stageInfo")
    public StageInfo getStageInfo() {
        return this.stageInfo;
    }

    public void setStageInfo(StageInfo stageInfo) {
        this.stageInfo = stageInfo;
    }
}

