/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.auth.oauth;

import java.net.URI;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFLoginInput;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.core.auth.oauth.AccessTokenProvider;
import net.snowflake.client.core.auth.oauth.DPoPUtil;
import net.snowflake.client.core.auth.oauth.OAuthUtil;
import net.snowflake.client.core.auth.oauth.TokenResponseDTO;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeUseDPoPNonceException;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpRequestBase;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.AuthorizationGrant;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.ClientCredentialsGrant;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.Scope;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.TokenRequest;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.auth.Secret;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.id.ClientID;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

@SnowflakeJdbcInternalApi
public class OAuthClientCredentialsAccessTokenProvider
implements AccessTokenProvider {
    private static final SFLogger logger = SFLoggerFactory.getLogger(OAuthClientCredentialsAccessTokenProvider.class);
    private final DPoPUtil dpopUtil = new DPoPUtil();

    @Override
    public TokenResponseDTO getAccessToken(SFLoginInput loginInput) throws SFException {
        return this.exchangeClientCredentialsForAccessToken(loginInput, null, false);
    }

    @Override
    public String getDPoPPublicKey() {
        return this.dpopUtil.getPublicKey();
    }

    private TokenResponseDTO exchangeClientCredentialsForAccessToken(SFLoginInput loginInput, String dpopNonce, boolean retried) throws SFException {
        try {
            logger.info("Starting OAuth client credentials authentication flow...", new Object[0]);
            HttpRequestBase tokenRequest = this.buildTokenRequest(loginInput, dpopNonce);
            return OAuthUtil.sendTokenRequest(tokenRequest, loginInput);
        }
        catch (SnowflakeUseDPoPNonceException e) {
            logger.debug("Received \"use_dpop_nonce\" error from IdP while performing token request", new Object[0]);
            if (!retried) {
                logger.debug("Retrying token request with DPoP nonce included...", new Object[0]);
                return this.exchangeClientCredentialsForAccessToken(loginInput, e.getNonce(), true);
            }
            logger.debug("Skipping DPoP nonce retry as it has been already retried", new Object[0]);
            throw e;
        }
        catch (Exception | SFException e) {
            logger.error("Error during OAuth client credentials flow. Verify configuration passed to driver and IdP (URLs, grant types, scope, etc.)", e);
            throw new SFException(e, ErrorCode.OAUTH_CLIENT_CREDENTIALS_FLOW_ERROR, e.getMessage());
        }
    }

    private HttpRequestBase buildTokenRequest(SFLoginInput loginInput, String dpopNonce) throws SFException {
        URI tokenRequestUrl = OAuthUtil.getTokenRequestUrl(loginInput.getOauthLoginInput(), loginInput.getServerUrl());
        ClientSecretBasic clientAuthentication = new ClientSecretBasic(new ClientID(loginInput.getOauthLoginInput().getClientId()), new Secret(loginInput.getOauthLoginInput().getClientSecret()));
        Scope scope = new Scope(OAuthUtil.getScope(loginInput.getOauthLoginInput(), loginInput.getRole()));
        TokenRequest tokenRequest = new TokenRequest(tokenRequestUrl, clientAuthentication, (AuthorizationGrant)new ClientCredentialsGrant(), scope);
        HTTPRequest tokenHttpRequest = tokenRequest.toHTTPRequest();
        HttpRequestBase convertedTokenRequest = OAuthUtil.convertToBaseRequest(tokenHttpRequest);
        if (loginInput.isDPoPEnabled()) {
            this.dpopUtil.addDPoPProofHeaderToRequest(convertedTokenRequest, dpopNonce);
        }
        return convertedTokenRequest;
    }
}

