/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.time.Duration;
import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.arrow.AbstractArrowVectorConverter;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BigIntVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;

class IntervalDayTimeToDurationConverter
extends AbstractArrowVectorConverter {
    private BigIntVector vector;
    private static final long nanoInSecond = 1000000000L;

    public IntervalDayTimeToDurationConverter(ValueVector vector, int idx, DataConversionContext context) {
        super(SnowflakeType.INTERVAL_DAY_TIME.name(), vector, idx, context);
        this.vector = (BigIntVector)vector;
    }

    @Override
    public Duration toDuration(int index) throws SFException {
        if (this.isNull(index)) {
            return null;
        }
        long numNanos = this.vector.getObject(index);
        try {
            int sign = Long.signum(numNanos);
            numNanos = Math.abs(numNanos);
            Duration duration = Duration.ofSeconds(numNanos / 1000000000L, numNanos % 1000000000L);
            if (sign >= 0) {
                return duration;
            }
            return duration.negated();
        }
        catch (ArithmeticException e) {
            throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "Duration", numNanos);
        }
    }

    @Override
    public String toString(int index) throws SFException {
        if (this.isNull(index)) {
            return null;
        }
        return this.toDuration(index).toString();
    }

    @Override
    public Object toObject(int index) throws SFException {
        return this.toDuration(index);
    }
}

