-- SchemaCrawler
-- http://www.schemacrawler.com
-- Copyright (c) 2000-2025, Sualeh Fatehi <sualeh@hotmail.com>.
-- All rights reserved.
-- SPDX-License-Identifier: EPL-2.0

SELECT
  NULL AS TABLE_CAT,
  TABLES.OWNER AS TABLE_SCHEM,
  TABLES.TABLE_NAME AS TABLE_NAME,
  TABLES.TABLE_TYPE AS TABLE_TYPE,
  TABLES.COMMENTS AS REMARKS
FROM
  ${catalogscope}_TAB_COMMENTS TABLES
  INNER JOIN ${catalogscope}_USERS USERS
    ON TABLES.OWNER = USERS.USERNAME
      AND USERS.ORACLE_MAINTAINED = 'N'
      AND NOT REGEXP_LIKE(USERS.USERNAME, '^APEX_[0-9]{6}$')
      AND NOT REGEXP_LIKE(USERS.USERNAME, '^FLOWS_[0-9]{5}$')
      AND NOT REGEXP_LIKE(USERS.USERNAME, '^OPS\$ORACLE$')
WHERE
  REGEXP_LIKE(TABLES.OWNER, '${schema-inclusion-rule}')
  AND REGEXP_LIKE(TABLES.OWNER || '.' || TABLES.TABLE_NAME, '${table-inclusion-rule}')
  AND TABLES.TABLE_NAME NOT LIKE 'BIN$%'
  AND NOT REGEXP_LIKE(TABLES.TABLE_NAME, '^(SYS_IOT|MDOS|MDRS|MDRT|MDOT|MDXT)_.*$')
UNION ALL
SELECT
  NULL AS TABLE_CAT,
  MVIEWS.OWNER AS TABLE_SCHEM,
  MVIEWS.MVIEW_NAME AS TABLE_NAME,
  'MATERIALIZED VIEW' AS TABLE_TYPE,
  MVIEWS.COMMENTS AS REMARKS
FROM
  ${catalogscope}_MVIEW_COMMENTS MVIEWS
  INNER JOIN ${catalogscope}_USERS USERS
    ON MVIEWS.OWNER = USERS.USERNAME
      AND USERS.ORACLE_MAINTAINED = 'N'
      AND NOT REGEXP_LIKE(USERS.USERNAME, '^APEX_[0-9]{6}$')
      AND NOT REGEXP_LIKE(USERS.USERNAME, '^FLOWS_[0-9]{5}$')
      AND NOT REGEXP_LIKE(USERS.USERNAME, '^OPS\$ORACLE$')
WHERE
  REGEXP_LIKE(MVIEWS.OWNER, '${schema-inclusion-rule}')
  AND REGEXP_LIKE(MVIEWS.OWNER || '.' || MVIEWS.MVIEW_NAME, '${table-inclusion-rule}')
