/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.function.builtins.clinic;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ClinicConverterFactory;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentCastNode;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.profiles.ConditionProfile;

public final class DefaultValueNode
extends ArgumentCastNode {
    private final Object defaultValue;
    private final boolean useDefaultForNone;
    private final ConditionProfile profileArg = ConditionProfile.create();

    @ClinicConverterFactory(shortCircuitPrimitive={ArgumentClinic.PrimitiveType.Boolean, ArgumentClinic.PrimitiveType.Int, ArgumentClinic.PrimitiveType.Long, ArgumentClinic.PrimitiveType.Double})
    @NeverDefault
    public static DefaultValueNode create(@ClinicConverterFactory.DefaultValue Object defaultValue, @ClinicConverterFactory.UseDefaultForNone boolean useDefaultForNone) {
        return new DefaultValueNode(defaultValue, useDefaultForNone);
    }

    protected DefaultValueNode(Object defaultValue, boolean useDefaultForNone) {
        this.defaultValue = defaultValue;
        this.useDefaultForNone = useDefaultForNone;
    }

    @Override
    public Object execute(VirtualFrame frame, Object value) {
        if (this.profileArg.profile(DefaultValueNode.isHandledPNone(this.useDefaultForNone, value))) {
            return this.defaultValue;
        }
        return value;
    }
}

