/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.method;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.method.ClassmethodCommonBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.method.ClassmethodCommonBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.method.PDecoratedMethod;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotDescrGet;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PClassmethod, PythonBuiltinClassType.PBuiltinClassMethod})
public final class ClassmethodCommonBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = ClassmethodCommonBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ClassmethodCommonBuiltinsFactory.getFactories();
    }

    @Slot(value=Slot.SlotKind.tp_call, isComplex=true)
    @Slot.SlotSignature(minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    static abstract class CallNode
    extends PythonVarargsBuiltinNode {
        @Node.Child
        private com.oracle.graal.python.nodes.call.CallNode callNode = com.oracle.graal.python.nodes.call.CallNode.create();

        CallNode() {
        }

        @Specialization
        protected Object doIt(VirtualFrame frame, PDecoratedMethod self, Object[] arguments, PKeyword[] keywords) {
            return this.callNode.execute((Frame)frame, self.getCallable(), arguments, keywords);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    @ImportStatic(value={PGuards.class})
    @ReportPolymorphism
    static abstract class MakeMethodNode
    extends PNodeWithContext {
        MakeMethodNode() {
        }

        abstract Object execute(Node var1, Object var2, Object var3);

        @Specialization
        Object method(Object self, PFunction func, @Bind PythonLanguage language) {
            return PFactory.createMethod(language, self, func);
        }

        @Specialization(guards={"!func.needsDeclaringType()"})
        Object methodBuiltin(Object self, PBuiltinFunction func, @Bind PythonLanguage language) {
            return PFactory.createBuiltinMethod(language, self, func);
        }

        @Specialization(guards={"func.needsDeclaringType()"})
        Object methodBuiltinWithDeclaringType(Object self, PBuiltinFunction func, @Bind PythonLanguage language) {
            return PFactory.createBuiltinMethod(language, self, func, func.getEnclosingType());
        }

        @Specialization(guards={"!isFunction(func)"})
        Object generic(Object self, Object func, @Bind PythonLanguage language) {
            return PFactory.createMethod(language, self, func);
        }
    }

    @Slot(value=Slot.SlotKind.tp_descr_get)
    @ReportPolymorphism
    @GenerateUncached
    @GenerateNodeFactory
    static abstract class GetNode
    extends TpSlotDescrGet.DescrGetBuiltinNode {
        GetNode() {
        }

        @Specialization(guards={"isSingleContext()", "isNoValue(type)", "cachedSelf == self", "cachedCallable != null"}, limit="3")
        static Object getCached(PDecoratedMethod self, Object obj, Object type, @Bind Node inliningTarget, @Cached(value="self", weak=true) PDecoratedMethod cachedSelf, @Cached(value="self.getCallable()", weak=true) Object cachedCallable, @Cached.Shared @Cached GetClassNode getClass, @Cached.Shared @Cached MakeMethodNode makeMethod) {
            return makeMethod.execute(inliningTarget, getClass.execute(inliningTarget, obj), cachedCallable);
        }

        @Specialization(guards={"isNoValue(type)"}, replaces={"getCached"})
        static Object get(PDecoratedMethod self, Object obj, Object type, @Bind Node inliningTarget, @Cached.Shared @Cached GetClassNode getClass, @Cached.Shared @Cached MakeMethodNode makeMethod, @Cached.Shared @Cached PRaiseNode raiseNode) {
            return GetNode.doGet(inliningTarget, self, getClass.execute(inliningTarget, obj), makeMethod, raiseNode);
        }

        @Specialization(guards={"isSingleContext()", "!isNoValue(type)", "cachedSelf == self", "cachedCallable != null"}, limit="3")
        static Object getTypeCached(PDecoratedMethod self, Object obj, Object type, @Bind Node inliningTarget, @Cached(value="self", weak=true) PDecoratedMethod cachedSelf, @Cached(value="self.getCallable()", weak=true) Object cachedCallable, @Cached.Shared @Cached MakeMethodNode makeMethod) {
            return makeMethod.execute(inliningTarget, type, cachedCallable);
        }

        @Specialization(guards={"!isNoValue(type)"}, replaces={"getTypeCached"})
        static Object getType(PDecoratedMethod self, Object obj, Object type, @Bind Node inliningTarget, @Cached.Shared @Cached MakeMethodNode makeMethod, @Cached.Shared @Cached PRaiseNode raiseNode) {
            return GetNode.doGet(inliningTarget, self, type, makeMethod, raiseNode);
        }

        private static Object doGet(Node inliningTarget, PDecoratedMethod self, Object type, MakeMethodNode makeMethod, PRaiseNode raiseNode) {
            Object callable = self.getCallable();
            if (callable == null) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.RuntimeError, ErrorMessages.UNINITIALIZED_S_OBJECT);
            }
            return makeMethod.execute(inliningTarget, type, callable);
        }
    }
}

