/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.db;

import com.ibm.db2.cmx.runtime.HeterogeneousBatchKind;
import com.ibm.db2.cmx.runtime.data.handlers.BeanRowHandler;
import com.ibm.db2.cmx.runtime.data.handlers.ConstantRowHandler;
import com.ibm.db2.cmx.runtime.data.handlers.IteratorResultHandler;
import com.ibm.db2.cmx.runtime.data.handlers.ListResultHandler;
import com.ibm.db2.cmx.runtime.data.handlers.MapRowHandler;
import com.ibm.db2.cmx.runtime.data.handlers.ObjectRowHandler;
import com.ibm.db2.cmx.runtime.data.handlers.SingleResultHandler;
import com.ibm.db2.cmx.runtime.data.handlers.StoredProcedureResultImpl;
import com.ibm.db2.cmx.runtime.exception.DataSQLException;
import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.generator.HandlerContainer;
import com.ibm.db2.cmx.runtime.handlers.BatchHandler;
import com.ibm.db2.cmx.runtime.handlers.CallHandler;
import com.ibm.db2.cmx.runtime.handlers.CallHandlerWithParameters;
import com.ibm.db2.cmx.runtime.handlers.ParameterHandler;
import com.ibm.db2.cmx.runtime.handlers.ResultHandler;
import com.ibm.db2.cmx.runtime.handlers.RowHandler;
import com.ibm.db2.cmx.runtime.handlers.RowHandlerWithParameters;
import com.ibm.db2.cmx.runtime.internal.db.DataImpl;
import com.ibm.db2.cmx.runtime.internal.metadata.BeanInformationCache;
import com.ibm.db2.cmx.runtime.internal.metadata.ParameterInfoArray;
import com.ibm.db2.cmx.runtime.internal.metadata.ParameterInformationCache;
import com.ibm.db2.cmx.runtime.internal.metadata.StatementDescriptorImpl;
import com.ibm.db2.cmx.runtime.internal.parser.EscapeLexer;
import com.ibm.db2.cmx.runtime.internal.proxy.PDQResultSetProxyHandler;
import com.ibm.db2.cmx.runtime.internal.proxy.ProxyCache;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.statement.Hook;
import com.ibm.db2.cmx.runtime.statement.SqlStatementType;
import com.ibm.db2.cmx.runtime.statement.StatementDescriptor;
import java.lang.reflect.Array;
import java.sql.BatchUpdateException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class JdbcData
extends DataImpl {
    protected Connection connection_;
    protected DatabaseMetaData dbMetaData_;
    public boolean ignoreAGK_;
    private static final int[] zeroRowIntArray = new int[0];
    protected final Integer queryTimeout_;
    protected final Integer maxRows_;
    public static final int SOURCE_RUNTIME = 0;
    public static final int SOURCE_GENERATOR = 1;

    public JdbcData(Connection connection, Hook hook, Map<Object, Object> map, Integer n2, Integer n3, DatabaseMetaData databaseMetaData) {
        this.connection_ = connection;
        this.hook_ = hook;
        this.sqlOverrides_ = map;
        this.queryTimeout_ = n2;
        this.maxRows_ = n3;
        this.ignoreAGK_ = false;
        this.dbMetaData_ = databaseMetaData;
    }

    @Override
    public Connection getConnection() {
        if (this.isHeteroBatch_) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_NOT_DURING_BATCH", "getConnection"), null, 10399);
        }
        if (this.connection_ != null) {
            return this.connection_;
        }
        throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_CONN_CLOSED", new Object[0]), null, 10098);
    }

    @Override
    public void close() {
        if (this.connection_ != null) {
            try {
                this.connection_.close();
            }
            catch (SQLException sQLException) {
                throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_DURING_CONN_CLOSE", new Object[0]), sQLException, 10099);
            }
        }
    }

    @Override
    protected <ROW> int update_(ROW ROW, StatementDescriptor statementDescriptor, HandlerContainer<?, ? extends ROW, ?> handlerContainer, Object ... objectArray) {
        int n2;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.prepareStatementAndInvokeParameterHandler(statementDescriptor, handlerContainer, false, objectArray);
            if (this.isHeteroBatch_) {
                this.addToHeteroBatch(preparedStatement);
                preparedStatement = null;
                int n3 = -2;
                return n3;
            }
            n2 = this.executeStatementForAutogeneratedKeysAndSetValues(preparedStatement, ROW, statementDescriptor, handlerContainer);
        }
        catch (SQLException sQLException) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_UPD", new Object[0]), sQLException, 10100);
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return n2;
    }

    @Override
    protected ResultSet queryResultsInternal_(StatementDescriptorImpl statementDescriptorImpl, Object ... objectArray) {
        ResultSet resultSet = null;
        try {
            PreparedStatement preparedStatement = this.prepareStatementAndSetInputParameters(statementDescriptorImpl, true, objectArray);
            resultSet = preparedStatement.executeQuery();
            return resultSet;
        }
        catch (SQLException sQLException) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_QUERY", new Object[0]), sQLException, 10101);
        }
    }

    @Override
    protected ResultSet queryResultsWrapped_(StatementDescriptorImpl statementDescriptorImpl, Object ... objectArray) {
        ResultSet resultSet = this.queryResultsInternal_(statementDescriptorImpl, objectArray);
        return (ResultSet)ProxyCache.createInstance(resultSet, new PDQResultSetProxyHandler(resultSet, false));
    }

    public <RES> RES queryResultsWrappedImpl_(StatementDescriptorImpl statementDescriptorImpl, Object ... objectArray) {
        ResultSet resultSet = this.queryResultsWrapped_(statementDescriptorImpl, objectArray);
        Object RES = statementDescriptorImpl.getResultHandler(null).handle(resultSet);
        return RES;
    }

    @Override
    protected <RES> RES queryInternal_(StatementDescriptorImpl statementDescriptorImpl, Object ... objectArray) {
        ResultSet resultSet = this.queryResultsInternal_(statementDescriptorImpl, objectArray);
        return statementDescriptorImpl.getResultHandler(null).handle(resultSet);
    }

    private PreparedStatement prepareStatementAndSetInputParameters(StatementDescriptorImpl statementDescriptorImpl, boolean bl2, Object ... objectArray) throws SQLException {
        String string = statementDescriptorImpl.getProcessedSql();
        PreparedStatement preparedStatement = this.getPreparedStatement(string, statementDescriptorImpl.getColumnNames(), statementDescriptorImpl, bl2);
        if (null != objectArray && objectArray.length > 0) {
            statementDescriptorImpl.getParameterHandlerForInline().handleParameters(preparedStatement, objectArray);
        }
        return preparedStatement;
    }

    private <T> PreparedStatement prepareStatementAndSetBatchInputParameters(StatementDescriptorImpl statementDescriptorImpl, Iterator<T> iterator, T[] TArray, int[] nArray) throws SQLException {
        PreparedStatement preparedStatement;
        block6: {
            ParameterHandler parameterHandler;
            block7: {
                String string = statementDescriptorImpl.getProcessedSql();
                preparedStatement = statementDescriptorImpl.getColumnNames() == null ? this.getPreparedStatement(string, null, statementDescriptorImpl, false) : this.getPreparedStatement(string, statementDescriptorImpl.getColumnNames(), statementDescriptorImpl, false);
                if (null == iterator && null == TArray) break block6;
                parameterHandler = statementDescriptorImpl.getParameterHandlerForInline();
                if (iterator == null) break block7;
                while (iterator.hasNext()) {
                    T t2 = iterator.next();
                    if (t2 instanceof Object[]) {
                        parameterHandler.handleParameters(preparedStatement, (Object[])t2);
                    } else {
                        parameterHandler.handleParameters(preparedStatement, t2);
                    }
                    preparedStatement.addBatch();
                    nArray[0] = nArray[0] + 1;
                }
                break block6;
            }
            if (TArray == null) break block6;
            for (int i10 = 0; i10 < TArray.length; ++i10) {
                T t3 = TArray[i10];
                if (t3 instanceof Object[]) {
                    parameterHandler.handleParameters(preparedStatement, (Object[])t3);
                } else {
                    parameterHandler.handleParameters(preparedStatement, t3);
                }
                preparedStatement.addBatch();
                nArray[0] = nArray[0] + 1;
            }
        }
        return preparedStatement;
    }

    @Override
    protected <ROW> Iterator<ROW> queryIterator_(StatementDescriptor statementDescriptor, HandlerContainer<?, ? extends ROW, ?> handlerContainer, Object ... objectArray) {
        Object object = null;
        try {
            PreparedStatement preparedStatement = this.prepareStatementAndInvokeParameterHandler(statementDescriptor, handlerContainer, true, objectArray);
            ResultSet resultSet = preparedStatement.executeQuery();
            IteratorResultHandler<ROW> iteratorResultHandler = new IteratorResultHandler<ROW>(statementDescriptor.getRowHandler(handlerContainer), objectArray);
            object = iteratorResultHandler.handle(resultSet);
            return object;
        }
        catch (SQLException sQLException) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_QUERY", new Object[0]), sQLException, 10102);
        }
    }

    private PreparedStatement prepareStatementAndInvokeParameterHandler(StatementDescriptor statementDescriptor, HandlerContainer<?, ?, ?> handlerContainer, boolean bl2, Object ... objectArray) throws SQLException {
        PreparedStatement preparedStatement = this.getPreparedStatement(statementDescriptor.getProcessedSql(), statementDescriptor.getColumnNames(), statementDescriptor, bl2);
        ParameterHandler parameterHandler = ((StatementDescriptorImpl)statementDescriptor).getParameterHandler(handlerContainer);
        if (parameterHandler != null) {
            parameterHandler.handleParameters(preparedStatement, objectArray);
        }
        return preparedStatement;
    }

    protected PreparedStatement getPreparedStatement(String string, String[] stringArray, StatementDescriptor statementDescriptor, boolean bl2) throws SQLException {
        Object object;
        PreparedStatement preparedStatement = null;
        this.ignoreAGK_ = stringArray == null;
        StatementDescriptorImpl statementDescriptorImpl = (StatementDescriptorImpl)statementDescriptor;
        if (stringArray != null && !bl2) {
            object = statementDescriptor.getSqlStatementType();
            if ((object == SqlStatementType.UPDATE || object == SqlStatementType.DELETE || object == SqlStatementType.MERGE) && this.connection_.getAutoCommit()) {
                this.ignoreAGK_ = true;
            }
            try {
                if (this.ignoreAGK_) {
                    preparedStatement = this.connection_.prepareStatement(string);
                }
                this.storeMetadataCorrelatorForTransportToMonitorLayer(statementDescriptorImpl);
                preparedStatement = this.connection_.prepareStatement(string, stringArray);
            }
            catch (SQLException sQLException) {
                String string2 = sQLException.getSQLState();
                if (string2 != null && string2.equalsIgnoreCase("0A000")) {
                    this.storeMetadataCorrelatorForTransportToMonitorLayer(statementDescriptorImpl);
                    preparedStatement = this.connection_.prepareStatement(string, 1);
                }
                throw sQLException;
            }
        } else if (!bl2) {
            this.storeMetadataCorrelatorForTransportToMonitorLayer(statementDescriptorImpl);
            preparedStatement = this.connection_.prepareStatement(string);
        } else if (!this.dbMetaData_.supportsResultSetHoldability(statementDescriptorImpl.getHoldability())) {
            this.storeMetadataCorrelatorForTransportToMonitorLayer(statementDescriptorImpl);
            preparedStatement = this.connection_.prepareStatement(string, statementDescriptorImpl.getType(), statementDescriptorImpl.getConcurrency());
        } else {
            this.storeMetadataCorrelatorForTransportToMonitorLayer(statementDescriptorImpl);
            try {
                preparedStatement = this.connection_.prepareStatement(string, statementDescriptorImpl.getType(), statementDescriptorImpl.getConcurrency(), statementDescriptorImpl.getHoldability());
            }
            catch (SQLException sQLException) {
                String string3 = this.dbMetaData_.getDriverName();
                if (string3.startsWith("Microsoft")) {
                    preparedStatement = this.connection_.prepareStatement(string, statementDescriptorImpl.getType(), statementDescriptorImpl.getConcurrency());
                }
                throw sQLException;
            }
        }
        object = statementDescriptorImpl.getCursorName();
        if (object != null && bl2) {
            preparedStatement.setCursorName((String)object);
        }
        this.applySQLSettingsToStatement(preparedStatement);
        return preparedStatement;
    }

    @Override
    protected int update_(StatementDescriptor statementDescriptor, HandlerContainer<?, ?, ?> handlerContainer, Object ... objectArray) {
        int n2;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.prepareStatementAndInvokeParameterHandler(statementDescriptor, handlerContainer, false, objectArray);
            if (this.isHeteroBatch_) {
                this.addToHeteroBatch(preparedStatement);
                preparedStatement = null;
                int n3 = -2;
                return n3;
            }
            n2 = preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_UPD", new Object[0]), sQLException, 10103);
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected <ROW> ROW update_(Class<ROW> clazz, String[] stringArray, StatementDescriptorImpl statementDescriptorImpl, Object ... objectArray) {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            this.processGeneratedKeyColumnNames(statementDescriptorImpl, stringArray, objectArray);
            statement = this.prepareStatementAndSetInputParameters(statementDescriptorImpl, false, objectArray);
            if (this.isHeteroBatch_) {
                this.addToHeteroBatch((PreparedStatement)statement);
                statement = null;
                ROW ROW = null;
                return ROW;
            }
            int n2 = statement.executeUpdate();
            String[] stringArray2 = statementDescriptorImpl.getColumnNames();
            if (this.ignoreAGK_) return null;
            if (stringArray2 == null) return null;
            resultSet = statement.getGeneratedKeys();
            if (!resultSet.next()) return null;
            if (clazz == Object[].class) {
                Object[] objectArray2 = new Object[stringArray2.length + 1];
                ObjectRowHandler objectRowHandler = new ObjectRowHandler();
                objectRowHandler.handle(resultSet, objectArray2);
                objectArray2[objectArray2.length - 1] = n2;
                Object[] objectArray3 = objectArray2;
                return (ROW)objectArray3;
            }
            ConstantRowHandler<Object> constantRowHandler = new ConstantRowHandler<Object>(clazz);
            ROW ROW = constantRowHandler.handle(resultSet, (Object)null);
            return ROW;
        }
        catch (SQLException sQLException) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_UPD", new Object[0]), sQLException, 10104);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    @Override
    protected <T> int[] updateMany_(StatementDescriptorImpl statementDescriptorImpl, Iterator<T> iterator, T[] TArray) {
        int[] nArray;
        PreparedStatement preparedStatement = null;
        int[] nArray2 = new int[]{0};
        try {
            int[] nArray3;
            preparedStatement = this.prepareStatementAndSetBatchInputParameters(statementDescriptorImpl, iterator, TArray, nArray2);
            if (this.isHeteroBatch_) {
                this.addToHeteroBatch(preparedStatement);
                preparedStatement = null;
                int[] nArray4 = zeroRowIntArray;
                return nArray4;
            }
            nArray = nArray3 = preparedStatement.executeBatch();
        }
        catch (BatchUpdateException batchUpdateException) {
            int n2 = nArray2[0];
            int[] nArray5 = this.fixUpdateCounts(batchUpdateException, n2);
            throw ExceptionFactory.createUpdateManyExceptionForRuntimeOnly(this, Messages.getText("ERR_UPD", new Object[0]), batchUpdateException, 10105, nArray5, null);
        }
        catch (SQLException sQLException) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_UPD", new Object[0]), sQLException, 10106);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return nArray;
    }

    protected int[] fixUpdateCounts(BatchUpdateException batchUpdateException, int n2) {
        int[] nArray = batchUpdateException.getUpdateCounts();
        if (nArray != null && nArray.length < n2) {
            int[] nArray2 = new int[n2];
            Arrays.fill(nArray2, -3);
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            nArray = nArray2;
        }
        return nArray;
    }

    public void setConnection(Connection connection) {
        if (this.isHeteroBatch_) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_NOT_DURING_BATCH", "setConnection"), null, 10398);
        }
        this.connection_ = connection;
    }

    @Override
    protected int update_(String[] stringArray, StatementDescriptorImpl statementDescriptorImpl, Object ... objectArray) {
        int n2;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            this.processGeneratedKeyColumnNames(statementDescriptorImpl, stringArray, objectArray);
            statement = this.prepareStatementAndSetInputParameters(statementDescriptorImpl, false, objectArray);
            if (this.isHeteroBatch_) {
                this.addToHeteroBatch((PreparedStatement)statement);
                statement = null;
                int n3 = -2;
                return n3;
            }
            int n4 = statement.executeUpdate();
            if (!this.ignoreAGK_ && statementDescriptorImpl.getColumnNames() != null) {
                resultSet = statement.getGeneratedKeys();
                InputParameterType inputParameterType = statementDescriptorImpl.getParameterTypeinMethod()[0];
                if (resultSet.next()) {
                    if (inputParameterType == InputParameterType.INPUT_PARAMETERS_AS_BEAN) {
                        BeanRowHandler beanRowHandler = new BeanRowHandler(objectArray[0].getClass());
                        beanRowHandler.handle(resultSet, objectArray[0]);
                    } else if (inputParameterType == InputParameterType.INPUT_PARAMETERS_AS_OBJECT_MAP) {
                        MapRowHandler mapRowHandler = new MapRowHandler();
                        mapRowHandler.updateMap(resultSet, (Map)objectArray[0], statementDescriptorImpl.getColumnNames());
                    } else {
                        ObjectRowHandler objectRowHandler = new ObjectRowHandler();
                        objectRowHandler.handle(resultSet, (Object[])objectArray[objectArray.length - 1]);
                    }
                }
            }
            n2 = n4;
        }
        catch (SQLException sQLException) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_UPD", new Object[0]), sQLException, 10107);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return n2;
    }

    private void processGeneratedKeyColumnNames(StatementDescriptorImpl statementDescriptorImpl, String[] stringArray, Object ... objectArray) throws DataSQLException {
        if (objectArray != null && stringArray == null && objectArray.length >= 1 && objectArray[0] != null) {
            this.processGeneratedKeyInputParm(statementDescriptorImpl, objectArray[0]);
        }
    }

    private void processGeneratedKeyInputParm(StatementDescriptorImpl statementDescriptorImpl, Object object) throws DataSQLException {
        Class<?> clazz;
        if (statementDescriptorImpl.getMethodInfoArray().hasHostVariable() && !Map.class.isAssignableFrom(clazz = object.getClass())) {
            String[] stringArray = BeanInformationCache.getBeanInformation(clazz).getAutoGenColumnNames();
            statementDescriptorImpl.setColumnNames(stringArray);
        }
    }

    @Override
    public <ROW> ROW[] queryArray_(StatementDescriptor statementDescriptor, HandlerContainer<?, ? extends ROW, ?> handlerContainer, Class<ROW> clazz, Object ... objectArray) {
        List<ROW> list = this.queryList_(statementDescriptor, handlerContainer, objectArray);
        return list.toArray((Object[])Array.newInstance(clazz, list.size()));
    }

    @Override
    protected <RES> RES query_(StatementDescriptor statementDescriptor, HandlerContainer<? extends RES, ?, ?> handlerContainer, Object ... objectArray) {
        RES RES = null;
        try {
            PreparedStatement preparedStatement = this.prepareStatementAndInvokeParameterHandler(statementDescriptor, handlerContainer, true, objectArray);
            ResultSet resultSet = null;
            resultSet = preparedStatement.executeQuery();
            ResultHandler<RES> resultHandler = statementDescriptor.getResultHandler(handlerContainer);
            RES = resultHandler.handle(resultSet);
            return RES;
        }
        catch (SQLException sQLException) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_QUERY", new Object[0]), sQLException, 10552);
        }
    }

    @Override
    protected <ROW> ROW queryFirst_(StatementDescriptor statementDescriptor, HandlerContainer<?, ? extends ROW, ?> handlerContainer, Object ... objectArray) {
        ROW ROW = null;
        try {
            PreparedStatement preparedStatement = this.prepareStatementAndInvokeParameterHandler(statementDescriptor, handlerContainer, true, objectArray);
            ResultSet resultSet = null;
            resultSet = preparedStatement.executeQuery();
            RowHandler<? extends ROW> rowHandler = statementDescriptor.getRowHandler(handlerContainer);
            SingleResultHandler<ROW> singleResultHandler = rowHandler instanceof RowHandlerWithParameters ? new SingleResultHandler<ROW>(rowHandler, objectArray) : new SingleResultHandler<ROW>(rowHandler);
            ROW = singleResultHandler.handle(resultSet);
            return ROW;
        }
        catch (SQLException sQLException) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_QUERY", new Object[0]), sQLException, 10108);
        }
    }

    @Override
    protected <ROW> List<ROW> queryList_(StatementDescriptor statementDescriptor, HandlerContainer<?, ? extends ROW, ?> handlerContainer, Object ... objectArray) {
        Object object = null;
        try {
            PreparedStatement preparedStatement = this.prepareStatementAndInvokeParameterHandler(statementDescriptor, handlerContainer, true, objectArray);
            ResultSet resultSet = preparedStatement.executeQuery();
            ListResultHandler<ROW> listResultHandler = new ListResultHandler<ROW>(statementDescriptor.getRowHandler(handlerContainer));
            object = listResultHandler.handle(resultSet);
            return object;
        }
        catch (SQLException sQLException) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_QUERY", new Object[0]), sQLException, 10109);
        }
    }

    @Override
    protected ResultSet queryResults_(StatementDescriptor statementDescriptor, HandlerContainer<?, ?, ?> handlerContainer, Object ... objectArray) {
        try {
            PreparedStatement preparedStatement = this.prepareStatementAndInvokeParameterHandler(statementDescriptor, handlerContainer, true, objectArray);
            ResultSet resultSet = preparedStatement.executeQuery();
            return (ResultSet)ProxyCache.createInstance(resultSet, new PDQResultSetProxyHandler(resultSet, false));
        }
        catch (SQLException sQLException) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_QUERY", new Object[0]), sQLException, 10110);
        }
    }

    @Override
    protected <T> int[] updateMany_(StatementDescriptor statementDescriptor, HandlerContainer<?, ?, ?> handlerContainer, T[] TArray, Iterator<T> iterator, Iterable<T> iterable) {
        int[] nArray;
        Statement statement = null;
        int[] nArray2 = null;
        int n2 = 0;
        try {
            statement = this.getPreparedStatement(statementDescriptor.getProcessedSql(), statementDescriptor.getColumnNames(), statementDescriptor, false);
            n2 = TArray != null ? this.processBatchParametersForParameterHandlerForArray((PreparedStatement)statement, statementDescriptor, handlerContainer, TArray) : (iterable != null ? this.processBatchParametersForParameterHandlerForIterable((PreparedStatement)statement, statementDescriptor, handlerContainer, iterable) : this.processBatchParametersForParameterHandlerForIterator((PreparedStatement)statement, statementDescriptor, handlerContainer, iterator));
            if (this.isHeteroBatch_) {
                this.addToHeteroBatch((PreparedStatement)statement);
                statement = null;
                int[] nArray3 = zeroRowIntArray;
                return nArray3;
            }
            nArray = nArray2 = statement.executeBatch();
        }
        catch (BatchUpdateException batchUpdateException) {
            int[] nArray4 = this.fixUpdateCounts(batchUpdateException, n2);
            throw ExceptionFactory.createUpdateManyExceptionForRuntimeOnly(this, Messages.getText("ERR_UPD", new Object[0]), batchUpdateException, 10111, nArray4, null);
        }
        catch (SQLException sQLException) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_UPD", new Object[0]), sQLException, 10112);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return nArray;
    }

    @Override
    public void commit() {
        if (this.isHeteroBatch_) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_NOT_DURING_BATCH", "commit"), null, 10397);
        }
        try {
            this.connection_.commit();
        }
        catch (SQLException sQLException) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_TRANSACTION_COMMIT_FAILED", new Object[0]), sQLException, 10113);
        }
    }

    @Override
    public boolean getAutoCommit() {
        if (this.isHeteroBatch_) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_NOT_DURING_BATCH", "getAutoCommit"), null, 10396);
        }
        try {
            return this.connection_.getAutoCommit();
        }
        catch (SQLException sQLException) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_TRANSACTION_GETAUTOCOMMIT_FAILED", new Object[0]), sQLException, 10114);
        }
    }

    @Override
    public void rollback() {
        if (this.isHeteroBatch_) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_NOT_DURING_BATCH", "rollback"), null, 10395);
        }
        try {
            this.connection_.rollback();
        }
        catch (SQLException sQLException) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_TRANSACTION_ROLLBACK_FAILED", new Object[0]), sQLException, 10115);
        }
    }

    @Override
    public void setAutoCommit(boolean bl2) {
        if (this.isHeteroBatch_) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_NOT_DURING_BATCH", "setAutoCommit"), null, 10394);
        }
        try {
            this.connection_.setAutoCommit(bl2);
        }
        catch (SQLException sQLException) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_TRANSACTION_SETAUTOCOMMIT_FAILED", bl2), sQLException, 10116);
        }
    }

    private <T> int processBatchParametersForParameterHandlerForArray(PreparedStatement preparedStatement, StatementDescriptor statementDescriptor, HandlerContainer<?, ?, ?> handlerContainer, T[] TArray) throws SQLException {
        int n2 = 0;
        ParameterHandler parameterHandler = ((StatementDescriptorImpl)statementDescriptor).getParameterHandler(handlerContainer);
        if (parameterHandler != null) {
            for (int i10 = 0; i10 < TArray.length; ++i10) {
                parameterHandler.handleParameters(preparedStatement, TArray[i10]);
                preparedStatement.addBatch();
                ++n2;
            }
        } else {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, "UpdateMany must have a ParameterHandler", null, 10117);
        }
        return n2;
    }

    private <T> int processBatchParametersForParameterHandlerForIterable(PreparedStatement preparedStatement, StatementDescriptor statementDescriptor, HandlerContainer<?, ?, ?> handlerContainer, Iterable<T> iterable) throws SQLException {
        Iterator<T> iterator = iterable.iterator();
        return this.processBatchParametersForParameterHandlerForIterator(preparedStatement, statementDescriptor, handlerContainer, iterator);
    }

    private <T> int processBatchParametersForParameterHandlerForIterator(PreparedStatement preparedStatement, StatementDescriptor statementDescriptor, HandlerContainer<?, ?, ?> handlerContainer, Iterator<T> iterator) throws SQLException {
        int n2 = 0;
        ParameterHandler parameterHandler = ((StatementDescriptorImpl)statementDescriptor).getParameterHandler(handlerContainer);
        if (parameterHandler != null) {
            while (iterator.hasNext()) {
                T t2 = iterator.next();
                if (t2 instanceof Object[]) {
                    parameterHandler.handleParameters(preparedStatement, (Object[])t2);
                } else {
                    parameterHandler.handleParameters(preparedStatement, t2);
                }
                preparedStatement.addBatch();
                ++n2;
            }
        } else {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, "UpdateMany must have a ParameterHandler", null, 10118);
        }
        return n2;
    }

    @Override
    protected <CAL> CAL call_(CallHandler<CAL> callHandler, StatementDescriptorImpl statementDescriptorImpl, Object ... objectArray) {
        CallableStatement callableStatement = null;
        try {
            callableStatement = this.prepareCallStatement(statementDescriptorImpl, objectArray);
            statementDescriptorImpl.setCallHandler(callHandler);
            statementDescriptorImpl.getParameterHandlerForInline().handleParameters(callableStatement, objectArray);
            callableStatement.execute();
        }
        catch (SQLException sQLException) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_SP_CALL", new Object[0]), sQLException, 10655);
        }
        try {
            CAL CAL = callHandler.handleCall(callableStatement);
            return CAL;
        }
        catch (SQLException sQLException) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_SP_CALL_RESULTS", new Object[0]), sQLException, 10119);
        }
    }

    @Override
    protected <CAL> CAL call_(StatementDescriptorImpl statementDescriptorImpl, Object ... objectArray) {
        CallableStatement callableStatement = null;
        try {
            callableStatement = this.prepareCallStatement(statementDescriptorImpl, objectArray);
            statementDescriptorImpl.getParameterHandlerForInline().handleParameters(callableStatement, objectArray);
            callableStatement.execute();
        }
        catch (SQLException sQLException) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_SP_CALL", new Object[0]), sQLException, 10654);
        }
        try {
            if (null != objectArray && objectArray.length > 0) {
                return statementDescriptorImpl.getCallHandlerWithParameters(null).handleCall(callableStatement, this.expandParameterArrayWithStatementDescriptor(statementDescriptorImpl, objectArray));
            }
            return statementDescriptorImpl.getCallHandlerWithParameters(null).handleCall(callableStatement, statementDescriptorImpl);
        }
        catch (SQLException sQLException) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_SP_CALL_RESULTS", new Object[0]), sQLException, 10483);
        }
    }

    private Object[] expandParameterArrayWithStatementDescriptor(StatementDescriptor statementDescriptor, Object ... objectArray) {
        int n2 = objectArray.length;
        Object[] objectArray2 = new Object[n2 + 1];
        System.arraycopy(objectArray, 0, objectArray2, 0, n2);
        objectArray2[n2] = statementDescriptor;
        return objectArray2;
    }

    protected CallableStatement prepareCallStatement(StatementDescriptorImpl statementDescriptorImpl, Object ... objectArray) throws SQLException {
        CallableStatement callableStatement = null;
        String string = statementDescriptorImpl.getProcessedSql();
        if (!this.dbMetaData_.supportsResultSetHoldability(statementDescriptorImpl.getHoldability())) {
            this.storeMetadataCorrelatorForTransportToMonitorLayer(statementDescriptorImpl);
            callableStatement = this.connection_.prepareCall(string, statementDescriptorImpl.getType(), statementDescriptorImpl.getConcurrency());
        } else {
            this.storeMetadataCorrelatorForTransportToMonitorLayer(statementDescriptorImpl);
            callableStatement = this.connection_.prepareCall(string, statementDescriptorImpl.getType(), statementDescriptorImpl.getConcurrency(), statementDescriptorImpl.getHoldability());
        }
        this.applySQLSettingsToStatement(callableStatement);
        if (this.logger_.isLoggable(Level.FINEST)) {
            DataLogger.logInfo(dynamicLogger__, this, "DB2JdbcData prepareCallStatement (StatementDescriptorImpl, Object...)", "statementDescriptor, cstmt, parameters", statementDescriptorImpl, callableStatement, objectArray);
        }
        return callableStatement;
    }

    @Override
    protected <CAL> CAL call_(StatementDescriptor statementDescriptor, HandlerContainer<?, ?, ? extends CAL> handlerContainer, Object ... objectArray) {
        Object object;
        StatementDescriptorImpl statementDescriptorImpl = (StatementDescriptorImpl)statementDescriptor;
        CallableStatement callableStatement = null;
        try {
            callableStatement = this.prepareCallStatement(statementDescriptorImpl, objectArray);
            object = statementDescriptorImpl.getParameterHandler(handlerContainer);
            if (object != null) {
                object.handleParameters(callableStatement, objectArray);
            }
            callableStatement.execute();
        }
        catch (SQLException sQLException) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_SP_CALL", new Object[0]), sQLException, 10653);
        }
        try {
            object = statementDescriptorImpl.getCallHandler();
            if (object != null) {
                StoredProcedureResultImpl storedProcedureResultImpl = (StoredProcedureResultImpl)object;
                storedProcedureResultImpl.setStatementDescriptor(statementDescriptorImpl);
                storedProcedureResultImpl.setUserParameters(objectArray);
                storedProcedureResultImpl.setCallableStatement(callableStatement);
                return (CAL)object.handleCall(callableStatement);
            }
            CallHandlerWithParameters<CAL> callHandlerWithParameters = statementDescriptorImpl.getCallHandlerWithParameters(handlerContainer);
            if (callHandlerWithParameters != null) {
                return callHandlerWithParameters.handleCall(callableStatement, objectArray);
            }
        }
        catch (SQLException sQLException) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_SP_CALL_RESULTS", new Object[0]), sQLException, 10121);
        }
        return null;
    }

    protected <ROW> int executeStatementForAutogeneratedKeysAndSetValues(PreparedStatement preparedStatement, ROW ROW, StatementDescriptor statementDescriptor, HandlerContainer<?, ? extends ROW, ?> handlerContainer) throws SQLException {
        ResultSet resultSet;
        int n2 = preparedStatement.executeUpdate();
        if (!this.ignoreAGK_ && (resultSet = preparedStatement.getGeneratedKeys()).next()) {
            RowHandler<ROW> rowHandler = statementDescriptor.getRowHandler(handlerContainer);
            rowHandler.handle(resultSet, ROW);
        }
        return n2;
    }

    @Override
    protected StatementDescriptorImpl buildInlineStatementDescriptor_(String string, int[] nArray, String string2, String[] stringArray, ParameterHandler parameterHandler, ResultHandler resultHandler, CallHandlerWithParameters callHandlerWithParameters, Object ... objectArray) {
        String string3 = this.checkIfOverrideExists(string2);
        StatementDescriptorImpl statementDescriptorImpl = new StatementDescriptorImpl(string, nArray, string3, null, stringArray, parameterHandler, resultHandler, callHandlerWithParameters);
        this.processSql(statementDescriptorImpl, objectArray);
        return statementDescriptorImpl;
    }

    protected String checkIfOverrideExists(String string) {
        String string2;
        if (this.sqlOverrides_ != null && null != (string2 = (String)this.sqlOverrides_.get(string))) {
            return string2;
        }
        return string;
    }

    protected void processSql(StatementDescriptorImpl statementDescriptorImpl, Object ... objectArray) {
        SqlStatementType sqlStatementType;
        int n2;
        String string;
        String string2 = string = statementDescriptorImpl.getOriginalSql();
        int n3 = n2 = null != objectArray ? objectArray.length : 0;
        if (this.logger_.isLoggable(Level.FINER)) {
            DataLogger.sqlOriginal(this.logger_, this, "processSql", string);
        }
        if (0 == n2) {
            try {
                EscapeLexer escapeLexer = new EscapeLexer(string);
                sqlStatementType = escapeLexer.parseSqlAndGetSqlType();
            }
            catch (DataSQLException dataSQLException) {
                throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_PARSE_SQL", string), dataSQLException, 10772);
            }
        }
        ParameterInfoArray parameterInfoArray = ParameterInformationCache.getParameterInformation(string);
        if (parameterInfoArray == null) {
            parameterInfoArray = new ParameterInfoArray();
            statementDescriptorImpl.setMethodInfoArray(parameterInfoArray);
            try {
                EscapeLexer escapeLexer = new EscapeLexer(string);
                string2 = escapeLexer.parseSql(statementDescriptorImpl.getMethodInfoArray(), n2);
                sqlStatementType = statementDescriptorImpl.getMethodInfoArray().getSqlStatementType();
            }
            catch (DataSQLException dataSQLException) {
                throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_PARSE_SQL", string), dataSQLException, 10266);
            }
            ParameterInformationCache.addToParameterInformationMap(string, parameterInfoArray);
        } else {
            string2 = parameterInfoArray.getProcessedSql();
            statementDescriptorImpl.setMethodInfoArray(parameterInfoArray);
            sqlStatementType = parameterInfoArray.getSqlStatementType();
        }
        statementDescriptorImpl.setDynamicSQL(string2);
        statementDescriptorImpl.setSqlStatementType(sqlStatementType);
    }

    @Override
    protected <T> int[] updateManyHeterogeneous_(String ... stringArray) {
        int[] nArray = null;
        String string = null;
        Statement statement = null;
        if (stringArray == null) {
            throw ExceptionFactory.createUpdateManyExceptionForRuntimeOnly(this, Messages.getText("ERR_NO_SQL", new Object[0]), null, 10233, new int[0], null);
        }
        try {
            string = "createStatement";
            statement = this.connection_.createStatement();
            string = "addBatch";
            for (String string2 : stringArray) {
                statement.addBatch(string2);
            }
            string = "executeBatch";
            nArray = statement.executeBatch();
        }
        catch (BatchUpdateException batchUpdateException) {
            int n2 = stringArray.length;
            nArray = this.fixUpdateCounts(batchUpdateException, n2);
            throw ExceptionFactory.createUpdateManyExceptionForRuntimeOnly(this, Messages.getText("ERR_HETEROGENEOUS_BATCH", string), batchUpdateException, 10234, nArray, null);
        }
        catch (SQLException sQLException) {
            throw ExceptionFactory.createUpdateManyExceptionForRuntimeOnly(this, Messages.getText("ERR_HETEROGENEOUS_BATCH", string), sQLException, 10235, new int[0], null);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return nArray;
    }

    public <T> T endBatch(BatchHandler<T> batchHandler) {
        throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_METHOD_NOT_SUP", "endBatch (BatchHandler<T> batchHandler)"), null, 10370);
    }

    protected void addToHeteroBatch(PreparedStatement preparedStatement) {
    }

    protected boolean registerCallbackIfHeteroBatch() {
        return false;
    }

    protected void deregisterCallbackIfHeteroBatch() {
    }

    protected void chkCallbackTriggered(PreparedStatement preparedStatement) throws SQLException {
    }

    @Override
    public int[][] endBatch() {
        throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_BATCH_ONLY_JCC_AND_ALLOWED_DATABASES", new Object[0]), null, 10371);
    }

    @Override
    public HeterogeneousBatchKind getBatchKind() {
        return HeterogeneousBatchKind.heterogeneousNone__;
    }

    @Override
    public void startBatch(HeterogeneousBatchKind heterogeneousBatchKind) {
        throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_BATCH_ONLY_JCC_AND_ALLOWED_DATABASES", new Object[0]), null, 10372);
    }

    @Override
    public void cancelBatch() {
        throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_BATCH_ONLY_JCC_AND_ALLOWED_DATABASES", new Object[0]), null, 11270);
    }

    public void applySQLSettingsToStatement(Statement statement) {
        if (null != statement) {
            try {
                if (null != this.queryTimeout_) {
                    statement.setQueryTimeout(this.queryTimeout_);
                }
            }
            catch (SQLException sQLException) {
                throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_CANNOT_SET_QUERY_TIMEOUT", this.queryTimeout_), sQLException, 10515);
            }
            try {
                if (null != this.maxRows_) {
                    statement.setMaxRows(this.maxRows_);
                }
            }
            catch (SQLException sQLException) {
                throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_CANNOT_SET_MAX_ROWS", this.maxRows_), sQLException, 10516);
            }
        }
    }

    protected void storeMetadataCorrelatorForTransportToMonitorLayer(StatementDescriptorImpl statementDescriptorImpl) {
    }

    public static enum InputParameterType {
        INPUT_PARAMETERS_IN_METHOD_SIGNATURE,
        INPUT_PARAMETERS_AS_OBJECT_MAP,
        INPUT_PARAMETERS_AS_OBJECT_ARRAY_OR_SIMPLE_PARAMETER,
        INPUT_PARAMETERS_AS_BEAN;

    }
}

