\name{RealToHalfHermitianForwardFFTImageFilter}
\alias{RealToHalfHermitianForwardFFTImageFilter}
\title{RealToHalfHermitianForwardFFTImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Base class for specialized real-to-complex forward Fast Fourier Transform .
RealToHalfHermitianForwardFFTImageFilter}
\details{
This is a base class for the "forward" or "direct" discrete
Fourier Transform . This is an abstract base class: the actual implementation is
provided by the best child class available on the system when the
object is created via the object factory system.
This class transforms a real input image into its complex Fourier
transform. The Fourier transform of a real input image has Hermitian
symmetry: \eqn{ f(\mathbf{x}) = f^*(-\mathbf{x}) } . That is, when the result of the transform is split in half along
the X-dimension, the values in the second half of the transform are
the complex conjugates of values in the first half reflected about the
center of the image in each dimension. This filter takes advantage of
the Hermitian symmetry property and reduces the size of the output in
the first dimension to N/2+1, where N is the size of the input image
in that dimension and the division by 2 is rounded down.
See:
HalfHermitianToRealInverseFFTImageFilter
ForwardFFTImageFilter
RealToHalfHermitianForwardFFT for the procedural interface
itk::RealToHalfHermitianForwardFFTImageFilter for the Doxygen on the original ITK class.
RealToHalfHermitianForwardFFTImageFilter}
%C++ includes: sitkRealToHalfHermitianForwardFFTImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{std::string GetName() const:}{
Name of this class
}
\item{ RealToHalfHermitianForwardFFTImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~RealToHalfHermitianForwardFFTImageFilter():}{
Destructor
}
}
}
