/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.hashing;

import com.dynatrace.hash4j.hashing.AbstractHashStream64;
import com.dynatrace.hash4j.hashing.AbstractHasher64;
import com.dynatrace.hash4j.hashing.ByteAccess;
import com.dynatrace.hash4j.hashing.HashStream64;
import com.dynatrace.hash4j.internal.ByteArrayUtil;

abstract class AbstractFarmHash
implements AbstractHasher64 {
    protected static final long K0 = -4348849565147123417L;
    protected static final long K1 = -5435081209227447693L;
    protected static final long K2 = -7286425919675154353L;
    protected static final long K_MUL = -7070675565921424023L;

    AbstractFarmHash() {
    }

    protected static final long shiftMix(long val) {
        return val ^ val >>> 47;
    }

    protected static final long hashLen16(long u, long v, long mul) {
        long a = AbstractFarmHash.shiftMix((u ^ v) * mul);
        return AbstractFarmHash.shiftMix((v ^ a) * mul) * mul;
    }

    protected static final long mul(int bufferCount) {
        return -7286425919675154369L + (long)(bufferCount << 1);
    }

    protected static final long hash1To3Bytes(int bufferCount, int firstByte, int midOrLastByte, int lastByte) {
        int y = firstByte + (midOrLastByte << 8);
        int z = bufferCount - 8 + (lastByte << 2);
        return AbstractFarmHash.shiftMix((long)y * -7286425919675154353L ^ (long)z * -4348849565147123417L) * -7286425919675154353L;
    }

    protected static final long hash4To7Bytes(int bufferCount, long first4Bytes, long last4Bytes) {
        long mul = AbstractFarmHash.mul(bufferCount);
        return AbstractFarmHash.hashLen16((long)(bufferCount - 8) + (first4Bytes << 3), last4Bytes, mul);
    }

    protected static final long hash8To16Bytes(int bufferCount, long first8Bytes, long last8Bytes) {
        long mul = AbstractFarmHash.mul(bufferCount);
        long a = first8Bytes + -7286425919675154353L;
        long c = Long.rotateRight(last8Bytes, 37) * mul + a;
        long d = (Long.rotateRight(a, 25) + last8Bytes) * mul;
        return AbstractFarmHash.hashLen16(c, d, mul);
    }

    @Override
    public long hashBytesToLong(byte[] input, int off, int len) {
        if (len <= 32) {
            if (len <= 16) {
                return this.finalizeHash(AbstractFarmHash.hashBytesToLongLength0to16(input, off, len));
            }
            return this.finalizeHash(AbstractFarmHash.hashBytesToLongLength17to32(input, off, len));
        }
        if (len <= 64) {
            return this.finalizeHash(AbstractFarmHash.hashBytesToLongLength33To64(input, off, len));
        }
        return this.hashBytesToLongLength65Plus(input, off, len);
    }

    @Override
    public <T> long hashBytesToLong(T input, long off, long len, ByteAccess<T> access) {
        if (len <= 32L) {
            if (len <= 16L) {
                return this.finalizeHash(AbstractFarmHash.hashBytesToLongLength0to16(input, off, len, access));
            }
            return this.finalizeHash(AbstractFarmHash.hashBytesToLongLength17to32(input, off, len, access));
        }
        if (len <= 64L) {
            return this.finalizeHash(AbstractFarmHash.hashBytesToLongLength33To64(input, off, len, access));
        }
        return this.hashBytesToLongLength65Plus(input, off, len, access);
    }

    protected abstract long hashBytesToLongLength65Plus(byte[] var1, int var2, int var3);

    protected abstract <T> long hashBytesToLongLength65Plus(T var1, long var2, long var4, ByteAccess<T> var6);

    protected long finalizeHash(long hash) {
        return hash;
    }

    private static long hashBytesToLongLength0to16(byte[] input, int off, int len) {
        if (len >= 8) {
            long mul = -7286425919675154353L + (long)(len << 1);
            long a = ByteArrayUtil.getLong(input, off) + -7286425919675154353L;
            long b = ByteArrayUtil.getLong(input, off + len - 8);
            long c = Long.rotateRight(b, 37) * mul + a;
            long d = (Long.rotateRight(a, 25) + b) * mul;
            return AbstractFarmHash.hashLength16(c, d, mul);
        }
        if (len >= 4) {
            long mul = -7286425919675154353L + (long)(len << 1);
            long a = (long)ByteArrayUtil.getInt(input, off) & 0xFFFFFFFFL;
            return AbstractFarmHash.hashLength16((long)len + (a << 3), (long)ByteArrayUtil.getInt(input, off + len - 4) & 0xFFFFFFFFL, mul);
        }
        if (len > 0) {
            int a = input[off] & 0xFF;
            int b = input[off + (len >> 1)] & 0xFF;
            int c = input[off + (len - 1)] & 0xFF;
            int y = a + (b << 8);
            int z = len + (c << 2);
            return AbstractFarmHash.shiftMix((long)y * -7286425919675154353L ^ (long)z * -4348849565147123417L) * -7286425919675154353L;
        }
        return -7286425919675154353L;
    }

    private static <T> long hashBytesToLongLength0to16(T input, long off, long len, ByteAccess<T> access) {
        if (len >= 8L) {
            long mul = -7286425919675154353L + (len << 1);
            long a = access.getLong(input, off) + -7286425919675154353L;
            long b = access.getLong(input, off + len - 8L);
            long c = Long.rotateRight(b, 37) * mul + a;
            long d = (Long.rotateRight(a, 25) + b) * mul;
            return AbstractFarmHash.hashLength16(c, d, mul);
        }
        if (len >= 4L) {
            long mul = -7286425919675154353L + (len << 1);
            long a = access.getIntAsUnsignedLong(input, off);
            return AbstractFarmHash.hashLength16(len + (a << 3), access.getIntAsUnsignedLong(input, off + len - 4L), mul);
        }
        if (len > 0L) {
            int a = access.getByteAsUnsignedInt(input, off);
            int b = access.getByteAsUnsignedInt(input, off + (len >> 1));
            int c = access.getByteAsUnsignedInt(input, off + (len - 1L));
            int y = a + (b << 8);
            long z = len + (long)(c << 2);
            return AbstractFarmHash.shiftMix((long)y * -7286425919675154353L ^ z * -4348849565147123417L) * -7286425919675154353L;
        }
        return -7286425919675154353L;
    }

    private static long hashCharsToLongLength0to8(CharSequence input) {
        int len = input.length();
        if (len >= 4) {
            long mul = -7286425919675154353L + (long)(len << 2);
            long b = ByteArrayUtil.getLong(input, 0);
            long a = b + -7286425919675154353L;
            if (len >= 5) {
                b >>>= 16;
                b |= (long)input.charAt(4) << 48;
                if (len >= 6) {
                    b >>>= 16;
                    b |= (long)input.charAt(5) << 48;
                    if (len >= 7) {
                        b >>>= 16;
                        b |= (long)input.charAt(6) << 48;
                        if (len >= 8) {
                            b >>>= 16;
                            b |= (long)input.charAt(7) << 48;
                        }
                    }
                }
            }
            long c = Long.rotateRight(b, 37) * mul + a;
            long d = (Long.rotateRight(a, 25) + b) * mul;
            return AbstractFarmHash.hashLength16(c, d, mul);
        }
        if (len >= 2) {
            long a;
            long mul = -7286425919675154353L + (long)(len << 2);
            long b = a = (long)ByteArrayUtil.getInt(input, 0) & 0xFFFFFFFFL;
            if (len >= 3) {
                b >>>= 16;
                b |= (long)input.charAt(2) << 16;
            }
            return AbstractFarmHash.hashLength16((long)(len << 1) + (a << 3), b, mul);
        }
        if (len >= 1) {
            char y = input.charAt(0);
            int z = (len << 1) + (y >>> 8 << 2);
            return AbstractFarmHash.shiftMix((long)y * -7286425919675154353L ^ (long)z * -4348849565147123417L) * -7286425919675154353L;
        }
        return -7286425919675154353L;
    }

    private static long hashBytesToLongLength17to32(byte[] input, int off, int len) {
        long mul = -7286425919675154353L + (long)(len << 1);
        long a = ByteArrayUtil.getLong(input, off) * -5435081209227447693L;
        long b = ByteArrayUtil.getLong(input, off + 8);
        long c = ByteArrayUtil.getLong(input, off + len - 8) * mul;
        long d = ByteArrayUtil.getLong(input, off + len - 16) * -7286425919675154353L;
        return AbstractFarmHash.hashLength16(Long.rotateRight(a + b, 43) + Long.rotateRight(c, 30) + d, a + Long.rotateRight(b + -7286425919675154353L, 18) + c, mul);
    }

    private static <T> long hashBytesToLongLength17to32(T input, long off, long len, ByteAccess<T> access) {
        long mul = -7286425919675154353L + (len << 1);
        long a = access.getLong(input, off) * -5435081209227447693L;
        long b = access.getLong(input, off + 8L);
        long c = access.getLong(input, off + len - 8L) * mul;
        long d = access.getLong(input, off + len - 16L) * -7286425919675154353L;
        return AbstractFarmHash.hashLength16(Long.rotateRight(a + b, 43) + Long.rotateRight(c, 30) + d, a + Long.rotateRight(b + -7286425919675154353L, 18) + c, mul);
    }

    private static long hashCharsToLongLength9to16(CharSequence input) {
        int len = input.length();
        long mul = -7286425919675154353L + (long)(len << 2);
        long a = ByteArrayUtil.getLong(input, 0) * -5435081209227447693L;
        long b = ByteArrayUtil.getLong(input, 4);
        long c = ByteArrayUtil.getLong(input, len - 4) * mul;
        long d = ByteArrayUtil.getLong(input, len - 8) * -7286425919675154353L;
        return AbstractFarmHash.hashLength16(Long.rotateRight(a + b, 43) + Long.rotateRight(c, 30) + d, a + Long.rotateRight(b + -7286425919675154353L, 18) + c, mul);
    }

    private static long hashBytesToLongLength33To64(byte[] input, int off, int len) {
        long mul = -7286425919675154353L + (long)(len << 1);
        long a = ByteArrayUtil.getLong(input, off) * -7286425919675154353L;
        long b = ByteArrayUtil.getLong(input, off + 8);
        long c = ByteArrayUtil.getLong(input, off + len - 8) * mul;
        long d = ByteArrayUtil.getLong(input, off + len - 16) * -7286425919675154353L;
        long y = Long.rotateRight(a + b, 43) + Long.rotateRight(c, 30) + d;
        long z = AbstractFarmHash.hashLength16(y, a + Long.rotateRight(b + -7286425919675154353L, 18) + c, mul);
        long e = ByteArrayUtil.getLong(input, off + 16) * mul;
        long f = ByteArrayUtil.getLong(input, off + 24);
        long g = (y + ByteArrayUtil.getLong(input, off + len - 32)) * mul;
        long h = (z + ByteArrayUtil.getLong(input, off + len - 24)) * mul;
        return AbstractFarmHash.hashLength16(Long.rotateRight(e + f, 43) + Long.rotateRight(g, 30) + h, e + Long.rotateRight(f + a, 18) + g, mul);
    }

    private static <T> long hashBytesToLongLength33To64(T input, long off, long len, ByteAccess<T> access) {
        long mul = -7286425919675154353L + (len << 1);
        long a = access.getLong(input, off) * -7286425919675154353L;
        long b = access.getLong(input, off + 8L);
        long c = access.getLong(input, off + len - 8L) * mul;
        long d = access.getLong(input, off + len - 16L) * -7286425919675154353L;
        long y = Long.rotateRight(a + b, 43) + Long.rotateRight(c, 30) + d;
        long z = AbstractFarmHash.hashLength16(y, a + Long.rotateRight(b + -7286425919675154353L, 18) + c, mul);
        long e = access.getLong(input, off + 16L) * mul;
        long f = access.getLong(input, off + 24L);
        long g = (y + access.getLong(input, off + len - 32L)) * mul;
        long h = (z + access.getLong(input, off + len - 24L)) * mul;
        return AbstractFarmHash.hashLength16(Long.rotateRight(e + f, 43) + Long.rotateRight(g, 30) + h, e + Long.rotateRight(f + a, 18) + g, mul);
    }

    private static long hashCharsToLongLength17To32(CharSequence input) {
        int len = input.length();
        long mul = -7286425919675154353L + (long)(len << 2);
        long a = ByteArrayUtil.getLong(input, 0) * -7286425919675154353L;
        long b = ByteArrayUtil.getLong(input, 4);
        long c = ByteArrayUtil.getLong(input, len - 4) * mul;
        long d = ByteArrayUtil.getLong(input, len - 8) * -7286425919675154353L;
        long y = Long.rotateRight(a + b, 43) + Long.rotateRight(c, 30) + d;
        long z = AbstractFarmHash.hashLength16(y, a + Long.rotateRight(b + -7286425919675154353L, 18) + c, mul);
        long e = ByteArrayUtil.getLong(input, 8) * mul;
        long f = ByteArrayUtil.getLong(input, 12);
        long g = (y + ByteArrayUtil.getLong(input, len - 16)) * mul;
        long h = (z + ByteArrayUtil.getLong(input, len - 12)) * mul;
        return AbstractFarmHash.hashLength16(Long.rotateRight(e + f, 43) + Long.rotateRight(g, 30) + h, e + Long.rotateRight(f + a, 18) + g, mul);
    }

    private static long hashLength16(long u, long v, long mul) {
        long a = (u ^ v) * mul;
        a ^= a >>> 47;
        long b = (v ^ a) * mul;
        b ^= b >>> 47;
        return b *= mul;
    }

    @Override
    public final long hashCharsToLong(CharSequence input) {
        long len = input.length();
        if (len <= 16L) {
            if (len <= 8L) {
                return this.finalizeHash(AbstractFarmHash.hashCharsToLongLength0to8(input));
            }
            return this.finalizeHash(AbstractFarmHash.hashCharsToLongLength9to16(input));
        }
        if (len <= 32L) {
            return this.finalizeHash(AbstractFarmHash.hashCharsToLongLength17To32(input));
        }
        return this.hashCharsToLongLength33Plus(input);
    }

    protected abstract long hashCharsToLongLength33Plus(CharSequence var1);

    @Override
    public long hashIntToLong(int v) {
        long a = (long)v & 0xFFFFFFFFL;
        return this.finalizeHash(AbstractFarmHash.hashLength16(4L + (a << 3), a, -7286425919675154345L));
    }

    @Override
    public long hashIntIntIntToLong(int v1, int v2, int v3) {
        return this.finish12Bytes(((long)v1 & 0xFFFFFFFFL) + ((long)v2 << 32), ((long)v2 & 0xFFFFFFFFL) + ((long)v3 << 32));
    }

    @Override
    public long hashIntLongToLong(int v1, long v2) {
        return this.finish12Bytes(((long)v1 & 0xFFFFFFFFL) + (v2 << 32), v2);
    }

    @Override
    public long hashLongToLong(long v) {
        long mul = -7286425919675154337L;
        long a = -7286425919675154353L + v;
        long c = Long.rotateRight(v, 37) * mul + a;
        long d = (Long.rotateRight(a, 25) + v) * mul;
        return this.finalizeHash(AbstractFarmHash.hashLength16(c, d, mul));
    }

    @Override
    public final long hashLongLongToLong(long v1, long v2) {
        long mul = -7286425919675154321L;
        long a = v1 + -7286425919675154353L;
        return this.finalizeHash(AbstractFarmHash.hashLength16(Long.rotateRight(v2, 37) * mul + a, (Long.rotateRight(a, 25) + v2) * mul, mul));
    }

    @Override
    public final long hashLongLongLongToLong(long v1, long v2, long v3) {
        long mul = -7286425919675154305L;
        long a = v1 * -5435081209227447693L;
        long c = v3 * mul;
        return this.finalizeHash(AbstractFarmHash.hashLength16(Long.rotateRight(a + v2, 43) + Long.rotateRight(c, 30) + v2 * -7286425919675154353L, a + Long.rotateRight(v2 + -7286425919675154353L, 18) + c, mul));
    }

    @Override
    public long hashLongIntToLong(long v1, int v2) {
        return this.finish12Bytes(v1, v1 >>> 32 | (long)v2 << 32);
    }

    private long finish12Bytes(long a, long b) {
        long mul = -7286425919675154329L;
        long c = Long.rotateRight(b, 37) * mul + (a += -7286425919675154353L);
        long d = (Long.rotateRight(a, 25) + b) * mul;
        return this.finalizeHash(AbstractFarmHash.hashLength16(c, d, mul));
    }

    protected static abstract class FarmHashStreamImpl
    implements AbstractHashStream64 {
        protected final byte[] buffer = new byte[80];
        protected int bufferCount = 8;
        protected boolean init = true;

        protected FarmHashStreamImpl() {
        }

        protected abstract void processBuffer(long var1, long var3, long var5, long var7, long var9, long var11, long var13, long var15);

        private void processBuffer() {
            long b0 = ByteArrayUtil.getLong(this.buffer, 8);
            long b1 = ByteArrayUtil.getLong(this.buffer, 16);
            long b2 = ByteArrayUtil.getLong(this.buffer, 24);
            long b3 = ByteArrayUtil.getLong(this.buffer, 32);
            long b4 = ByteArrayUtil.getLong(this.buffer, 40);
            long b5 = ByteArrayUtil.getLong(this.buffer, 48);
            long b6 = ByteArrayUtil.getLong(this.buffer, 56);
            long b7 = ByteArrayUtil.getLong(this.buffer, 64);
            this.processBuffer(b0, b1, b2, b3, b4, b5, b6, b7);
        }

        @Override
        public final HashStream64 putByte(byte v) {
            if (this.bufferCount >= 72) {
                this.processBuffer();
                this.bufferCount = 8;
            }
            this.buffer[this.bufferCount] = v;
            ++this.bufferCount;
            return this;
        }

        @Override
        public final HashStream64 putShort(short v) {
            ByteArrayUtil.setShort(this.buffer, this.bufferCount, v);
            if (this.bufferCount >= 71) {
                this.processBuffer();
                this.bufferCount -= 64;
                ByteArrayUtil.setShort(this.buffer, this.bufferCount, v);
            }
            this.bufferCount += 2;
            return this;
        }

        @Override
        public final HashStream64 putChar(char v) {
            ByteArrayUtil.setChar(this.buffer, this.bufferCount, v);
            if (this.bufferCount >= 71) {
                this.processBuffer();
                this.bufferCount -= 64;
                ByteArrayUtil.setChar(this.buffer, this.bufferCount, v);
            }
            this.bufferCount += 2;
            return this;
        }

        @Override
        public final HashStream64 putInt(int v) {
            ByteArrayUtil.setInt(this.buffer, this.bufferCount, v);
            if (this.bufferCount >= 69) {
                this.processBuffer();
                this.bufferCount -= 64;
                ByteArrayUtil.setInt(this.buffer, this.bufferCount, v);
            }
            this.bufferCount += 4;
            return this;
        }

        @Override
        public final HashStream64 putLong(long v) {
            ByteArrayUtil.setLong(this.buffer, this.bufferCount, v);
            if (this.bufferCount >= 65) {
                this.processBuffer();
                this.bufferCount -= 64;
                ByteArrayUtil.setLong(this.buffer, this.bufferCount, v);
            }
            this.bufferCount += 8;
            return this;
        }

        @Override
        public final HashStream64 putBytes(byte[] b, int off, int len) {
            int regularBlockStartIdx = 8 - this.bufferCount & 0x3F;
            int regularBlockEndIdx = len - 64 + (-len + regularBlockStartIdx & 0x3F);
            if (regularBlockEndIdx < regularBlockStartIdx) {
                System.arraycopy(b, off, this.buffer, this.bufferCount, len);
                this.bufferCount += len;
                return this;
            }
            System.arraycopy(b, off, this.buffer, this.bufferCount, regularBlockStartIdx);
            if (this.bufferCount > 8) {
                long b0 = ByteArrayUtil.getLong(this.buffer, 8);
                long b1 = ByteArrayUtil.getLong(this.buffer, 16);
                long b2 = ByteArrayUtil.getLong(this.buffer, 24);
                long b3 = ByteArrayUtil.getLong(this.buffer, 32);
                long b4 = ByteArrayUtil.getLong(this.buffer, 40);
                long b5 = ByteArrayUtil.getLong(this.buffer, 48);
                long b6 = ByteArrayUtil.getLong(this.buffer, 56);
                long b7 = ByteArrayUtil.getLong(this.buffer, 64);
                this.processBuffer(b0, b1, b2, b3, b4, b5, b6, b7);
            }
            int remainingBytes = len - regularBlockEndIdx;
            this.bufferCount = 8 + remainingBytes;
            if (regularBlockEndIdx > regularBlockStartIdx) {
                for (int i = off + regularBlockStartIdx; i < off + regularBlockEndIdx; i += 64) {
                    long b0 = ByteArrayUtil.getLong(b, i);
                    long b1 = ByteArrayUtil.getLong(b, i + 8);
                    long b2 = ByteArrayUtil.getLong(b, i + 16);
                    long b3 = ByteArrayUtil.getLong(b, i + 24);
                    long b4 = ByteArrayUtil.getLong(b, i + 32);
                    long b5 = ByteArrayUtil.getLong(b, i + 40);
                    long b6 = ByteArrayUtil.getLong(b, i + 48);
                    long b7 = ByteArrayUtil.getLong(b, i + 56);
                    this.processBuffer(b0, b1, b2, b3, b4, b5, b6, b7);
                }
                System.arraycopy(b, off - 64 + len, this.buffer, this.bufferCount, 64 - remainingBytes);
            }
            System.arraycopy(b, off + regularBlockEndIdx, this.buffer, 8, remainingBytes);
            return this;
        }

        @Override
        public final <T> HashStream64 putBytes(T b, long off, long len, ByteAccess<T> access) {
            int regularBlockStartIdx = 8 - this.bufferCount & 0x3F;
            long regularBlockEndIdx = len - 64L + (-len + (long)regularBlockStartIdx & 0x3FL);
            if (regularBlockEndIdx < (long)regularBlockStartIdx) {
                access.copyToByteArray(b, off, this.buffer, this.bufferCount, (int)len);
                this.bufferCount += (int)len;
                return this;
            }
            access.copyToByteArray(b, off, this.buffer, this.bufferCount, regularBlockStartIdx);
            if (this.bufferCount > 8) {
                long b0 = ByteArrayUtil.getLong(this.buffer, 8);
                long b1 = ByteArrayUtil.getLong(this.buffer, 16);
                long b2 = ByteArrayUtil.getLong(this.buffer, 24);
                long b3 = ByteArrayUtil.getLong(this.buffer, 32);
                long b4 = ByteArrayUtil.getLong(this.buffer, 40);
                long b5 = ByteArrayUtil.getLong(this.buffer, 48);
                long b6 = ByteArrayUtil.getLong(this.buffer, 56);
                long b7 = ByteArrayUtil.getLong(this.buffer, 64);
                this.processBuffer(b0, b1, b2, b3, b4, b5, b6, b7);
            }
            int remainingBytes = (int)(len - regularBlockEndIdx);
            this.bufferCount = 8 + remainingBytes;
            if (regularBlockEndIdx > (long)regularBlockStartIdx) {
                for (long i = off + (long)regularBlockStartIdx; i < off + regularBlockEndIdx; i += 64L) {
                    long b0 = access.getLong(b, i);
                    long b1 = access.getLong(b, i + 8L);
                    long b2 = access.getLong(b, i + 16L);
                    long b3 = access.getLong(b, i + 24L);
                    long b4 = access.getLong(b, i + 32L);
                    long b5 = access.getLong(b, i + 40L);
                    long b6 = access.getLong(b, i + 48L);
                    long b7 = access.getLong(b, i + 56L);
                    this.processBuffer(b0, b1, b2, b3, b4, b5, b6, b7);
                }
                access.copyToByteArray(b, off - 64L + len, this.buffer, this.bufferCount, 64 - remainingBytes);
            }
            access.copyToByteArray(b, off + regularBlockEndIdx, this.buffer, 8, remainingBytes);
            return this;
        }

        @Override
        public final HashStream64 putChars(CharSequence s) {
            int idx = 0;
            if (s.length() >= 74 - this.bufferCount >> 1) {
                if (this.bufferCount > 9) {
                    idx = 73 - this.bufferCount >>> 1;
                    ByteArrayUtil.copyCharsToByteArray(s, 0, this.buffer, this.bufferCount, idx);
                    this.processBuffer();
                    this.buffer[8] = this.buffer[72];
                }
                int a = this.bufferCount & 1;
                int lim = s.length() - 32 + a;
                if (idx < lim) {
                    long b7;
                    long b6;
                    long b5;
                    long b4;
                    long b3;
                    long b2;
                    long b1;
                    long b0;
                    long bm = a != 0 ? (long)this.buffer[8] << 56 : 0L;
                    do {
                        b0 = ByteArrayUtil.getLong(s, idx);
                        b1 = ByteArrayUtil.getLong(s, idx + 4);
                        b2 = ByteArrayUtil.getLong(s, idx + 8);
                        b3 = ByteArrayUtil.getLong(s, idx + 12);
                        b4 = ByteArrayUtil.getLong(s, idx + 16);
                        b5 = ByteArrayUtil.getLong(s, idx + 20);
                        b6 = ByteArrayUtil.getLong(s, idx + 24);
                        b7 = ByteArrayUtil.getLong(s, idx + 28);
                        if (a != 0) {
                            long bmNew = b7;
                            b7 = b7 << 8 | b6 >>> 56;
                            b6 = b6 << 8 | b5 >>> 56;
                            b5 = b5 << 8 | b4 >>> 56;
                            b4 = b4 << 8 | b3 >>> 56;
                            b3 = b3 << 8 | b2 >>> 56;
                            b2 = b2 << 8 | b1 >>> 56;
                            b1 = b1 << 8 | b0 >>> 56;
                            b0 = b0 << 8 | bm >>> 56;
                            bm = bmNew;
                        }
                        this.processBuffer(b0, b1, b2, b3, b4, b5, b6, b7);
                    } while ((idx += 32) < lim);
                    ByteArrayUtil.setLong(this.buffer, 8, b0);
                    ByteArrayUtil.setLong(this.buffer, 16, b1);
                    ByteArrayUtil.setLong(this.buffer, 24, b2);
                    ByteArrayUtil.setLong(this.buffer, 32, b3);
                    ByteArrayUtil.setLong(this.buffer, 40, b4);
                    ByteArrayUtil.setLong(this.buffer, 48, b5);
                    ByteArrayUtil.setLong(this.buffer, 56, b6);
                    ByteArrayUtil.setLong(this.buffer, 64, b7);
                    if (a != 0) {
                        this.buffer[8] = (byte)(bm >>> 56);
                    }
                }
                this.bufferCount = 8 + a;
            }
            ByteArrayUtil.copyCharsToByteArray(s, idx, this.buffer, this.bufferCount, s.length() - idx);
            this.bufferCount += s.length() - idx << 1;
            return this;
        }

        protected final long hashLen0To16(int bufferCount) {
            if (bufferCount >= 16) {
                long a = ByteArrayUtil.getLong(this.buffer, 8);
                long b = ByteArrayUtil.getLong(this.buffer, bufferCount - 8);
                return AbstractFarmHash.hash8To16Bytes(bufferCount, a, b);
            }
            if (bufferCount >= 12) {
                long a = (long)ByteArrayUtil.getInt(this.buffer, 8) & 0xFFFFFFFFL;
                long b = (long)ByteArrayUtil.getInt(this.buffer, bufferCount - 4) & 0xFFFFFFFFL;
                return AbstractFarmHash.hash4To7Bytes(bufferCount, a, b);
            }
            if (bufferCount > 8) {
                int a = this.buffer[8] & 0xFF;
                int b = this.buffer[(bufferCount >>> 1) + 4] & 0xFF;
                int c = this.buffer[bufferCount - 1] & 0xFF;
                return AbstractFarmHash.hash1To3Bytes(bufferCount, a, b, c);
            }
            return -7286425919675154353L;
        }

        protected final long hashLen17To32(int bufferCount) {
            long mul = AbstractFarmHash.mul(bufferCount);
            long a = ByteArrayUtil.getLong(this.buffer, 8) * -5435081209227447693L;
            long b = ByteArrayUtil.getLong(this.buffer, 16);
            long c = ByteArrayUtil.getLong(this.buffer, bufferCount - 8) * mul;
            long d = ByteArrayUtil.getLong(this.buffer, bufferCount - 16) * -7286425919675154353L;
            return AbstractFarmHash.hashLen16(Long.rotateRight(a + b, 43) + Long.rotateRight(c, 30) + d, a + Long.rotateRight(b + -7286425919675154353L, 18) + c, mul);
        }

        protected final long hashLen33To64(int bufferCount) {
            long mul = AbstractFarmHash.mul(bufferCount);
            long a = ByteArrayUtil.getLong(this.buffer, 8) * -7286425919675154353L;
            long b = ByteArrayUtil.getLong(this.buffer, 16);
            long c = ByteArrayUtil.getLong(this.buffer, bufferCount - 8) * mul;
            long d = ByteArrayUtil.getLong(this.buffer, bufferCount - 16) * -7286425919675154353L;
            long yy = Long.rotateRight(a + b, 43) + Long.rotateRight(c, 30) + d;
            long zz = AbstractFarmHash.hashLen16(yy, a + Long.rotateRight(b + -7286425919675154353L, 18) + c, mul);
            long e = ByteArrayUtil.getLong(this.buffer, 24) * mul;
            long f = ByteArrayUtil.getLong(this.buffer, 32);
            long g = (yy + ByteArrayUtil.getLong(this.buffer, bufferCount - 32)) * mul;
            long h = (zz + ByteArrayUtil.getLong(this.buffer, bufferCount - 24)) * mul;
            return AbstractFarmHash.hashLen16(Long.rotateRight(e + f, 43) + Long.rotateRight(g, 30) + h, e + Long.rotateRight(f + a, 18) + g, mul);
        }
    }
}

