/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p2layers;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.elk.alg.layered.LayeredPhases;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.intermediate.IntermediateProcessorStrategy;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.core.UnsupportedGraphException;
import org.eclipse.elk.core.alg.ILayoutPhase;
import org.eclipse.elk.core.alg.LayoutProcessorConfiguration;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class BreadthFirstModelOrderLayerer
implements ILayoutPhase<LayeredPhases, LGraph> {
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> BASELINE_PROCESSING_CONFIGURATION = LayoutProcessorConfiguration.create().addBefore(LayeredPhases.P1_CYCLE_BREAKING, IntermediateProcessorStrategy.EDGE_AND_LAYER_CONSTRAINT_EDGE_REVERSER).addBefore(LayeredPhases.P2_LAYERING, IntermediateProcessorStrategy.LAYER_CONSTRAINT_PREPROCESSOR).addBefore(LayeredPhases.P3_NODE_ORDERING, IntermediateProcessorStrategy.LAYER_CONSTRAINT_POSTPROCESSOR);
    private LGraph layeredGraph;

    @Override
    public LayoutProcessorConfiguration<LayeredPhases, LGraph> getLayoutProcessorConfiguration(LGraph graph) {
        return BASELINE_PROCESSING_CONFIGURATION;
    }

    @Override
    public void process(LGraph thelayeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Breadth first model order layering", 1.0f);
        this.layeredGraph = thelayeredGraph;
        ArrayList<LNode> realNodes = new ArrayList<LNode>();
        for (LNode node : this.layeredGraph.getLayerlessNodes()) {
            if (node.getType() != LNode.NodeType.NORMAL) continue;
            realNodes.add(node);
        }
        Collections.sort(realNodes, (n1, n2) -> {
            if (n1.hasProperty(InternalProperties.MODEL_ORDER) && n2.hasProperty(InternalProperties.MODEL_ORDER)) {
                return Integer.compare(n1.getProperty(InternalProperties.MODEL_ORDER), n2.getProperty(InternalProperties.MODEL_ORDER));
            }
            throw new UnsupportedGraphException("The BF model order layer assigner requires all real nodes to have a model order.");
        });
        boolean firstNode = true;
        Layer currentLayer = new Layer(this.layeredGraph);
        Layer currentDummyLayer = null;
        this.layeredGraph.getLayers().add(currentLayer);
        for (LNode node : realNodes) {
            if (firstNode) {
                node.setLayer(currentLayer);
                firstNode = false;
                continue;
            }
            for (LEdge lEdge : node.getIncomingEdges()) {
                if ((lEdge.getSource().getNode().getType() != LNode.NodeType.NORMAL || lEdge.getSource().getNode().getLayer() != currentLayer) && (lEdge.getSource().getNode().getType() != LNode.NodeType.LABEL || lEdge.getSource().getNode().getIncomingEdges().iterator().next().getSource().getNode().getLayer() != currentLayer)) continue;
                currentDummyLayer = new Layer(this.layeredGraph);
                this.layeredGraph.getLayers().add(currentDummyLayer);
                currentLayer = new Layer(this.layeredGraph);
                this.layeredGraph.getLayers().add(currentLayer);
            }
            for (LEdge lEdge : node.getIncomingEdges()) {
                if (lEdge.getSource().getNode().getType() != LNode.NodeType.LABEL || lEdge.getSource().getNode().getLayer() != null) continue;
                lEdge.getSource().getNode().setLayer(currentDummyLayer);
            }
            node.setLayer(currentLayer);
        }
        this.layeredGraph.getLayerlessNodes().clear();
        ArrayList<Layer> toDelete = new ArrayList<Layer>();
        for (Layer layer : this.layeredGraph.getLayers()) {
            if (!layer.getNodes().isEmpty()) continue;
            toDelete.add(layer);
        }
        this.layeredGraph.getLayers().removeAll(toDelete);
        int layerId = 0;
        for (Layer layer : this.layeredGraph.getLayers()) {
            layer.id = layerId++;
        }
        monitor.done();
    }
}

