/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.klimt.Shadowable;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.SvekNode;
import net.sourceforge.plantuml.url.Url;

public class EntityImageActivity
extends AbstractEntityImage {
    private double shadowing = 0.0;
    public static final int CORNER = 25;
    private final TextBlock desc;
    private static final int MARGIN = 10;
    private final Url url;
    private final Bibliotekon bibliotekon;

    public EntityImageActivity(Entity entity, Bibliotekon bibliotekon) {
        super(entity);
        this.bibliotekon = bibliotekon;
        Style style = this.getDefaultStyleDefinition().getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
        FontConfiguration fontConfiguration = style.getFontConfiguration(this.getSkinParam().getIHtmlColorSet());
        HorizontalAlignment horizontalAlignment = style.getHorizontalAlignment();
        this.shadowing = style.getShadowing();
        this.desc = entity.getDisplay().create(fontConfiguration, horizontalAlignment, this.getSkinParam());
        this.url = entity.getUrl99();
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        XDimension2D dim = this.desc.calculateDimension(stringBounder);
        return dim.delta(20.0);
    }

    @Override
    public final void drawU(UGraphic ug) {
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        if (this.getShapeType() == ShapeType.ROUND_RECTANGLE) {
            ug = this.drawNormal(ug);
        } else if (this.getShapeType() == ShapeType.OCTAGON) {
            ug = this.drawOctagon(ug);
        } else {
            throw new UnsupportedOperationException();
        }
        if (this.url != null) {
            ug.closeUrl();
        }
    }

    private UGraphic drawOctagon(UGraphic ug) {
        SvekNode node = this.bibliotekon.getNode(this.getEntity());
        Shadowable octagon = node.getPolygon();
        if (octagon == null) {
            return this.drawNormal(ug);
        }
        octagon.setDeltaShadow(this.shadowing);
        ug = this.applyColors(ug);
        ug.apply(UStroke.withThickness(1.5)).draw(octagon);
        this.desc.drawU(ug.apply(new UTranslate(10.0, 10.0)));
        return ug;
    }

    private UGraphic drawNormal(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        XDimension2D dimTotal = this.calculateDimension(stringBounder);
        double widthTotal = dimTotal.getWidth();
        double heightTotal = dimTotal.getHeight();
        URectangle rect = URectangle.build(widthTotal, heightTotal).rounded(25.0);
        rect.setDeltaShadow(this.shadowing);
        ug = this.applyColors(ug);
        Style style = this.getDefaultStyleDefinition().getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
        UStroke stroke = style.getStroke();
        ug.apply(stroke).draw(rect);
        this.desc.drawU(ug.apply(new UTranslate(10.0, 10.0)));
        return ug;
    }

    public StyleSignature getDefaultStyleDefinition() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.activity).withTOBECHANGED(this.getStereo());
    }

    private UGraphic applyColors(UGraphic ug) {
        Style style = this.getDefaultStyleDefinition().getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
        HColor borderColor = style.value(PName.LineColor).asColor(this.getSkinParam().getIHtmlColorSet());
        HColor backcolor = this.getEntity().getColors().getColor(ColorType.BACK);
        if (backcolor == null) {
            backcolor = style.value(PName.BackGroundColor).asColor(this.getSkinParam().getIHtmlColorSet());
        }
        ug = ug.apply(borderColor);
        ug = ug.apply(backcolor.bg());
        return ug;
    }

    @Override
    public ShapeType getShapeType() {
        Stereotype stereotype = this.getStereo();
        if (this.getSkinParam().useOctagonForActivity(stereotype)) {
            return ShapeType.OCTAGON;
        }
        return ShapeType.ROUND_RECTANGLE;
    }
}

