/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.prometheus.storage;

import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import okhttp3.OkHttpClient;
import org.opensearch.sql.common.interceptors.AwsSigningInterceptor;
import org.opensearch.sql.common.interceptors.BasicAuthenticationInterceptor;
import org.opensearch.sql.common.interceptors.URIValidatorInterceptor;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.datasource.model.DataSource;
import org.opensearch.sql.datasource.model.DataSourceMetadata;
import org.opensearch.sql.datasource.model.DataSourceType;
import org.opensearch.sql.datasources.auth.AuthenticationType;
import org.opensearch.sql.datasources.utils.DatasourceValidationUtils;
import org.opensearch.sql.prometheus.client.PrometheusClient;
import org.opensearch.sql.prometheus.client.PrometheusClientImpl;
import org.opensearch.sql.prometheus.storage.PrometheusStorageEngine;
import org.opensearch.sql.storage.DataSourceFactory;
import org.opensearch.sql.storage.StorageEngine;

public class PrometheusStorageFactory
implements DataSourceFactory {
    public static final String URI = "prometheus.uri";
    public static final String AUTH_TYPE = "prometheus.auth.type";
    public static final String USERNAME = "prometheus.auth.username";
    public static final String PASSWORD = "prometheus.auth.password";
    public static final String REGION = "prometheus.auth.region";
    public static final String ACCESS_KEY = "prometheus.auth.access_key";
    public static final String SECRET_KEY = "prometheus.auth.secret_key";
    private final Settings settings;

    @Override
    public DataSourceType getDataSourceType() {
        return DataSourceType.PROMETHEUS;
    }

    @Override
    public DataSource createDataSource(DataSourceMetadata metadata2) {
        return new DataSource(metadata2.getName(), DataSourceType.PROMETHEUS, this.getStorageEngine(metadata2.getProperties()));
    }

    private void validateDataSourceConfigProperties(Map<String, String> dataSourceMetadataConfig) throws URISyntaxException, UnknownHostException {
        if (dataSourceMetadataConfig.get(AUTH_TYPE) != null) {
            AuthenticationType authenticationType = AuthenticationType.get(dataSourceMetadataConfig.get(AUTH_TYPE));
            if (AuthenticationType.BASICAUTH.equals((Object)authenticationType)) {
                DatasourceValidationUtils.validateLengthAndRequiredFields(dataSourceMetadataConfig, Set.of(URI, USERNAME, PASSWORD));
            } else if (AuthenticationType.AWSSIGV4AUTH.equals((Object)authenticationType)) {
                DatasourceValidationUtils.validateLengthAndRequiredFields(dataSourceMetadataConfig, Set.of(URI, ACCESS_KEY, SECRET_KEY, REGION));
            }
        } else {
            DatasourceValidationUtils.validateLengthAndRequiredFields(dataSourceMetadataConfig, Set.of(URI));
        }
        DatasourceValidationUtils.validateHost(dataSourceMetadataConfig.get(URI), (List)this.settings.getSettingValue(Settings.Key.DATASOURCES_URI_HOSTS_DENY_LIST));
    }

    StorageEngine getStorageEngine(Map<String, String> requiredConfig) {
        PrometheusClient prometheusClient = AccessController.doPrivileged(() -> {
            try {
                this.validateDataSourceConfigProperties(requiredConfig);
                return new PrometheusClientImpl(this.getHttpClient(requiredConfig), new URI((String)requiredConfig.get(URI)));
            }
            catch (URISyntaxException | UnknownHostException e) {
                throw new IllegalArgumentException(String.format("Invalid URI in prometheus properties: %s", e.getMessage()));
            }
        });
        return new PrometheusStorageEngine(prometheusClient);
    }

    private OkHttpClient getHttpClient(Map<String, String> config) {
        OkHttpClient.Builder okHttpClient = new OkHttpClient.Builder();
        okHttpClient.callTimeout(1L, TimeUnit.MINUTES);
        okHttpClient.connectTimeout(30L, TimeUnit.SECONDS);
        okHttpClient.followRedirects(false);
        okHttpClient.addInterceptor(new URIValidatorInterceptor((List)this.settings.getSettingValue(Settings.Key.DATASOURCES_URI_HOSTS_DENY_LIST)));
        if (config.get(AUTH_TYPE) != null) {
            AuthenticationType authenticationType = AuthenticationType.get(config.get(AUTH_TYPE));
            if (AuthenticationType.BASICAUTH.equals((Object)authenticationType)) {
                okHttpClient.addInterceptor(new BasicAuthenticationInterceptor(config.get(USERNAME), config.get(PASSWORD)));
            } else if (AuthenticationType.AWSSIGV4AUTH.equals((Object)authenticationType)) {
                okHttpClient.addInterceptor(new AwsSigningInterceptor(new AWSStaticCredentialsProvider(new BasicAWSCredentials(config.get(ACCESS_KEY), config.get(SECRET_KEY))), config.get(REGION), "aps"));
            } else {
                throw new IllegalArgumentException(String.format("AUTH Type : %s is not supported with Prometheus Connector", config.get(AUTH_TYPE)));
            }
        }
        return okHttpClient.build();
    }

    @Generated
    public PrometheusStorageFactory(Settings settings) {
        this.settings = settings;
    }
}

