/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.connector.functions.preprocess;

import java.io.IOException;
import java.util.Map;
import lombok.Generated;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.ml.common.connector.functions.preprocess.ConnectorPreProcessFunction;
import org.opensearch.ml.common.dataset.remote.RemoteInferenceInputDataSet;
import org.opensearch.ml.common.input.MLInput;
import org.opensearch.ml.common.utils.StringUtils;
import org.opensearch.script.ScriptService;

public class DefaultPreProcessFunction
extends ConnectorPreProcessFunction {
    private final ScriptService scriptService;
    private final String preProcessFunction;
    private final boolean convertInputToJsonString;

    public DefaultPreProcessFunction(ScriptService scriptService, String preProcessFunction, boolean convertInputToJsonString) {
        this.returnDirectlyForRemoteInferenceInput = false;
        this.scriptService = scriptService;
        this.preProcessFunction = preProcessFunction;
        this.convertInputToJsonString = convertInputToJsonString;
    }

    @Override
    public void validate(MLInput mlInput) {
    }

    @Override
    public RemoteInferenceInputDataSet process(MLInput mlInput) {
        RemoteInferenceInputDataSet remoteInferenceInputDataSet;
        block10: {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            try {
                String processedInput;
                mlInput.toXContent(builder, ToXContent.EMPTY_PARAMS);
                String inputStr = builder.toString();
                Map<String, String> inputParams = StringUtils.gson.fromJson(inputStr, Map.class);
                if (this.convertInputToJsonString) {
                    inputParams = StringUtils.convertScriptStringToJsonString(Map.of("parameters", StringUtils.gson.fromJson(inputStr, Map.class)));
                }
                if ((processedInput = this.executeScript(this.scriptService, this.preProcessFunction, (Map<String, Object>)inputParams)) == null) {
                    throw new IllegalArgumentException("Preprocess function output is null");
                }
                Map map = StringUtils.gson.fromJson(processedInput, Map.class);
                remoteInferenceInputDataSet = RemoteInferenceInputDataSet.builder().parameters(StringUtils.convertScriptStringToJsonString(map)).build();
                if (builder == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Failed to run pre-process function: Wrong input");
                }
            }
            builder.close();
        }
        return remoteInferenceInputDataSet;
    }

    @Generated
    public static DefaultPreProcessFunctionBuilder builder() {
        return new DefaultPreProcessFunctionBuilder();
    }

    @Generated
    public static class DefaultPreProcessFunctionBuilder {
        @Generated
        private ScriptService scriptService;
        @Generated
        private String preProcessFunction;
        @Generated
        private boolean convertInputToJsonString;

        @Generated
        DefaultPreProcessFunctionBuilder() {
        }

        @Generated
        public DefaultPreProcessFunctionBuilder scriptService(ScriptService scriptService) {
            this.scriptService = scriptService;
            return this;
        }

        @Generated
        public DefaultPreProcessFunctionBuilder preProcessFunction(String preProcessFunction) {
            this.preProcessFunction = preProcessFunction;
            return this;
        }

        @Generated
        public DefaultPreProcessFunctionBuilder convertInputToJsonString(boolean convertInputToJsonString) {
            this.convertInputToJsonString = convertInputToJsonString;
            return this;
        }

        @Generated
        public DefaultPreProcessFunction build() {
            return new DefaultPreProcessFunction(this.scriptService, this.preProcessFunction, this.convertInputToJsonString);
        }

        @Generated
        public String toString() {
            return "DefaultPreProcessFunction.DefaultPreProcessFunctionBuilder(scriptService=" + String.valueOf(this.scriptService) + ", preProcessFunction=" + this.preProcessFunction + ", convertInputToJsonString=" + this.convertInputToJsonString + ")";
        }
    }
}

