/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk;

import com.amazonaws.encryptionsdk.CryptoAlgorithm;
import com.amazonaws.encryptionsdk.DataKey;
import com.amazonaws.encryptionsdk.EncryptedDataKey;
import com.amazonaws.encryptionsdk.MasterKey;
import com.amazonaws.encryptionsdk.MasterKeyRequest;
import com.amazonaws.encryptionsdk.exception.AwsCryptoException;
import com.amazonaws.encryptionsdk.exception.CannotUnwrapDataKeyException;
import com.amazonaws.encryptionsdk.exception.NoSuchMasterKeyException;
import com.amazonaws.encryptionsdk.exception.UnsupportedProviderException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class MasterKeyProvider<K extends MasterKey<K>> {
    public abstract String getDefaultProviderId();

    public boolean canProvide(String provider) {
        return this.getDefaultProviderId().equals(provider);
    }

    public K getMasterKey(String keyId) throws UnsupportedProviderException, NoSuchMasterKeyException {
        return this.getMasterKey(this.getDefaultProviderId(), keyId);
    }

    public abstract K getMasterKey(String var1, String var2) throws UnsupportedProviderException, NoSuchMasterKeyException;

    public abstract List<K> getMasterKeysForEncryption(MasterKeyRequest var1);

    public abstract DataKey<K> decryptDataKey(CryptoAlgorithm var1, Collection<? extends EncryptedDataKey> var2, Map<String, String> var3) throws UnsupportedProviderException, AwsCryptoException;

    protected AwsCryptoException buildCannotDecryptDksException() {
        return this.buildCannotDecryptDksException(Collections.emptyList());
    }

    protected AwsCryptoException buildCannotDecryptDksException(Throwable t2) {
        return this.buildCannotDecryptDksException(Collections.singletonList(t2));
    }

    protected AwsCryptoException buildCannotDecryptDksException(List<? extends Throwable> t2) {
        if (t2 == null || t2.isEmpty()) {
            return new CannotUnwrapDataKeyException("Unable to decrypt any data keys");
        }
        CannotUnwrapDataKeyException ex = new CannotUnwrapDataKeyException("Unable to decrypt any data keys", t2.get(0));
        for (Throwable throwable : t2) {
            ex.addSuppressed(throwable);
        }
        return ex;
    }
}

