/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.profile.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.MessageLookup;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.messaging.context.SAMLSubjectNameIdentifierContext;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Subject;
import org.slf4j.Logger;

public class CopyNameIDFromRequest
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(CopyNameIDFromRequest.class);
    @Nonnull
    private final SAMLObjectBuilder<Subject> subjectBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(Subject.DEFAULT_ELEMENT_NAME);
    @Nonnull
    private final SAMLObjectBuilder<NameID> nameIdBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(NameID.DEFAULT_ELEMENT_NAME);
    private boolean overwriteExisting = true;
    @Nonnull
    private Function<ProfileRequestContext, SAMLSubjectNameIdentifierContext> nameIdentifierContextLookupStrategy = new ChildContextLookup(SAMLSubjectNameIdentifierContext.class, true).compose(new InboundMessageContextLookup());
    @Nonnull
    private Function<ProfileRequestContext, Response> responseLookupStrategy = new MessageLookup<Response>(Response.class).compose(new OutboundMessageContextLookup());
    @NonnullBeforeExec
    private NameID nameId;
    @NonnullBeforeExec
    private Response response;

    public void setOverwriteExisting(boolean flag) {
        this.checkSetterPreconditions();
        this.overwriteExisting = flag;
    }

    public void setNameIDContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SAMLSubjectNameIdentifierContext> strategy) {
        this.checkSetterPreconditions();
        this.nameIdentifierContextLookupStrategy = Constraint.isNotNull(strategy, "SAMLSubjectNameIdentifierContext lookup strategy cannot be null");
    }

    public void setResponseLookupStrategy(@Nonnull Function<ProfileRequestContext, Response> strategy) {
        this.checkSetterPreconditions();
        this.responseLookupStrategy = Constraint.isNotNull(strategy, "Response lookup strategy cannot be null");
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.log.debug("{} Attempting to add NameID to statements in outgoing Response", (Object)this.getLogPrefix());
        this.response = this.responseLookupStrategy.apply(profileRequestContext);
        if (this.response == null) {
            this.log.debug("{} No SAML response located", (Object)this.getLogPrefix());
            ActionSupport.buildEvent(profileRequestContext, "InvalidMessageContext");
            return false;
        }
        if (this.response.getAssertions().isEmpty()) {
            this.log.debug("{} No assertions in response message, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        SAMLSubjectNameIdentifierContext idCtx = this.nameIdentifierContextLookupStrategy.apply(profileRequestContext);
        if (idCtx == null) {
            this.log.debug("{} No SAMLSubjectNameIdentifierContext located", (Object)this.getLogPrefix());
            ActionSupport.buildEvent(profileRequestContext, "InvalidMessageContext");
            return false;
        }
        this.nameId = idCtx.getSAML2SubjectNameID();
        if (this.nameId == null) {
            this.log.debug("{} No SAMLSubjectNameIdentifierContext located", (Object)this.getLogPrefix());
            ActionSupport.buildEvent(profileRequestContext, "InvalidMessageContext");
            return false;
        }
        return true;
    }

    @Override
    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        int count = 0;
        for (Assertion assertion : this.response.getAssertions()) {
            assert (assertion != null);
            Subject subject = this.getAssertionSubject(assertion);
            NameID existing = subject.getNameID();
            if (existing != null && !this.overwriteExisting) continue;
            subject.setNameID(this.cloneNameID());
            ++count;
        }
        if (count > 0) {
            this.log.debug("{} Added NameID to {} assertion(s)", (Object)this.getLogPrefix(), (Object)count);
        }
    }

    @Nonnull
    private Subject getAssertionSubject(@Nonnull Assertion assertion) {
        Subject subject = assertion.getSubject();
        if (subject != null) {
            return subject;
        }
        subject = this.subjectBuilder.buildObject();
        assertion.setSubject(subject);
        return subject;
    }

    @Nonnull
    private NameID cloneNameID() {
        NameID clone = this.nameIdBuilder.buildObject();
        clone.setFormat(this.nameId.getFormat());
        clone.setNameQualifier(this.nameId.getNameQualifier());
        clone.setSPNameQualifier(this.nameId.getSPNameQualifier());
        clone.setSPProvidedID(this.nameId.getSPProvidedID());
        clone.setValue(this.nameId.getValue());
        return clone;
    }
}

