/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.memoryoptsearch;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.store.IndexInput;
import org.opensearch.knn.memoryoptsearch.AbstractMemorySegmentAddressExtractor;

public final class MemorySegmentAddressExtractorJDK21
extends AbstractMemorySegmentAddressExtractor {
    @Generated
    private static final Logger log = LogManager.getLogger(MemorySegmentAddressExtractorJDK21.class);
    private static final Method ADDRESS_METHOD;
    private static final Method BYTE_SIZE_METHOD;

    @Override
    protected long getChunkSizeFromMemorySegment(Object memorySegment) {
        try {
            return (Long)BYTE_SIZE_METHOD.invoke(memorySegment, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.warn("Failed to get chunk size from MemorySegment, error message={}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    @Override
    protected long getAddressFromMemorySegment(Object memorySegment) {
        try {
            return (Long)ADDRESS_METHOD.invoke(memorySegment, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.warn("Failed to get address from MemorySegment, error message={}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Object getMemorySegments(IndexInput indexInput) {
        if (ADDRESS_METHOD == null || BYTE_SIZE_METHOD == null) {
            return null;
        }
        return super.getMemorySegments(indexInput);
    }

    static {
        Method addressMethod = null;
        Method byteSizeMethod = null;
        try {
            Class<?> clazz = Class.forName("java.lang.foreign.MemorySegment");
            addressMethod = clazz.getMethod("address", new Class[0]);
            byteSizeMethod = clazz.getMethod("byteSize", new Class[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
        ADDRESS_METHOD = addressMethod;
        BYTE_SIZE_METHOD = byteSizeMethod;
    }
}

