"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _configSchema = require("@osd/config-schema");
var _helpers = require("../services/utils/helpers");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function _default(services, router, dataSourceEnabled) {
  const {
    findingService
  } = services;
  const fieldValidations = {
    id: _configSchema.schema.maybe(_configSchema.schema.string()),
    from: _configSchema.schema.number(),
    size: _configSchema.schema.number(),
    search: _configSchema.schema.string(),
    sortField: _configSchema.schema.string(),
    sortDirection: _configSchema.schema.string()
  };
  router.get({
    path: '/api/alerting/findings/_search',
    validate: {
      query: (0, _helpers.createValidateQuerySchema)(dataSourceEnabled, fieldValidations)
    }
  }, findingService.getFindings);
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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