/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.XECPrivateKey;
import java.security.interfaces.XECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.NamedParameterSpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.AgreementFactory;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricKeyPairGenerator;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.asymmetric.AsymmetricEdDSAPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricEdDSAPublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricKeyPair;
import org.bouncycastle.crypto.asymmetric.AsymmetricXDHPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricXDHPublicKey;
import org.bouncycastle.crypto.fips.FipsKDF;
import org.bouncycastle.crypto.general.EdEC;
import org.bouncycastle.crypto.general.GeneralAlgorithm;
import org.bouncycastle.jcajce.provider.AsymmetricAlgorithmProvider;
import org.bouncycastle.jcajce.provider.BaseAgreement;
import org.bouncycastle.jcajce.provider.BaseKeyFactory;
import org.bouncycastle.jcajce.provider.BaseSignature;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.provider.GuardedEngineCreator;
import org.bouncycastle.jcajce.provider.ParametersCreator;
import org.bouncycastle.jcajce.provider.PrivateKeyConverter;
import org.bouncycastle.jcajce.provider.Prov11XDHPrivateKey;
import org.bouncycastle.jcajce.provider.Prov11XDHPublicKey;
import org.bouncycastle.jcajce.provider.Prov15EdDSAPrivateKey;
import org.bouncycastle.jcajce.provider.Prov15EdDSAPublicKey;
import org.bouncycastle.jcajce.provider.ProvEC;
import org.bouncycastle.jcajce.provider.PublicKeyConverter;
import org.bouncycastle.jcajce.provider.Utils;
import org.bouncycastle.jcajce.spec.EdDSAParameterSpec;
import org.bouncycastle.jcajce.spec.UserKeyingMaterialSpec;
import org.bouncycastle.jcajce.spec.XDHParameterSpec;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvEdEC
extends AsymmetricAlgorithmProvider {
    private static final Map<String, String> generalEdDSAAttributes = new HashMap<String, String>();
    private static final Map<String, String> generalXDHAttributes = new HashMap<String, String>();
    private static final AgreementFactory xdhFactory = new EdEC.XDHAgreementFactory();
    private static final String PREFIX = "org.bouncycastle.jcajce.provider.asymmetric.edec.";
    private static final byte x448_type = 111;
    private static final byte x25519_type = 110;
    private static final byte Ed448_type = 113;
    private static final byte Ed25519_type = 112;
    private static final PublicKeyConverter<AsymmetricEdDSAPublicKey> edPublicKeyConverter;
    private static final PrivateKeyConverter<AsymmetricEdDSAPrivateKey> edPrivateKeyConverter;
    private static final PublicKeyConverter<AsymmetricXDHPublicKey> xPublicKeyConverter;
    private static final PrivateKeyConverter<AsymmetricXDHPrivateKey> xPrivateKeyConverter;

    ProvEdEC() {
    }

    @Override
    public void configure(final BouncyCastleFipsProvider provider) {
        provider.addAlgorithmImplementation("KeyFactory.XDH", "org.bouncycastle.jcajce.provider.asymmetric.edec.KeyFactorySpi$XDH", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new KeyFactorySpi.XDH();
            }
        }));
        provider.addAlgorithmImplementation("KeyFactory.X448", "org.bouncycastle.jcajce.provider.asymmetric.edec.KeyFactorySpi$X448", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new KeyFactorySpi.X448();
            }
        }));
        provider.addAlgorithmImplementation("KeyFactory.X25519", "org.bouncycastle.jcajce.provider.asymmetric.edec.KeyFactorySpi$X25519", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new KeyFactorySpi.X25519();
            }
        }));
        provider.addAlgorithmImplementation("KeyFactory.EDDSA", "org.bouncycastle.jcajce.provider.asymmetric.edec.KeyFactorySpi$EdDH", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new KeyFactorySpi.EdDSA();
            }
        }));
        provider.addAlgorithmImplementation("KeyFactory.ED448", "org.bouncycastle.jcajce.provider.asymmetric.edec.KeyFactorySpi$Ed448", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new KeyFactorySpi.Ed448();
            }
        }));
        provider.addAlgorithmImplementation("KeyFactory.ED25519", "org.bouncycastle.jcajce.provider.asymmetric.edec.KeyFactorySpi$Ed25519", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new KeyFactorySpi.Ed25519();
            }
        }));
        provider.addAlgorithmImplementation("KeyPairGenerator.EDDSA", "org.bouncycastle.jcajce.provider.asymmetric.edec.KeyPairGeneratorSpi$EdDSA", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new KeyPairGeneratorSpi(provider, false, null);
            }
        }));
        provider.addAlgorithmImplementation("KeyPairGenerator.ED448", "org.bouncycastle.jcajce.provider.asymmetric.edec.KeyPairGeneratorSpi$Ed448", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new KeyPairGeneratorSpi(provider, false, EdEC.Ed448);
            }
        }));
        provider.addAlgorithmImplementation("KeyPairGenerator.ED25519", "org.bouncycastle.jcajce.provider.asymmetric.edec.KeyPairGeneratorSpi$Ed25519", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new KeyPairGeneratorSpi(provider, false, EdEC.Ed25519);
            }
        }));
        provider.addAlgorithmImplementation("KeyPairGenerator.XDH", "org.bouncycastle.jcajce.provider.asymmetric.edec.KeyPairGeneratorSpi$XDH", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new KeyPairGeneratorSpi(provider, true, null);
            }
        }));
        provider.addAlgorithmImplementation("KeyPairGenerator.X448", "org.bouncycastle.jcajce.provider.asymmetric.edec.KeyPairGeneratorSpi$X448", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new KeyPairGeneratorSpi(provider, true, EdEC.X448);
            }
        }));
        provider.addAlgorithmImplementation("KeyPairGenerator.X25519", "org.bouncycastle.jcajce.provider.asymmetric.edec.KeyPairGeneratorSpi$X25519", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new KeyPairGeneratorSpi(provider, true, EdEC.X25519);
            }
        }));
        provider.addAlgorithmImplementation("Signature.EDDSA", "org.bouncycastle.jcajce.provider.asymmetric.edec.Signature$EDDSA", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseSignature(provider, new EdEC.EdDSAOperatorFactory(), edPublicKeyConverter, edPrivateKeyConverter, EdEC.EdDSA);
            }
        }));
        provider.addAlgorithmImplementation("Signature.ED448", "org.bouncycastle.jcajce.provider.asymmetric.edec.Signature$Ed448", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseSignature(provider, new EdEC.EdDSAOperatorFactory(), edPublicKeyConverter, edPrivateKeyConverter, EdEC.Ed448);
            }
        }));
        provider.addAlias("Signature", "ED448", EdECObjectIdentifiers.id_Ed448);
        provider.addAlgorithmImplementation("Signature.ED25519", "org.bouncycastle.jcajce.provider.asymmetric.edec.Signature$Ed25519", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseSignature(provider, new EdEC.EdDSAOperatorFactory(), edPublicKeyConverter, edPrivateKeyConverter, EdEC.Ed25519);
            }
        }));
        provider.addAlias("Signature", "ED25519", EdECObjectIdentifiers.id_Ed25519);
        this.addKeyAgreementAlgorithm(provider, "X448", "org.bouncycastle.jcajce.provider.asymmetric.edec.KeyAgreementSpi$X448", generalXDHAttributes, new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseAgreement(xdhFactory, xPublicKeyConverter, xPrivateKeyConverter, new XDHParametersCreator(EdEC.X448));
            }
        }));
        provider.addAlias("KeyAgreement", "X448", EdECObjectIdentifiers.id_X448);
        ParametersCreator x448CParametersCreator = new ParametersCreator(){

            public Parameters createParameters(boolean forEncryption, AlgorithmParameterSpec spec, SecureRandom random) throws InvalidAlgorithmParameterException {
                if (spec != null && !(spec instanceof UserKeyingMaterialSpec)) {
                    throw new InvalidAlgorithmParameterException("X448 can only take a UserKeyingMaterialSpec");
                }
                return EdEC.X448;
            }
        };
        this.addCDHAlgorithm(provider, "X448", "SHA224", FipsKDF.AgreementKDFPRF.SHA224, x448CParametersCreator);
        this.addCDHAlgorithm(provider, "X448", "SHA256", FipsKDF.AgreementKDFPRF.SHA256, x448CParametersCreator);
        this.addCDHAlgorithm(provider, "X448", "SHA384", FipsKDF.AgreementKDFPRF.SHA384, x448CParametersCreator);
        this.addCDHAlgorithm(provider, "X448", "SHA512", FipsKDF.AgreementKDFPRF.SHA512, x448CParametersCreator);
        this.addCDHAlgorithm(provider, "X448", "SHA512(224)", FipsKDF.AgreementKDFPRF.SHA512_224, x448CParametersCreator);
        this.addCDHAlgorithm(provider, "X448", "SHA512(256)", FipsKDF.AgreementKDFPRF.SHA512_256, x448CParametersCreator);
        this.addCDHAlgorithm(provider, "X448", "SHA3-224", FipsKDF.AgreementKDFPRF.SHA3_224, x448CParametersCreator);
        this.addCDHAlgorithm(provider, "X448", "SHA3-256", FipsKDF.AgreementKDFPRF.SHA3_256, x448CParametersCreator);
        this.addCDHAlgorithm(provider, "X448", "SHA3-384", FipsKDF.AgreementKDFPRF.SHA3_384, x448CParametersCreator);
        this.addCDHAlgorithm(provider, "X448", "SHA3-512", FipsKDF.AgreementKDFPRF.SHA3_512, x448CParametersCreator);
        this.addKeyAgreementAlgorithm(provider, "X25519", "org.bouncycastle.jcajce.provider.asymmetric.edec.KeyAgreementSpi$X25519", generalXDHAttributes, new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseAgreement(new EdEC.XDHAgreementFactory(), xPublicKeyConverter, xPrivateKeyConverter, new XDHParametersCreator(EdEC.X25519));
            }
        }));
        provider.addAlias("KeyAgreement", "X25519", EdECObjectIdentifiers.id_X25519);
        ParametersCreator x25519CParametersCreator = new ParametersCreator(){

            public Parameters createParameters(boolean forEncryption, AlgorithmParameterSpec spec, SecureRandom random) throws InvalidAlgorithmParameterException {
                if (spec != null && !(spec instanceof UserKeyingMaterialSpec)) {
                    throw new InvalidAlgorithmParameterException("X25519 can only take a UserKeyingMaterialSpec");
                }
                return EdEC.X25519;
            }
        };
        this.addCDHAlgorithm(provider, "X25519", "SHA224", FipsKDF.AgreementKDFPRF.SHA224, x25519CParametersCreator);
        this.addCDHAlgorithm(provider, "X25519", "SHA256", FipsKDF.AgreementKDFPRF.SHA256, x25519CParametersCreator);
        this.addCDHAlgorithm(provider, "X25519", "SHA384", FipsKDF.AgreementKDFPRF.SHA384, x25519CParametersCreator);
        this.addCDHAlgorithm(provider, "X25519", "SHA512", FipsKDF.AgreementKDFPRF.SHA512, x25519CParametersCreator);
        this.addCDHAlgorithm(provider, "X25519", "SHA512(224)", FipsKDF.AgreementKDFPRF.SHA512_224, x25519CParametersCreator);
        this.addCDHAlgorithm(provider, "X25519", "SHA512(256)", FipsKDF.AgreementKDFPRF.SHA512_256, x25519CParametersCreator);
        this.addCDHAlgorithm(provider, "X25519", "SHA3-224", FipsKDF.AgreementKDFPRF.SHA3_224, x25519CParametersCreator);
        this.addCDHAlgorithm(provider, "X25519", "SHA3-256", FipsKDF.AgreementKDFPRF.SHA3_256, x25519CParametersCreator);
        this.addCDHAlgorithm(provider, "X25519", "SHA3-384", FipsKDF.AgreementKDFPRF.SHA3_384, x25519CParametersCreator);
        this.addCDHAlgorithm(provider, "X25519", "SHA3-512", FipsKDF.AgreementKDFPRF.SHA3_512, x25519CParametersCreator);
        this.registerOid(provider, EdECObjectIdentifiers.id_X448, "X448", new KeyFactorySpi.X448());
        this.registerOid(provider, EdECObjectIdentifiers.id_X25519, "X25519", new KeyFactorySpi.X25519());
        this.registerOid(provider, EdECObjectIdentifiers.id_Ed448, "ED448", new KeyFactorySpi.Ed448());
        this.registerOid(provider, EdECObjectIdentifiers.id_Ed25519, "ED25519", new KeyFactorySpi.Ed25519());
    }

    private void addCDHAlgorithm(BouncyCastleFipsProvider provider, String curveName, String digestName, final FipsKDF.AgreementKDFPRF prf, final ParametersCreator cdhParametersCreator) {
        String algorithm = curveName + "WITH" + digestName + "CKDF";
        this.addKeyAgreementAlgorithm(provider, algorithm, "org.bouncycastle.jcajce.provider.asymmetric.edec.KeyAgreementSpi$" + algorithm, generalXDHAttributes, new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseAgreement(xdhFactory, xPublicKeyConverter, xPrivateKeyConverter, cdhParametersCreator, FipsKDF.CONCATENATION.withPRF(prf));
            }
        }));
    }

    static {
        generalEdDSAAttributes.put("SupportedKeyClasses", "org.bouncycastle.interfaces.EdDSAKey");
        generalEdDSAAttributes.put("SupportedKeyFormats", "PKCS#8|X.509");
        generalXDHAttributes.put("SupportedKeyClasses", "org.bouncycastle.interfaces.XDHKey");
        generalXDHAttributes.put("SupportedKeyFormats", "PKCS#8|X.509");
        edPublicKeyConverter = new PublicKeyConverter<AsymmetricEdDSAPublicKey>(){

            @Override
            public AsymmetricEdDSAPublicKey convertKey(Algorithm algorithm, PublicKey key) throws InvalidKeyException {
                if (key instanceof Prov15EdDSAPublicKey) {
                    return ((Prov15EdDSAPublicKey)key).getBaseKey();
                }
                try {
                    return new AsymmetricEdDSAPublicKey(Utils.getKeyEncoding(key));
                }
                catch (Exception e) {
                    throw new InvalidKeyException("Cannot identify EdDSA public key: " + e.getMessage(), e);
                }
            }
        };
        edPrivateKeyConverter = new PrivateKeyConverter<AsymmetricEdDSAPrivateKey>(){

            @Override
            public AsymmetricEdDSAPrivateKey convertKey(Algorithm algorithm, PrivateKey key) throws InvalidKeyException {
                if (key instanceof Prov15EdDSAPrivateKey) {
                    return ((Prov15EdDSAPrivateKey)key).getBaseKey();
                }
                try {
                    return new AsymmetricEdDSAPrivateKey(PrivateKeyInfo.getInstance(Utils.getKeyEncoding(key)));
                }
                catch (Exception e) {
                    throw new InvalidKeyException("Cannot identify EdDSA private key: " + e.getMessage(), e);
                }
            }
        };
        xPublicKeyConverter = new PublicKeyConverter<AsymmetricXDHPublicKey>(){

            @Override
            public AsymmetricXDHPublicKey convertKey(Algorithm algorithm, PublicKey key) throws InvalidKeyException {
                if (key instanceof Prov11XDHPublicKey) {
                    return ((Prov11XDHPublicKey)key).getBaseKey();
                }
                try {
                    if (key instanceof XECPublicKey) {
                        AlgorithmParameterSpec params;
                        XECPublicKey jcePub = (XECPublicKey)key;
                        BigInteger u = jcePub.getU();
                        if (u.signum() < 0) {
                            throw new InvalidKeyException("cannot use XEC public key with negative U value");
                        }
                        String jceAlg = jcePub.getAlgorithm();
                        if ("X25519".equalsIgnoreCase(jceAlg)) {
                            return this.getX25519PublicKey(u);
                        }
                        if ("X448".equalsIgnoreCase(jceAlg)) {
                            return this.getX448PublicKey(u);
                        }
                        if ("XDH".equalsIgnoreCase(jceAlg) && (params = jcePub.getParams()) instanceof NamedParameterSpec) {
                            NamedParameterSpec namedParams = (NamedParameterSpec)params;
                            String name = namedParams.getName();
                            if ("X25519".equalsIgnoreCase(name)) {
                                return this.getX25519PublicKey(u);
                            }
                            if ("X448".equalsIgnoreCase(name)) {
                                return this.getX448PublicKey(u);
                            }
                        }
                        throw new InvalidKeyException("cannot use XEC public key with unknown algorithm");
                    }
                    return new AsymmetricXDHPublicKey(Utils.getKeyEncoding(key));
                }
                catch (Exception e) {
                    throw new InvalidKeyException("Cannot identify XDH public key: " + e.getMessage(), e);
                }
            }

            AsymmetricXDHPublicKey getX25519PublicKey(BigInteger u) throws InvalidKeyException {
                return new AsymmetricXDHPublicKey((Algorithm)EdEC.X25519.getAlgorithm(), Arrays.reverseInPlace(BigIntegers.asUnsignedByteArray(32, u)));
            }

            AsymmetricXDHPublicKey getX448PublicKey(BigInteger u) throws InvalidKeyException {
                return new AsymmetricXDHPublicKey((Algorithm)EdEC.X448.getAlgorithm(), Arrays.reverseInPlace(BigIntegers.asUnsignedByteArray(56, u)));
            }
        };
        xPrivateKeyConverter = new PrivateKeyConverter<AsymmetricXDHPrivateKey>(){

            @Override
            public AsymmetricXDHPrivateKey convertKey(Algorithm algorithm, PrivateKey key) throws InvalidKeyException {
                if (key instanceof Prov11XDHPrivateKey) {
                    return ((Prov11XDHPrivateKey)key).getBaseKey();
                }
                try {
                    if (key instanceof XECPrivateKey) {
                        XECPrivateKey privKey = (XECPrivateKey)key;
                        if (privKey.getScalar().isPresent()) {
                            return new AsymmetricXDHPrivateKey(PrivateKeyInfo.getInstance(Utils.getKeyEncoding(key)));
                        }
                    } else {
                        return new AsymmetricXDHPrivateKey(PrivateKeyInfo.getInstance(Utils.getKeyEncoding(key)));
                    }
                    throw new InvalidKeyException("cannot use other provider XEC private key");
                }
                catch (Exception e) {
                    throw new InvalidKeyException("Cannot identify XDH private key: " + e.getMessage(), e);
                }
            }
        };
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class KeyFactorySpi
    extends BaseKeyFactory {
        String algorithm;
        private final boolean isXdh;
        private final int specificBase;

        public KeyFactorySpi(String algorithm, boolean isXdh, int specificBase) {
            this.algorithm = algorithm;
            this.isXdh = isXdh;
            this.specificBase = specificBase;
        }

        @Override
        protected Key engineTranslateKey(Key key) throws InvalidKeyException {
            if (key instanceof PublicKey) {
                if (this.isXdh) {
                    GeneralAlgorithm alg = key.getAlgorithm().equals("X448") ? EdEC.Algorithm.X448 : EdEC.Algorithm.X25519;
                    return new Prov11XDHPublicKey(xPublicKeyConverter.convertKey(alg, (PublicKey)key));
                }
                GeneralAlgorithm alg = key.getAlgorithm().equals("Ed448") ? EdEC.Algorithm.Ed448 : EdEC.Algorithm.Ed25519;
                return new Prov15EdDSAPublicKey(edPublicKeyConverter.convertKey(alg, (PublicKey)key));
            }
            if (key instanceof PrivateKey) {
                if (this.isXdh) {
                    GeneralAlgorithm alg = key.getAlgorithm().equals("X448") ? EdEC.Algorithm.X448 : EdEC.Algorithm.X25519;
                    return new Prov11XDHPrivateKey(xPrivateKeyConverter.convertKey(alg, (PrivateKey)key));
                }
                GeneralAlgorithm alg = key.getAlgorithm().equals("Ed448") ? EdEC.Algorithm.Ed448 : EdEC.Algorithm.Ed25519;
                AsymmetricEdDSAPrivateKey privKey = edPrivateKeyConverter.convertKey(alg, (PrivateKey)key);
                return new Prov15EdDSAPrivateKey(privKey, new AsymmetricEdDSAPublicKey(alg, privKey.getPublicData()));
            }
            if (key != null) {
                throw new InvalidKeyException("Key type unrecognized: " + key.getClass().getName());
            }
            throw new InvalidKeyException("Key is null");
        }

        @Override
        protected KeySpec engineGetKeySpec(Key key, Class spec) throws InvalidKeySpecException {
            if (spec == null) {
                throw new InvalidKeySpecException("null spec is invalid");
            }
            return super.engineGetKeySpec(key, spec);
        }

        @Override
        protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
            return super.engineGeneratePrivate(keySpec);
        }

        @Override
        protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof X509EncodedKeySpec) {
                byte[] enc = ((X509EncodedKeySpec)keySpec).getEncoded();
                if (enc[9] == 5 && enc[10] == 0) {
                    SubjectPublicKeyInfo keyInfo = SubjectPublicKeyInfo.getInstance(enc);
                    keyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(keyInfo.getAlgorithm().getAlgorithm()), keyInfo.getPublicKeyData().getBytes());
                    try {
                        enc = keyInfo.getEncoded("DER");
                    }
                    catch (IOException e) {
                        throw new InvalidKeySpecException("attempt to reconstruct key failed: " + e.getMessage());
                    }
                }
                if (this.specificBase == 0 || this.specificBase == enc[8]) {
                    try {
                        switch (enc[8]) {
                            case 111: {
                                return new Prov11XDHPublicKey(enc);
                            }
                            case 110: {
                                return new Prov11XDHPublicKey(enc);
                            }
                            case 113: {
                                return new Prov15EdDSAPublicKey(enc);
                            }
                            case 112: {
                                return new Prov15EdDSAPublicKey(enc);
                            }
                        }
                        return super.engineGeneratePublic(keySpec);
                    }
                    catch (InvalidKeySpecException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new InvalidKeySpecException(e.getMessage(), e);
                    }
                }
            }
            return super.engineGeneratePublic(keySpec);
        }

        @Override
        public PrivateKey generatePrivate(PrivateKeyInfo keyInfo) throws IOException {
            ASN1ObjectIdentifier algOid = keyInfo.getPrivateKeyAlgorithm().getAlgorithm();
            if (this.isXdh) {
                if ((this.specificBase == 0 || this.specificBase == 111) && algOid.equals(EdECObjectIdentifiers.id_X448)) {
                    return new Prov11XDHPrivateKey(keyInfo);
                }
                if ((this.specificBase == 0 || this.specificBase == 110) && algOid.equals(EdECObjectIdentifiers.id_X25519)) {
                    return new Prov11XDHPrivateKey(keyInfo);
                }
            } else if (algOid.equals(EdECObjectIdentifiers.id_Ed448) || algOid.equals(EdECObjectIdentifiers.id_Ed25519)) {
                if ((this.specificBase == 0 || this.specificBase == 113) && algOid.equals(EdECObjectIdentifiers.id_Ed448)) {
                    return new Prov15EdDSAPrivateKey(keyInfo);
                }
                if ((this.specificBase == 0 || this.specificBase == 112) && algOid.equals(EdECObjectIdentifiers.id_Ed25519)) {
                    return new Prov15EdDSAPrivateKey(keyInfo);
                }
            }
            throw new IOException("algorithm identifier " + algOid + " in key not recognized");
        }

        @Override
        public PublicKey generatePublic(SubjectPublicKeyInfo keyInfo) throws IOException {
            ASN1ObjectIdentifier algOid = keyInfo.getAlgorithm().getAlgorithm();
            if (this.isXdh) {
                if ((this.specificBase == 0 || this.specificBase == 111) && algOid.equals(EdECObjectIdentifiers.id_X448)) {
                    return new Prov11XDHPublicKey(keyInfo.getEncoded());
                }
                if ((this.specificBase == 0 || this.specificBase == 110) && algOid.equals(EdECObjectIdentifiers.id_X25519)) {
                    return new Prov11XDHPublicKey(keyInfo.getEncoded());
                }
            } else if (algOid.equals(EdECObjectIdentifiers.id_Ed448) || algOid.equals(EdECObjectIdentifiers.id_Ed25519)) {
                if ((this.specificBase == 0 || this.specificBase == 113) && algOid.equals(EdECObjectIdentifiers.id_Ed448)) {
                    return new Prov15EdDSAPublicKey(keyInfo.getEncoded());
                }
                if ((this.specificBase == 0 || this.specificBase == 112) && algOid.equals(EdECObjectIdentifiers.id_Ed25519)) {
                    return new Prov15EdDSAPublicKey(keyInfo.getEncoded());
                }
            }
            throw new IOException("algorithm identifier " + algOid + " in key not recognized");
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        static class Ed25519
        extends KeyFactorySpi {
            public Ed25519() {
                super("Ed25519", false, 112);
            }
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        static class Ed448
        extends KeyFactorySpi {
            public Ed448() {
                super("Ed448", false, 113);
            }
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        static class EdDSA
        extends KeyFactorySpi {
            public EdDSA() {
                super("EdDSA", false, 0);
            }
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        static class X25519
        extends KeyFactorySpi {
            public X25519() {
                super("X25519", true, 110);
            }
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        static class X448
        extends KeyFactorySpi {
            public X448() {
                super("X448", true, 111);
            }
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        static class XDH
        extends KeyFactorySpi {
            public XDH() {
                super("XDH", true, 0);
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class XDHParametersCreator
    implements ParametersCreator {
        private final EdEC.Parameters params;

        XDHParametersCreator(EdEC.Parameters params) {
            this.params = params;
        }

        public Parameters createParameters(boolean forEncryption, AlgorithmParameterSpec spec, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (spec != null) {
                throw new InvalidAlgorithmParameterException("unable to take parameter specs");
            }
            return this.params;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class KeyPairGeneratorSpi
    extends KeyPairGenerator {
        private final BouncyCastleFipsProvider provider;
        private final boolean isXDH;
        private EdEC.Parameters params;
        private AsymmetricKeyPairGenerator engine;
        private SecureRandom random;
        private boolean initialised = false;

        public KeyPairGeneratorSpi(BouncyCastleFipsProvider provider, boolean isXDH, EdEC.Parameters params) {
            super(params != null ? ((GeneralAlgorithm)params.getAlgorithm()).getName() : (isXDH ? "XDH" : "EdDSA"));
            this.params = params;
            this.provider = provider;
            this.isXDH = isXDH;
        }

        @Override
        public void initialize(int strength) {
            this.initialize(strength, this.provider.getDefaultSecureRandom());
        }

        @Override
        public void initialize(int strength, SecureRandom secureRandom) {
            this.random = secureRandom;
            switch (strength) {
                case 255: 
                case 256: {
                    if (this.isXDH) {
                        if (this.params != null && this.params != EdEC.X25519) {
                            throw new InvalidParameterException("key size not configurable");
                        }
                        this.params = EdEC.X25519;
                        break;
                    }
                    if (this.params != null && this.params != EdEC.Ed25519) {
                        throw new InvalidParameterException("key size not configurable");
                    }
                    this.params = EdEC.Ed25519;
                    break;
                }
                case 448: {
                    if (this.isXDH) {
                        if (this.params != null && this.params != EdEC.X448) {
                            throw new InvalidParameterException("key size not configurable");
                        }
                        this.params = EdEC.X448;
                        break;
                    }
                    if (this.params != null && this.params != EdEC.Ed448) {
                        throw new InvalidParameterException("key size not configurable");
                    }
                    this.params = EdEC.Ed448;
                    break;
                }
                default: {
                    throw new InvalidParameterException("unknown key size.");
                }
            }
        }

        @Override
        public void initialize(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
            this.initialize(params, this.provider.getDefaultSecureRandom());
        }

        @Override
        public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (params instanceof ECGenParameterSpec) {
                this.params = this.getParams(((ECGenParameterSpec)params).getName());
            } else if (!this.isXDH && params instanceof EdDSAParameterSpec) {
                this.params = this.getParams(((EdDSAParameterSpec)params).getCurveName());
            } else if (this.isXDH && params instanceof XDHParameterSpec) {
                this.params = this.getParams(((XDHParameterSpec)params).getCurveName());
            } else {
                if (params == null) {
                    throw new InvalidAlgorithmParameterException("parameterSpec cannot be null");
                }
                String name = ProvEC.getNameFrom(params);
                if (name != null) {
                    this.params = this.getParams(name);
                } else {
                    throw new InvalidAlgorithmParameterException("AlgorithmParameterSpec not recognized: " + params.getClass().getName());
                }
            }
            this.random = random;
        }

        private EdEC.Parameters getParams(String name) throws InvalidAlgorithmParameterException {
            if (this.isXDH) {
                if (name.equalsIgnoreCase("X448") || name.equals(EdECObjectIdentifiers.id_X448.getId())) {
                    return EdEC.X448;
                }
                if (name.equalsIgnoreCase("X25519") || name.equals(EdECObjectIdentifiers.id_X25519.getId())) {
                    return EdEC.X25519;
                }
                throw new InvalidAlgorithmParameterException("unknown curve name: " + name);
            }
            if (name.equalsIgnoreCase("Ed448") || name.equals(EdECObjectIdentifiers.id_Ed448.getId())) {
                return EdEC.Ed448;
            }
            if (name.equalsIgnoreCase("Ed25519") || name.equals(EdECObjectIdentifiers.id_Ed25519.getId())) {
                return EdEC.Ed25519;
            }
            throw new InvalidAlgorithmParameterException("unknown curve name: " + name);
        }

        @Override
        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                if (this.params == null) {
                    throw new IllegalStateException("generator not correctly initialized");
                }
                if (this.random == null) {
                    this.random = this.provider.getDefaultSecureRandom();
                }
                this.engine = this.isXDH ? new EdEC.XDHKeyPairGenerator(this.params, this.random) : new EdEC.EdDSAKeyPairGenerator(this.params, this.random);
                this.initialised = true;
            }
            AsymmetricKeyPair pair = this.engine.generateKeyPair();
            if (this.isXDH) {
                AsymmetricXDHPublicKey pub = (AsymmetricXDHPublicKey)pair.getPublicKey();
                AsymmetricXDHPrivateKey priv = (AsymmetricXDHPrivateKey)pair.getPrivateKey();
                return new KeyPair(new Prov11XDHPublicKey(pub), new Prov11XDHPrivateKey(priv));
            }
            AsymmetricEdDSAPublicKey pub = (AsymmetricEdDSAPublicKey)pair.getPublicKey();
            AsymmetricEdDSAPrivateKey priv = (AsymmetricEdDSAPrivateKey)pair.getPrivateKey();
            return new KeyPair(new Prov15EdDSAPublicKey(pub), new Prov15EdDSAPrivateKey(priv, pub));
        }
    }
}

