/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder.vertx;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.ReplyFailure;
import io.vertx.core.spi.metrics.EventBusMetrics;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;

public class VertxEventBusMetrics
implements EventBusMetrics<Handler> {
    private final Tags tags;
    private final MeterRegistry registry;
    private final Handler ignored;
    private Map<String, Handler> handlers = new ConcurrentHashMap<String, Handler>();
    private final Meter.MeterProvider<Counter> published;
    private final Meter.MeterProvider<Counter> sent;
    private final Meter.MeterProvider<DistributionSummary> written;
    private final Meter.MeterProvider<DistributionSummary> read;
    private final Meter.MeterProvider<Counter> replyFailures;

    VertxEventBusMetrics(MeterRegistry registry, Tags tags) {
        this.registry = registry;
        this.tags = tags;
        this.ignored = new Handler(null);
        this.published = Counter.builder((String)"eventBus.published").description("Number of messages published to the event bus").withRegistry(registry);
        this.sent = Counter.builder((String)"eventBus.sent").description("Number of messages sent to the event bus").withRegistry(registry);
        this.written = DistributionSummary.builder((String)"eventBus.bytes.written").description("Track the number of bytes written to the distributed event bus").withRegistry(registry);
        this.read = DistributionSummary.builder((String)"eventBus.bytes.read").description("The number of bytes read from the distributed event bus").withRegistry(registry);
        this.replyFailures = Counter.builder((String)"eventBus.replyFailures").description("Count the number of reply failure").withRegistry(registry);
    }

    private static boolean isInternal(String address) {
        return address.startsWith("__vertx.");
    }

    public Handler handlerRegistered(String address, String repliedAddress) {
        if (VertxEventBusMetrics.isInternal(address)) {
            return this.ignored;
        }
        return this.handlers.computeIfAbsent(address, a -> new Handler(address)).increment();
    }

    public void handlerUnregistered(Handler handler) {
        if (VertxEventBusMetrics.isValid(handler) && this.handlers.get(handler.address).decrement()) {
            this.handlers.remove(handler.address);
        }
    }

    public void scheduleMessage(Handler handler, boolean b) {
    }

    public void messageDelivered(Handler handler, boolean local) {
        if (VertxEventBusMetrics.isValid(handler)) {
            handler.delivered();
        }
    }

    public void discardMessage(Handler handler, boolean local, Message<?> msg) {
        if (VertxEventBusMetrics.isValid(handler)) {
            handler.discarded();
        }
    }

    public void messageSent(String address, boolean publish, boolean local, boolean remote) {
        if (!VertxEventBusMetrics.isInternal(address)) {
            if (publish) {
                ((Counter)this.published.withTags((Iterable)this.tags.and("address", address))).increment();
            } else {
                ((Counter)this.sent.withTags((Iterable)this.tags.and("address", address))).increment();
            }
        }
    }

    public void messageWritten(String address, int numberOfBytes) {
        if (!VertxEventBusMetrics.isInternal(address)) {
            ((DistributionSummary)this.written.withTags((Iterable)this.tags.and("address", address))).record((double)numberOfBytes);
        }
    }

    public void messageRead(String address, int numberOfBytes) {
        if (!VertxEventBusMetrics.isInternal(address)) {
            ((DistributionSummary)this.read.withTags((Iterable)this.tags.and("address", address))).record((double)numberOfBytes);
        }
    }

    public void replyFailure(String address, ReplyFailure failure) {
        if (!VertxEventBusMetrics.isInternal(address)) {
            ((Counter)this.replyFailures.withTags((Iterable)this.tags.and(new String[]{"address", address, "failure", failure.name()}))).increment();
        }
    }

    public void close() {
    }

    private static boolean isValid(Handler handler) {
        return handler != null && handler.address != null;
    }

    class Handler {
        private final String address;
        private final LongAdder count;
        private final LongAdder delivered;
        private final LongAdder discarded;

        Handler(String address) {
            if (address == null) {
                this.address = null;
                this.count = null;
                this.delivered = null;
                this.discarded = null;
                return;
            }
            this.address = address;
            this.count = new LongAdder();
            this.delivered = new LongAdder();
            this.discarded = new LongAdder();
            Gauge.builder((String)"eventBus.handlers", this.count::longValue).description("Number of handlers per address").tags((Iterable)VertxEventBusMetrics.this.tags.and("address", address)).register(VertxEventBusMetrics.this.registry);
            Gauge.builder((String)"eventBus.delivered", this.delivered::longValue).description("Number of messages delivered").tags((Iterable)VertxEventBusMetrics.this.tags.and("address", address)).register(VertxEventBusMetrics.this.registry);
            Gauge.builder((String)"eventBus.discarded", this.discarded::longValue).description("Number of messages discarded").tags((Iterable)VertxEventBusMetrics.this.tags.and("address", address)).register(VertxEventBusMetrics.this.registry);
        }

        public Handler increment() {
            this.count.increment();
            return this;
        }

        public boolean decrement() {
            this.count.decrement();
            return this.count.longValue() == 0L;
        }

        public void delivered() {
            this.delivered.increment();
        }

        public void discarded() {
            this.discarded.increment();
        }
    }
}

