/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.util.Map;
import javajs.api.GenericBinaryDocument;
import javajs.util.DataReader;
import javajs.util.Rdr;
import org.jmol.api.Interface;
import org.jmol.api.JmolFilesReaderInterface;
import org.jmol.io.FileReader;
import org.jmol.util.Logger;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Viewer;

public class FilesReader
implements JmolFilesReaderInterface {
    private FileManager fm;
    private Viewer vwr;
    private String[] fullPathNamesIn;
    private String[] namesAsGivenIn;
    private String[] fileTypesIn;
    private Object atomSetCollection;
    private DataReader[] dataReaders;
    private Map<String, Object> htParams;
    private boolean isAppend;

    @Override
    public void set(FileManager fileManager, Viewer vwr, String[] name, String[] nameAsGiven, String[] types, DataReader[] readers, Map<String, Object> htParams, boolean isAppend) {
        this.fm = fileManager;
        this.vwr = vwr;
        this.fullPathNamesIn = name;
        this.namesAsGivenIn = nameAsGiven;
        this.fileTypesIn = types;
        this.dataReaders = readers;
        this.htParams = htParams;
        this.isAppend = isAppend;
    }

    @Override
    public void run() {
        if (!this.isAppend && this.vwr.displayLoadErrors) {
            this.vwr.zap(false, true, false);
        }
        boolean getReadersOnly = !this.vwr.displayLoadErrors;
        this.atomSetCollection = this.vwr.getModelAdapter().getAtomSetCollectionReaders(this, this.fullPathNamesIn, this.fileTypesIn, this.htParams, getReadersOnly);
        this.dataReaders = null;
        if (getReadersOnly && !(this.atomSetCollection instanceof String)) {
            this.atomSetCollection = this.vwr.getModelAdapter().getAtomSetCollectionFromSet(this.atomSetCollection, null, this.htParams);
        }
        if (this.atomSetCollection instanceof String) {
            Logger.error("file ERROR: " + this.atomSetCollection);
            return;
        }
        if (!this.isAppend && !this.vwr.displayLoadErrors) {
            this.vwr.zap(false, true, false);
        }
        this.fm.setFileInfo(new String[]{this.dataReaders == null ? this.fullPathNamesIn[0] : "String[]"});
    }

    @Override
    public Object getBufferedReaderOrBinaryDocument(int i, boolean forceBinary) {
        if (this.dataReaders != null) {
            return forceBinary ? null : this.dataReaders[i].getBufferedReader();
        }
        String name = this.fullPathNamesIn[i];
        if (name.contains("#_DOCACHE_")) {
            return FileReader.getChangeableReader(this.vwr, this.namesAsGivenIn[i], name);
        }
        Object t = this.fm.getUnzippedReaderOrStreamFromName(name, null, false, forceBinary, false, true, this.htParams);
        if (t instanceof BufferedInputStream && Rdr.isZipS((BufferedInputStream)t)) {
            String[] zipDirectory = this.fm.getZipDirectory(name, true, true);
            t = this.fm.getBufferedInputStreamOrErrorMessageFromName(name, this.fullPathNamesIn[i], false, false, null, false, true);
            t = this.fm.getJzu().getAtomSetCollectionOrBufferedReaderFromZip(this.vwr, (BufferedInputStream)t, name, zipDirectory, this.htParams, 1, true);
        }
        return t instanceof BufferedInputStream ? ((GenericBinaryDocument)Interface.getInterface("javajs.util.BinaryDocument", this.vwr, "file")).setStream((BufferedInputStream)t, true) : (t instanceof BufferedReader || t instanceof GenericBinaryDocument ? t : (t == null ? "error opening:" + this.namesAsGivenIn[i] : (String)t));
    }

    @Override
    public Object getAtomSetCollection() {
        return this.atomSetCollection;
    }
}

