/*
 * Decompiled with CFR 0.152.
 */
package io.sf.jclf.text.format;

import io.sf.jclf.text.format.FloatFormat;
import io.sf.jclf.text.format.ObjectFormat;
import io.sf.jclf.text.format.SpecParsingException;
import io.sf.jclf.text.format.StringFormat;
import io.sf.jclf.text.format.TemplateItem;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FormatPrinter {
    protected String formato;
    protected List<TemplateItem> items = new ArrayList<TemplateItem>();
    private String nullStrText = null;
    private DecimalFormatSymbols symbols;

    public FormatPrinter(String string) throws SpecParsingException {
        this(string, new DecimalFormatSymbols(), "");
    }

    public FormatPrinter(String string, DecimalFormatSymbols decimalFormatSymbols) throws SpecParsingException {
        this(string, decimalFormatSymbols, "");
    }

    public FormatPrinter(String string, String string2) throws SpecParsingException {
        this(string, new DecimalFormatSymbols(), string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FormatPrinter(String string, DecimalFormatSymbols decimalFormatSymbols, String string2) throws SpecParsingException {
        int n;
        this.nullStrText = string2;
        this.symbols = decimalFormatSymbols;
        this.formato = string;
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n2 = 0;
        while ((n = this.formato.indexOf(36, n2)) >= 0) {
            stringBuilder.append(string.substring(n2, n));
            n2 = string.indexOf(123, ++n);
            if (n2 == -1) {
                n2 = n + 1;
                continue;
            }
            if (n == n2) {
                TemplateItem templateItem;
                if ((n2 = string.indexOf(125, ++n)) < 0) throw new SpecParsingException("Unmatched '${' pair at char " + Integer.toString(n));
                String string3 = string.substring(n, n2);
                int n3 = string3.indexOf(44);
                int n4 = stringBuilder.length();
                if (n3 < 0) {
                    StringFormat stringFormat = new StringFormat();
                    ((ObjectFormat)stringFormat).setFormat("s");
                    templateItem = new TemplateItem(string3.trim(), stringFormat, n4);
                    this.items.add(templateItem);
                } else {
                    ObjectFormat objectFormat = ObjectFormat.create(string3.substring(n3 + 1).trim());
                    if (objectFormat instanceof FloatFormat) {
                        ((FloatFormat)objectFormat).setDecimalFormatSymbols(decimalFormatSymbols);
                    }
                    templateItem = new TemplateItem(string3.substring(0, n3).trim(), objectFormat, n4);
                    this.items.add(templateItem);
                }
            } else {
                stringBuilder.append('$');
                n2 = n - 1;
            }
            ++n2;
        }
        stringBuilder.append(string.substring(n2));
        this.formato = stringBuilder.toString();
    }

    public String format(ResultSet resultSet) throws SQLException {
        int n = this.formato.length();
        StringBuilder stringBuilder = new StringBuilder((int)((double)n * 1.2));
        Iterator<TemplateItem> iterator = this.items.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            TemplateItem templateItem = iterator.next();
            int n3 = templateItem.getPos();
            stringBuilder.append(this.formato.substring(n2, n3));
            Object object = resultSet.getObject(templateItem.getName());
            if (object instanceof java.sql.Date) {
                object = new Date(((java.sql.Date)object).getTime());
            }
            this.addFormattedObject(stringBuilder, templateItem, object);
            n2 = n3;
        }
        if (n2 < n) {
            stringBuilder.append(this.formato.substring(n2));
        }
        return stringBuilder.toString();
    }

    public String format(Map<String, ? extends Object> map) {
        int n = this.formato.length();
        StringBuilder stringBuilder = new StringBuilder((int)((double)n * 1.2));
        Iterator<TemplateItem> iterator = this.items.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            TemplateItem templateItem = iterator.next();
            int n3 = templateItem.getPos();
            stringBuilder.append(this.formato.substring(n2, n3));
            Object object = map.get(templateItem.getName());
            this.addFormattedObject(stringBuilder, templateItem, object);
            n2 = n3;
        }
        if (n2 < n) {
            stringBuilder.append(this.formato.substring(n2));
        }
        return stringBuilder.toString();
    }

    public String format(Object[] objectArray) {
        int n = this.formato.length();
        StringBuilder stringBuilder = new StringBuilder((int)((double)n * 1.2));
        Iterator<TemplateItem> iterator = this.items.iterator();
        int n2 = 0;
        for (int i = 0; iterator.hasNext() && i < objectArray.length; ++i) {
            TemplateItem templateItem = iterator.next();
            int n3 = templateItem.getPos();
            stringBuilder.append(this.formato.substring(n2, n3));
            Object object = objectArray[i];
            this.addFormattedObject(stringBuilder, templateItem, object);
            n2 = n3;
        }
        if (n2 < n) {
            stringBuilder.append(this.formato.substring(n2));
        }
        return stringBuilder.toString();
    }

    public String sample() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Iterator<TemplateItem> iterator = this.getFormats();
        while (iterator.hasNext()) {
            TemplateItem templateItem = iterator.next();
            ObjectFormat objectFormat = templateItem.getFormat();
            hashMap.put(templateItem.getName(), objectFormat.sample());
        }
        return this.format(hashMap);
    }

    protected void addFormattedObject(StringBuilder stringBuilder, TemplateItem templateItem, Object object) {
        if (object != null) {
            try {
                stringBuilder.append(templateItem.getFormat().format(object));
            }
            catch (RuntimeException runtimeException) {
                String string = "Cannot format object of name " + templateItem.getName() + ", value: " + (object == null ? "null" : object.toString());
                throw new RuntimeException(string, runtimeException);
            }
        } else if (this.nullStrText != null) {
            stringBuilder.append(this.nullStrText);
        } else {
            stringBuilder.append(templateItem.toString());
        }
    }

    public Iterator<TemplateItem> getFormats() {
        return this.items.iterator();
    }

    public boolean hasArguments() {
        return !this.items.isEmpty();
    }

    public void setDecimalFormatSymbols(DecimalFormatSymbols decimalFormatSymbols) {
        try {
            this.symbols = (DecimalFormatSymbols)decimalFormatSymbols.clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Iterator<TemplateItem> iterator = this.getFormats();
        while (iterator.hasNext()) {
            ObjectFormat objectFormat = iterator.next().getFormat();
            if (!(objectFormat instanceof FloatFormat)) continue;
            ((FloatFormat)objectFormat).setDecimalFormatSymbols(decimalFormatSymbols);
        }
    }

    public DecimalFormatSymbols getDecimalFormatSymbols() {
        return this.symbols;
    }

    public String toString() {
        return this.formato;
    }
}

