/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.execution;

import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstantiationAwareExtension;
import org.junit.jupiter.engine.config.JupiterConfiguration;

@FunctionalInterface
@API(status=API.Status.INTERNAL, since="5.12")
public interface ExtensionContextSupplier {
    public static ExtensionContextSupplier create(ExtensionContext currentExtensionContext, ExtensionContext legacyExtensionContext, JupiterConfiguration configuration) {
        if (currentExtensionContext == legacyExtensionContext || configuration.getDefaultTestInstantiationExtensionContextScope() == TestInstantiationAwareExtension.ExtensionContextScope.TEST_METHOD) {
            return __ -> currentExtensionContext;
        }
        return new ScopeBasedExtensionContextSupplier(currentExtensionContext, legacyExtensionContext);
    }

    public ExtensionContext get(TestInstantiationAwareExtension var1);

    public static class ScopeBasedExtensionContextSupplier
    implements ExtensionContextSupplier {
        private final ExtensionContext currentExtensionContext;
        private final ExtensionContext legacyExtensionContext;

        private ScopeBasedExtensionContextSupplier(ExtensionContext currentExtensionContext, ExtensionContext legacyExtensionContext) {
            this.currentExtensionContext = currentExtensionContext;
            this.legacyExtensionContext = legacyExtensionContext;
        }

        @Override
        public ExtensionContext get(TestInstantiationAwareExtension extension) {
            return this.isTestScoped(extension) ? this.currentExtensionContext : this.legacyExtensionContext;
        }

        private boolean isTestScoped(TestInstantiationAwareExtension extension) {
            ExtensionContext rootContext = this.legacyExtensionContext.getRoot();
            return extension.getTestInstantiationExtensionContextScope(rootContext) == TestInstantiationAwareExtension.ExtensionContextScope.TEST_METHOD;
        }
    }
}

